/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.mac;

import iaik.xml.crypto.alg.mac.ProxyMac;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.crypto.dsig.spec.HMACParameterSpec;

public abstract class HMACProxyMac
extends ProxyMac {
    protected int outputLength_ = this.getDefaultOutputLength();

    protected HMACProxyMac() throws NoSuchAlgorithmException, NoSuchProviderException {
    }

    protected abstract int getDefaultOutputLength();

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof HMACParameterSpec) {
            this.outputLength_ = ((HMACParameterSpec)algorithmParameterSpec).getOutputLength();
            if (this.outputLength_ <= 0) {
                throw new InvalidAlgorithmParameterException("HMACOutputLength cannot be <= 0");
            }
        }
        super.engineInit(key, algorithmParameterSpec);
    }

    protected byte[] engineDoFinal() {
        byte[] byArray = super.engineDoFinal();
        int n2 = (8 - this.outputLength_ % 8) % 8;
        int n3 = (this.outputLength_ + n2) / 8;
        if (n2 != 0) {
            int n4 = -1 << n2;
            byArray = (byte[])byArray.clone();
            byte by = byArray[n3 - 1];
            byArray[n3 - 1] = (byte)(by & n4);
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }
}

