/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.mac;

import iaik.xml.crypto.XSecProvider;
import iaik.xml.crypto.alg.mac.a;
import iaik.xml.crypto.alg.mac.b;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Mac;
import javax.crypto.MacSpi;

public abstract class ProxyMac
extends MacSpi {
    Mac a;

    protected ProxyMac() throws NoSuchAlgorithmException, NoSuchProviderException {
        if (!XSecProvider.lateAlgorithmProxyInstantiation()) {
            this.getInstanceUncaught(null);
        }
    }

    protected void getInstanceUncaught(XSecProvider.Purpose purpose) throws NoSuchAlgorithmException, NoSuchProviderException {
        String string = this.getMacName();
        Provider provider = XSecProvider.getDelegationProvider("Mac." + string, purpose);
        if (provider != null) {
            try {
                this.a = Mac.getInstance(string, provider);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                this.a = Mac.getInstance(string, provider.getName());
            }
        }
        if (this.a == null) {
            this.a = Mac.getInstance(string);
        }
    }

    protected void getInstance(XSecProvider.Purpose purpose) {
        if (this.a != null) {
            return;
        }
        try {
            this.getInstanceUncaught(purpose);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new a(this, "Delegation provider not registered, any more.", noSuchProviderException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new b(this, noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
    }

    protected abstract String getMacName();

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.a == null) {
            this.getInstance(null);
        }
        this.a.init(key, algorithmParameterSpec);
    }

    protected int engineGetMacLength() {
        if (this.a == null) {
            throw new IllegalStateException("Mac not initialized");
        }
        return this.a.getMacLength();
    }

    protected void engineUpdate(byte by) {
        if (this.a == null) {
            throw new IllegalStateException("Mac not initialized");
        }
        this.a.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        if (this.a == null) {
            throw new IllegalStateException("Mac not initialized");
        }
        this.a.update(byArray, n2, n3);
    }

    protected void engineUpdate(ByteBuffer byteBuffer) {
        if (this.a == null) {
            throw new IllegalStateException("Mac not initialized");
        }
        this.a.update(byteBuffer);
    }

    protected byte[] engineDoFinal() {
        if (this.a == null) {
            throw new IllegalStateException("Mac not initialized");
        }
        return this.a.doFinal();
    }

    protected void engineReset() {
        if (this.a == null) {
            throw new IllegalStateException("Mac not initialized");
        }
        this.a.reset();
    }
}

