/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig;

import iaik.xml.crypto.XSecProvider;
import iaik.xml.crypto.alg.transform.TransformServiceImpl;
import iaik.xml.crypto.dsig.p;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.crypto.utils.URI;
import iaik.xml.crypto.utils.URIException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Iterator;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransformImpl
extends iaik.xml.crypto.dom.DOMStructure
implements Transform {
    protected URI algorithm_;
    protected DOMStructure params_;
    protected TransformService service_;

    protected TransformImpl() {
    }

    protected TransformImpl(Node node) {
        super(node);
    }

    public TransformImpl(String string, TransformParameterSpec transformParameterSpec) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (string == null) {
            throw new NullPointerException("Argument 'algorithm' must not be null.");
        }
        try {
            this.algorithm_ = new URI(string);
        }
        catch (URIException uRIException) {
            throw new NoSuchAlgorithmException("Algorithm URI '" + string + "' is not RFC 2396 compliant.");
        }
        this.setTransformService();
        this.service_.init(transformParameterSpec);
    }

    public TransformImpl(String string, DOMStructure dOMStructure) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (string == null) {
            throw new NullPointerException("Argument 'algorithm' must not be null.");
        }
        try {
            this.algorithm_ = new URI(string);
        }
        catch (URIException uRIException) {
            throw new NoSuchAlgorithmException("Algorithm URI '" + string + "' is not RFC 2396 compliant.");
        }
        this.setTransformService();
        this.params_ = dOMStructure;
    }

    public TransformImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        try {
            this.setTransformService();
            this.service_.init(this, dOMCryptoContext);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MarshalException(noSuchAlgorithmException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new MarshalException(invalidAlgorithmParameterException);
        }
    }

    public String getLocalName() {
        return "Transform";
    }

    public String getNamespace() {
        return "http://www.w3.org/2000/09/xmldsig#";
    }

    public AlgorithmParameterSpec getParameterSpec() {
        return this.service_.getParameterSpec();
    }

    public Data transform(Data data, XMLCryptoContext xMLCryptoContext) throws TransformException {
        return this.service_.transform(data, xMLCryptoContext);
    }

    public Data transform(Data data, XMLCryptoContext xMLCryptoContext, OutputStream outputStream) throws TransformException {
        return this.service_.transform(data, xMLCryptoContext, outputStream);
    }

    public String getAlgorithm() {
        return this.algorithm_.toString();
    }

    public TransformService getTransformService() {
        return this.service_;
    }

    protected void marshalAttributes(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        super.marshalAttributes(dOMCryptoContext, element);
        Document document = DOMUtils.getOwnerDocument(element);
        Attr attr = document.createAttributeNS("", "Algorithm");
        attr.setValue(this.algorithm_.toString());
        element.setAttributeNodeNS(attr);
    }

    protected void unmarshalAttributes(NamedNodeMap namedNodeMap, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        super.unmarshalAttributes(namedNodeMap, dOMCryptoContext);
        Attr attr = (Attr)namedNodeMap.getNamedItemNS(null, "Algorithm");
        if (attr != null) {
            String string = attr.getValue();
            try {
                this.algorithm_ = new URI(string);
            }
            catch (URIException uRIException) {
                throw new MarshalException("The algorithm URI '" + string + "' is not RFC 2396 compliant.");
            }
        }
    }

    public Node marshal(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        super.marshal(dOMCryptoContext, node, node2);
        if (this.params_ == null) {
            this.service_.marshalParams(this, dOMCryptoContext);
        } else {
            Node node3 = this.params_.getNode();
            Document document = DOMUtils.getOwnerDocument(node);
            do {
                if (node3.getOwnerDocument() == document) {
                    this.getNode().appendChild(node3);
                    continue;
                }
                this.getNode().appendChild(document.importNode(node3, true));
            } while ((node3 = node3.getNextSibling()) != null);
            try {
                this.service_.init(this, dOMCryptoContext);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new MarshalException(invalidAlgorithmParameterException);
            }
        }
        return this.getNode();
    }

    protected void unmarshalStructures(NodeList nodeList, DOMCryptoContext dOMCryptoContext) throws MarshalException {
    }

    protected void clearMarshalling() {
        Iterator iterator = ((TransformServiceImpl)this.service_).getAlgorithmParameters().iterator();
        while (iterator.hasNext()) {
            iaik.xml.crypto.dom.DOMStructure dOMStructure = (iaik.xml.crypto.dom.DOMStructure)iterator.next();
            TransformImpl.clearMarshalling(dOMStructure);
        }
        super.clearMarshalling();
    }

    public String toString() {
        return "TransformService: " + this.service_.getAlgorithm() + "\n" + "MechanismType: " + this.service_.getMechanismType() + " Provider: " + this.service_.getProvider().getName() + "" + "\n" + this.service_.getClass().getName();
    }

    protected void setTransformService() throws NoSuchAlgorithmException {
        String string = this.algorithm_.toString();
        Provider provider = XSecProvider.getDelegationProvider("TransformService." + string, null);
        if (provider != null) {
            try {
                this.service_ = TransformService.getInstance(this.algorithm_.toString(), "DOM", provider);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                try {
                    this.service_ = TransformService.getInstance(this.algorithm_.toString(), "DOM", provider.getName());
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    throw new p(this, noSuchProviderException);
                }
            }
        } else {
            this.service_ = TransformService.getInstance(this.algorithm_.toString(), "DOM");
        }
    }
}

