/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig.keyinfo;

import iaik.security.ecc.ECCException;
import iaik.security.ecc.ecdsa.ECDSAParameter;
import iaik.security.ecc.ecdsa.ECPublicKey;
import iaik.security.ecc.interfaces.ECDSAParams;
import iaik.security.ecc.interfaces.ECDSAPublicKey;
import iaik.security.ecc.math.ecgroup.AffineCoordinate;
import iaik.security.ecc.math.ecgroup.Coordinate;
import iaik.security.ecc.math.ecgroup.ECGroupFactory;
import iaik.security.ecc.math.ecgroup.ECPoint;
import iaik.security.ecc.math.ecgroup.EllipticCurve;
import iaik.security.ecc.math.field.BinaryField;
import iaik.security.ecc.math.field.Field;
import iaik.security.ecc.math.field.FieldElement;
import iaik.security.ecc.math.field.PrimeField;
import iaik.security.ecc.parameter.ECCParameterFactory;
import iaik.security.ecc.spec.ECCParameterSpec;
import iaik.xml.crypto.dsig.keyinfo.ECDSAKeyValueTypeImpl;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.crypto.utils.URI;
import iaik.xml.crypto.utils.URIException;
import java.math.BigInteger;
import java.security.PublicKey;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ECDSAKeyValueImpl
extends ECDSAKeyValueTypeImpl {
    public static final int PRIMEFIELD_TYPE = 1;
    public static final int BINARYFIELD_TYPE = 2;
    public static final String xsiNS = "http://www.w3.org/2001/XMLSchema-instance";
    static Class h;

    public ECDSAKeyValueImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
    }

    public ECDSAKeyValueImpl(PublicKey publicKey) {
        super(publicKey);
        if (!(publicKey instanceof ECDSAPublicKey)) {
            throw new IllegalArgumentException("Argument 'ecdsaPublicKey' must be of type '" + (h == null ? (h = ECDSAKeyValueImpl.b("iaik.security.ecc.interfaces.ECDSAPublicKey")) : h).getName() + "'.");
        }
    }

    public String getLocalName() {
        return "ECDSAKeyValue";
    }

    public String getNamespace() {
        return "http://www.w3.org/2001/04/xmldsig-more#";
    }

    protected void marshalAttributes(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        super.marshalAttributes(dOMCryptoContext, element);
    }

    public Node marshal(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Element element;
        Node node3;
        Element element2;
        Object object;
        Object object2;
        Node node4 = super.marshal(dOMCryptoContext, node, node2);
        dOMCryptoContext.putNamespacePrefix(xsiNS, "xsi");
        Document document = DOMUtils.getOwnerDocument(node);
        String string = dOMCryptoContext.getNamespacePrefix(this.getNamespace(), dOMCryptoContext.getDefaultNamespacePrefix());
        String string2 = this.getNamespace();
        ECDSAPublicKey eCDSAPublicKey = (ECDSAPublicKey)this.publicKey_;
        ECDSAParams eCDSAParams = eCDSAPublicKey.getParameter();
        EllipticCurve ellipticCurve = eCDSAParams.getG().getCurve();
        Field field = ellipticCurve.getField();
        int n2 = field.getFieldId();
        if (eCDSAParams != null) {
            object2 = document.createElementNS(string2, ECDSAKeyValueImpl.getQualifiedName(string, "DomainParameters"));
            object = eCDSAParams.getOID();
            if (object != null) {
                element2 = document.createElementNS(string2, ECDSAKeyValueImpl.getQualifiedName(string, "NamedCurve"));
                node3 = document.createAttributeNS("", "URN");
                node3.setValue("urn:oid:" + eCDSAParams.getOID());
                element2.setAttributeNodeNS((Attr)node3);
                object2.appendChild(element2);
                node4.appendChild((Node)object2);
            } else {
                Element element3;
                Element element4;
                Object object3;
                Object object4;
                Object object5;
                element2 = document.createElementNS(string2, ECDSAKeyValueImpl.getQualifiedName(string, "ExplicitParams"));
                node3 = document.createElementNS(string2, ECDSAKeyValueImpl.getQualifiedName(string, "FieldParams"));
                if (n2 == 1) {
                    element = document.createElementNS(string2, ECDSAKeyValueImpl.getQualifiedName(string, "P"));
                    DOMUtils.addBigIntegerToElement(element, field.getSize());
                    node3.appendChild(element);
                    node3.setAttributeNS(xsiNS, "xsi:type", "PrimeFieldParamsType");
                    DOMUtils.createNSDeclAttribute(dOMCryptoContext, (Element)node3, xsiNS);
                } else if (n2 == 2) {
                    element = (BinaryField)field;
                    object5 = element.getIrreduciblePolynomial();
                    object4 = element.newElement((int[])object5);
                    int n3 = element.getOrder();
                    object3 = new int[3];
                    int n4 = 2;
                    for (int i2 = 1; i2 < n3 - 1; ++i2) {
                        if (!object4.testBit(i2)) continue;
                        object3[n4 - 2] = i2;
                        if (++n4 == 5) break;
                    }
                    switch (n4) {
                        case 3: {
                            Element element5 = document.createElementNS(string2, ECDSAKeyValueImpl.getQualifiedName(string, "M"));
                            DOMUtils.addTextToElement(element5, Integer.toString(element.getOrder(), 10));
                            node3.appendChild(element5);
                            element4 = document.createElementNS(string2, ECDSAKeyValueImpl.getQualifiedName(string, "K"));
                            DOMUtils.addTextToElement(element4, Integer.toString(object3[0], 10));
                            node3.appendChild(element4);
                            node3.setAttributeNS(xsiNS, "xsi:type", "TnBFieldParamsType");
                            DOMUtils.createNSDeclAttribute(dOMCryptoContext, (Element)node3, xsiNS);
                            break;
                        }
                        case 5: {
                            Element element6 = document.createElementNS(string2, ECDSAKeyValueImpl.getQualifiedName(string, "M"));
                            DOMUtils.addTextToElement(element6, Integer.toString(element.getOrder(), 10));
                            node3.appendChild(element6);
                            element3 = document.createElementNS(string2, ECDSAKeyValueImpl.getQualifiedName(string, "K1"));
                            DOMUtils.addTextToElement(element3, Integer.toString(object3[0], 10));
                            node3.appendChild(element3);
                            Element element7 = document.createElementNS(string2, ECDSAKeyValueImpl.getQualifiedName(string, "K2"));
                            DOMUtils.addTextToElement(element7, Integer.toString(object3[1], 10));
                            node3.appendChild(element7);
                            Element element8 = document.createElementNS(string2, ECDSAKeyValueImpl.getQualifiedName(string, "K3"));
                            DOMUtils.addTextToElement(element8, Integer.toString(object3[2], 10));
                            node3.appendChild(element8);
                            node3.setAttributeNS(xsiNS, "xsi:type", "PnBFieldParamsType");
                            DOMUtils.createNSDeclAttribute(dOMCryptoContext, (Element)node3, xsiNS);
                        }
                    }
                } else {
                    throw new MarshalException("Field type not supported!");
                }
                element2.appendChild(node3);
                element = document.createElementNS(string2, ECDSAKeyValueImpl.getQualifiedName(string, "CurveParams"));
                object5 = document.createElementNS(string2, ECDSAKeyValueImpl.getQualifiedName(string, "A"));
                object5.setAttributeNS("", "Value", n2 == 1 ? ellipticCurve.getA().toBigInt().toString(10) : ECDSAKeyValueImpl.d(ellipticCurve.getA().toBigInt().toString(16)));
                element.appendChild((Node)object5);
                object4 = document.createElementNS(string2, ECDSAKeyValueImpl.getQualifiedName(string, "B"));
                object4.setAttributeNS("", "Value", n2 == 1 ? ellipticCurve.getB().toBigInt().toString(10) : ECDSAKeyValueImpl.d(ellipticCurve.getB().toBigInt().toString(16)));
                element.appendChild((Node)object4);
                if (eCDSAParams.getS() != null) {
                    Element element9 = document.createElementNS(string2, ECDSAKeyValueImpl.getQualifiedName(string, "Seed"));
                    element9.appendChild(document.createTextNode(ECDSAKeyValueImpl.d(eCDSAParams.getS().toString(16))));
                    element.appendChild(element9);
                }
                element2.appendChild(element);
                Element element10 = document.createElementNS(string2, ECDSAKeyValueImpl.getQualifiedName(string, "BasePointParams"));
                object3 = eCDSAParams.getG();
                AffineCoordinate affineCoordinate = (AffineCoordinate)object3.getCoordinates().toAffine();
                Element element11 = document.createElementNS(string2, ECDSAKeyValueImpl.getQualifiedName(string, "BasePoint"));
                element10.appendChild(element11);
                if (!object3.isInfinity()) {
                    element4 = document.createElementNS(string2, ECDSAKeyValueImpl.getQualifiedName(string, "X"));
                    element3 = document.createElementNS(string2, ECDSAKeyValueImpl.getQualifiedName(string, "Y"));
                    element11.appendChild(element4);
                    element11.appendChild(element3);
                    element4.setAttributeNS("", "Value", n2 == 1 ? affineCoordinate.getX().toBigInt().toString(10) : ECDSAKeyValueImpl.d(eCDSAParams.getG().getCoordinates().getX().toBigInt().toString(16)));
                    element4.setAttributeNS(xsiNS, "xsi:type", n2 == 1 ? ECDSAKeyValueImpl.getQualifiedName(string, "PrimeFieldElemType") : ECDSAKeyValueImpl.getQualifiedName(string, "CharTwoFieldElemType"));
                    DOMUtils.createNSDeclAttribute(dOMCryptoContext, element4, xsiNS);
                    element3.setAttributeNS("", "Value", n2 == 1 ? affineCoordinate.getY().toBigInt().toString(10) : ECDSAKeyValueImpl.d(eCDSAParams.getG().getCoordinates().getY().toBigInt().toString(16)));
                    element3.setAttributeNS(xsiNS, "xsi:type", n2 == 1 ? ECDSAKeyValueImpl.getQualifiedName(string, "PrimeFieldElemType") : ECDSAKeyValueImpl.getQualifiedName(string, "CharTwoFieldElemType"));
                    DOMUtils.createNSDeclAttribute(dOMCryptoContext, element3, xsiNS);
                }
                element4 = document.createElementNS(string2, ECDSAKeyValueImpl.getQualifiedName(string, "Order"));
                element10.appendChild(element4);
                DOMUtils.addBigIntegerToElement(element4, eCDSAParams.getR());
                if (eCDSAParams.getK() != null) {
                    element3 = document.createElementNS(string2, ECDSAKeyValueImpl.getQualifiedName(string, "Cofactor"));
                    element10.appendChild(element3);
                    DOMUtils.addBigIntegerToElement(element3, eCDSAParams.getK());
                }
                element2.appendChild(element10);
                object2.appendChild(element2);
                node4.appendChild((Node)object2);
            }
        }
        object2 = eCDSAPublicKey.getW();
        object = (AffineCoordinate)object2.getCoordinates().toAffine();
        element2 = document.createElementNS(string2, ECDSAKeyValueImpl.getQualifiedName(string, "PublicKey"));
        if (!object2.isInfinity()) {
            node3 = document.createElementNS(string2, ECDSAKeyValueImpl.getQualifiedName(string, "X"));
            element = document.createElementNS(string2, ECDSAKeyValueImpl.getQualifiedName(string, "Y"));
            node3.setAttributeNS("", "Value", n2 == 1 ? object.getX().toBigInt().toString(10) : ECDSAKeyValueImpl.d(object.getX().toBigInt().toString(16)));
            node3.setAttributeNS(xsiNS, "xsi:type", n2 == 1 ? ECDSAKeyValueImpl.getQualifiedName(string, "PrimeFieldElemType") : ECDSAKeyValueImpl.getQualifiedName(string, "CharTwoFieldElemType"));
            DOMUtils.createNSDeclAttribute(dOMCryptoContext, (Element)node3, xsiNS);
            element.setAttributeNS("", "Value", n2 == 1 ? object.getY().toBigInt().toString(10) : ECDSAKeyValueImpl.d(object.getY().toBigInt().toString(16)));
            element.setAttributeNS(xsiNS, "xsi:type", n2 == 1 ? ECDSAKeyValueImpl.getQualifiedName(string, "PrimeFieldElemType") : ECDSAKeyValueImpl.getQualifiedName(string, "CharTwoFieldElemType"));
            DOMUtils.createNSDeclAttribute(dOMCryptoContext, element, xsiNS);
            element2.appendChild(node3);
            element2.appendChild(element);
        }
        node4.appendChild(element2);
        dOMCryptoContext.putNamespacePrefix(xsiNS, null);
        return node4;
    }

    protected void unmarshalStructures(NodeList nodeList, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        NodeList nodeList2;
        int n2;
        Object object;
        String string;
        Element element;
        Object object2;
        ECCParameterSpec eCCParameterSpec;
        Object object3;
        Object object4;
        if (nodeList == null) {
            return;
        }
        String string2 = this.getNamespace();
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        Element element2 = ECDSAKeyValueImpl.a((Element)this.getNode(), string2, "DomainParameters", 1);
        if (element2 == null) {
            throw new MarshalException("Domain parameters must not be implicit.");
        }
        Element element3 = ECDSAKeyValueImpl.a(element2, string2, "NamedCurve", 1);
        if (element3 != null) {
            try {
                object4 = new URI(element3.getAttributeNS(null, "URN"));
                object3 = ECCParameterFactory.getInstance();
                eCCParameterSpec = object3.getParameterByOID(((URI)object4).getPath().substring(4));
            }
            catch (URIException uRIException) {
                throw new MarshalException("Error when producing a URI from OID: ", uRIException);
            }
        } else {
            BigInteger bigInteger;
            Object object5;
            object4 = ECDSAKeyValueImpl.a(element2, string2, "ExplicitParams", 1);
            object3 = ECDSAKeyValueImpl.a((Element)object4, string2, "FieldParams", 1);
            object2 = ECDSAKeyValueImpl.a((Element)object4, string2, "CurveParams", 1);
            element = ECDSAKeyValueImpl.a((Element)object4, string2, "BasePointParams", 1);
            string = dOMCryptoContext.getNamespacePrefix(string2, null);
            object = null;
            int n3 = 0;
            n2 = -1;
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            int n7 = -1;
            nodeList2 = object3.getChildNodes();
            for (int i2 = 0; i2 < nodeList2.getLength(); ++i2) {
                object5 = nodeList2.item(i2);
                if (object5.getNodeType() != 1) continue;
                if (object5.getLocalName().equals("P")) {
                    if (n3 != 0) {
                        throw new MarshalException("Illegal FieldParameters supplied");
                    }
                    n3 = 1;
                    object = new BigInteger(ECDSAKeyValueImpl.b((Element)object3, string2, "P", 1), 10);
                    continue;
                }
                if (object5.getLocalName().equals("M")) {
                    if (n3 != 0) {
                        throw new MarshalException("Illegal FieldParameters supplied");
                    }
                    n3 = 2;
                    n2 = Integer.parseInt(ECDSAKeyValueImpl.b((Element)object3, string2, "M", 1));
                    continue;
                }
                if (object5.getLocalName().equals("K")) {
                    if (n3 != 2) {
                        throw new MarshalException("Illegal FieldParameters supplied");
                    }
                    n3 = 3;
                    n4 = Integer.parseInt(ECDSAKeyValueImpl.b((Element)object3, string2, "K", 1));
                    continue;
                }
                if (object5.getLocalName().equals("K1")) {
                    if (n3 != 2) {
                        throw new MarshalException("Illegal FieldParameters supplied");
                    }
                    n3 = 4;
                    n5 = Integer.parseInt(ECDSAKeyValueImpl.b((Element)object3, string2, "K1", 1));
                    continue;
                }
                if (object5.getLocalName().equals("K2")) {
                    if (n3 != 4) {
                        throw new MarshalException("Illegal FieldParameters supplied");
                    }
                    n3 = 4;
                    n6 = Integer.parseInt(ECDSAKeyValueImpl.b((Element)object3, string2, "K2", 1));
                    continue;
                }
                if (!object5.getLocalName().equals("K3")) continue;
                if (n3 != 4) {
                    throw new MarshalException("Illegal FieldParameters supplied");
                }
                n3 = 4;
                n7 = Integer.parseInt(ECDSAKeyValueImpl.b((Element)object3, string2, "K3", 1));
            }
            if (n3 == 0) {
                throw new MarshalException("No valid FieldParams found!");
            }
            Element element4 = ECDSAKeyValueImpl.a((Element)object2, string2, "A", 1);
            object5 = element4.getAttributeNS(null, "Value");
            Element element5 = ECDSAKeyValueImpl.a((Element)object2, string2, "B", 1);
            String string3 = element5.getAttributeNS(null, "Value");
            String string4 = ECDSAKeyValueImpl.b((Element)object2, string2, "Seed", 1);
            BigInteger bigInteger2 = string4 != null ? new BigInteger(string4, 10) : null;
            Element element6 = ECDSAKeyValueImpl.a(element, string2, "BasePoint", 1);
            Element element7 = ECDSAKeyValueImpl.a(element6, string2, "X", 1);
            String string5 = element7.getAttributeNS(null, "Value");
            Element element8 = ECDSAKeyValueImpl.a(element6, string2, "Y", 1);
            String string6 = element8.getAttributeNS(null, "Value");
            String string7 = ECDSAKeyValueImpl.b(element, string2, "Order", 1);
            BigInteger bigInteger3 = new BigInteger(string7, 10);
            String string8 = ECDSAKeyValueImpl.b(element, string2, "Cofactor", 1);
            BigInteger bigInteger4 = bigInteger = string8 != null ? new BigInteger(string8, 10) : null;
            if (n3 == 1) {
                BigInteger bigInteger5 = new BigInteger((String)object5, 10);
                BigInteger bigInteger6 = new BigInteger(string3, 10);
                BigInteger bigInteger7 = new BigInteger(string5, 10);
                BigInteger bigInteger8 = new BigInteger(string6, 10);
                eCCParameterSpec = new ECCParameterSpec((BigInteger)object, bigInteger, bigInteger3, bigInteger2, null, bigInteger5, bigInteger6, bigInteger7, bigInteger8, null);
            } else {
                int[] nArray = new int[n2 / 32 + (n2 % 32 != 0 ? 1 : 0)];
                if (n3 == 3) {
                    nArray[n2 / 32] = 1 << n2 % 32;
                    int n8 = n4 / 32;
                    nArray[n8] = nArray[n8] + (1 << n4 % 32);
                    nArray[0] = nArray[0] + 1;
                } else {
                    nArray[n2 / 32] = 1 << n2 % 32;
                    int n9 = n7 / 32;
                    nArray[n9] = nArray[n9] + (1 << n7 % 32);
                    int n10 = n6 / 32;
                    nArray[n10] = nArray[n10] + (1 << n6 % 32);
                    int n11 = n5 / 32;
                    nArray[n11] = nArray[n11] + (1 << n5 % 32);
                    nArray[0] = nArray[0] + 1;
                }
                eCCParameterSpec = new ECCParameterSpec(nArray, bigInteger, bigInteger3, ECDSAKeyValueImpl.e((String)object5), ECDSAKeyValueImpl.e(string3), ECDSAKeyValueImpl.e(string5), ECDSAKeyValueImpl.e(string6), null);
            }
        }
        object4 = ECDSAKeyValueImpl.a((Element)this.getNode(), string2, "PublicKey", 1);
        object3 = ECDSAKeyValueImpl.a((Element)object4, string2, "X", 1);
        object2 = object3.getAttributeNS(null, "Value");
        element = ECDSAKeyValueImpl.a((Element)object4, string2, "Y", 1);
        string = element.getAttributeNS(null, "Value");
        try {
            FieldElement fieldElement;
            FieldElement fieldElement2;
            object = new ECDSAParameter(eCCParameterSpec);
            ECGroupFactory eCGroupFactory = ECGroupFactory.getInstance();
            EllipticCurve ellipticCurve = eCGroupFactory.getCurve(eCCParameterSpec.getA(), eCCParameterSpec.getB(), eCCParameterSpec.getR(), 1);
            Field field = ellipticCurve.getField();
            int n12 = 1;
            int n13 = 2;
            int n14 = n2 = eCCParameterSpec.getGx().getField().getFieldId() == 1 ? n12 : n13;
            if (n2 == n12) {
                PrimeField primeField = (PrimeField)field;
                fieldElement2 = primeField.newElement(new BigInteger((String)object2, 10));
                fieldElement = primeField.newElement(new BigInteger(string, 10));
            } else {
                fieldElement2 = field.newElement(ECDSAKeyValueImpl.f((String)object2));
                fieldElement = field.newElement(ECDSAKeyValueImpl.f(string));
            }
            AffineCoordinate affineCoordinate = new AffineCoordinate(fieldElement2, fieldElement);
            ECPoint eCPoint = ellipticCurve.newPoint((Coordinate)affineCoordinate);
            nodeList2 = new ECPublicKey((ECDSAParams)object, eCPoint);
            this.publicKey_ = nodeList2;
        }
        catch (ECCException eCCException) {
            throw new MarshalException("An error occured during Marshaling the ECDSAKeyValue");
        }
    }

    private static String d(String string) {
        return string.length() % 2 != 0 ? "0" + string : string;
    }

    private static Element a(Element element, String string, String string2, int n2) {
        NodeList nodeList = element.getElementsByTagNameNS(string, string2);
        if (nodeList.getLength() < n2) {
            return null;
        }
        return (Element)nodeList.item(n2 - 1);
    }

    private static String b(Element element, String string, String string2, int n2) {
        Element element2 = ECDSAKeyValueImpl.a(element, string, string2, n2);
        if (element2 == null) {
            return null;
        }
        NodeList nodeList = element2.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node = nodeList.item(i2);
            if (node.getNodeType() != 3) continue;
            return node.getNodeValue();
        }
        return null;
    }

    private static int[] e(String string) {
        int n2 = string.length() / 2;
        int[] nArray = new int[n2 / 4 + (n2 % 4 != 0 ? 1 : 0)];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = string.length() - (i2 + 1) * 2;
            int n4 = Integer.parseInt(string.substring(n3, n3 + 2), 16);
            int n5 = i2 / 4;
            nArray[n5] = nArray[n5] + ((n4 & 0xFF) << i2 % 4 * 8);
        }
        return nArray;
    }

    private static byte[] f(String string) {
        int n2 = string.length() / 2;
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = string.length() - (i2 + 1) * 2;
            byArray[n2 - i2 - 1] = (byte)Integer.parseInt(string.substring(n3, n3 + 2), 16);
        }
        return byArray;
    }

    static Class b(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

