/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig.keyinfo;

import iaik.xml.crypto.dsig.keyinfo.KeyValueType;
import iaik.xml.crypto.utils.DOMUtils;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RSAKeyValueImpl
extends KeyValueType {
    public RSAKeyValueImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.publicKey_ == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    public RSAKeyValueImpl(RSAPublicKey rSAPublicKey) {
        super(rSAPublicKey);
    }

    public String getLocalName() {
        return "RSAKeyValue";
    }

    public Node marshal(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Node node3 = super.marshal(dOMCryptoContext, node, node2);
        Document document = DOMUtils.getOwnerDocument(node);
        String string = dOMCryptoContext.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", dOMCryptoContext.getDefaultNamespacePrefix());
        RSAPublicKey rSAPublicKey = (RSAPublicKey)this.publicKey_;
        BigInteger bigInteger = rSAPublicKey.getModulus();
        BigInteger bigInteger2 = rSAPublicKey.getPublicExponent();
        Element element = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", RSAKeyValueImpl.getQualifiedName(string, "Modulus"));
        Element element2 = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", RSAKeyValueImpl.getQualifiedName(string, "Exponent"));
        RSAKeyValueImpl.addBytesToElement(element, DOMUtils.bigInteger2byteArray(bigInteger), dOMCryptoContext);
        RSAKeyValueImpl.addBytesToElement(element2, DOMUtils.bigInteger2byteArray(bigInteger2), dOMCryptoContext);
        node3.appendChild(element);
        node3.appendChild(element2);
        return node3;
    }

    protected void unmarshalStructures(NodeList nodeList, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Object object;
        if (nodeList == null) {
            return;
        }
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            object = nodeList.item(i2);
            if (object.getNodeType() != 1 || !object.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) continue;
            if (object.getLocalName().equals("Modulus")) {
                bigInteger = new BigInteger(1, RSAKeyValueImpl.getBytesFromElement((Element)object));
                continue;
            }
            if (!object.getLocalName().equals("Exponent")) continue;
            bigInteger2 = new BigInteger(1, RSAKeyValueImpl.getBytesFromElement((Element)object));
        }
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger, bigInteger2);
        try {
            object = KeyFactory.getInstance("RSA");
            this.publicKey_ = (RSAPublicKey)((KeyFactory)object).generatePublic(rSAPublicKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MarshalException("Failed to create RSA key.");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new MarshalException("Failed to create RSA key.");
        }
    }
}

