/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig.keyinfo;

import iaik.utils.RFC2253NameParser;
import iaik.utils.RFC2253NameParserException;
import iaik.xml.crypto.dom.XmldsigDOMStructure;
import iaik.xml.crypto.dsig.keyinfo.c;
import iaik.xml.crypto.dsig.keyinfo.d;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.crypto.utils.Utils;
import java.io.InputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class X509DataImpl
extends XmldsigDOMStructure
implements X509Data {
    protected List content_;
    static Class h;
    static Class i;
    static Class j;
    static Class k;
    static Class l;

    public X509DataImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.content_ = new ArrayList();
        this.unmarshal(dOMCryptoContext);
        if (this.content_.isEmpty()) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    public X509DataImpl(List list) {
        if (list == null) {
            throw new NullPointerException("Argument 'content' must not be null.");
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("List 'content' must not be empty.");
        }
        this.content_ = Utils.copyList(list, new Class[]{h == null ? (h = X509DataImpl.b("java.lang.String")) : h, i == null ? (i = X509DataImpl.b("[B")) : i, j == null ? (j = X509DataImpl.b("java.security.cert.X509Certificate")) : j, k == null ? (k = X509DataImpl.b("java.security.cert.X509CRL")) : k, l == null ? (l = X509DataImpl.b("javax.xml.crypto.XMLStructure")) : l}, "content", false, false);
        Iterator iterator = this.content_.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof String)) continue;
            try {
                new RFC2253NameParser((String)e2).parse();
            }
            catch (RFC2253NameParserException rFC2253NameParserException) {
                throw new c(this, "SubjectName '" + e2 + "' is not RFC 2253 compliant.", rFC2253NameParserException);
            }
        }
    }

    public String getLocalName() {
        return "X509Data";
    }

    public List getContent() {
        return Collections.unmodifiableList(this.content_);
    }

    public Node marshal(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Node node3 = super.marshal(dOMCryptoContext, node, node2);
        Iterator iterator = this.content_.iterator();
        while (iterator.hasNext()) {
            Element element;
            String string;
            Object object;
            Object e2 = iterator.next();
            if (e2 instanceof String) {
                object = DOMUtils.getOwnerDocument(node);
                string = dOMCryptoContext.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", dOMCryptoContext.getDefaultNamespacePrefix());
                element = object.createElementNS("http://www.w3.org/2000/09/xmldsig#", X509DataImpl.getQualifiedName(string, "X509SubjectName"));
                DOMUtils.addTextToElement(element, (String)e2);
                node3.appendChild(element);
                continue;
            }
            if (e2 instanceof byte[]) {
                object = DOMUtils.getOwnerDocument(node);
                string = dOMCryptoContext.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", dOMCryptoContext.getDefaultNamespacePrefix());
                element = object.createElementNS("http://www.w3.org/2000/09/xmldsig#", X509DataImpl.getQualifiedName(string, "X509SKI"));
                X509DataImpl.addBytesToElement(element, (byte[])e2, dOMCryptoContext);
                node3.appendChild(element);
                continue;
            }
            if (e2 instanceof X509Certificate) {
                object = DOMUtils.getOwnerDocument(node);
                string = dOMCryptoContext.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", dOMCryptoContext.getDefaultNamespacePrefix());
                element = object.createElementNS("http://www.w3.org/2000/09/xmldsig#", X509DataImpl.getQualifiedName(string, "X509Certificate"));
                try {
                    X509DataImpl.addBytesToElement(element, ((X509Certificate)e2).getEncoded(), dOMCryptoContext);
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw new MarshalException("Failed to encode X509Certificate.", certificateEncodingException);
                }
                node3.appendChild(element);
                continue;
            }
            if (e2 instanceof X509CRL) {
                object = DOMUtils.getOwnerDocument(node);
                string = dOMCryptoContext.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", dOMCryptoContext.getDefaultNamespacePrefix());
                element = object.createElementNS("http://www.w3.org/2000/09/xmldsig#", X509DataImpl.getQualifiedName(string, "X509CRL"));
                try {
                    X509DataImpl.addBytesToElement(element, ((X509CRL)e2).getEncoded(), dOMCryptoContext);
                }
                catch (CRLException cRLException) {
                    throw new MarshalException("Failed to encode X509CRL.", cRLException);
                }
                node3.appendChild(element);
                continue;
            }
            if (e2 instanceof iaik.xml.crypto.dom.DOMStructure) {
                object = (iaik.xml.crypto.dom.DOMStructure)e2;
                super.putChildStructure((iaik.xml.crypto.dom.DOMStructure)object);
                ((iaik.xml.crypto.dom.DOMStructure)object).marshal(dOMCryptoContext, this.getNode(), null);
                continue;
            }
            if (e2 instanceof DOMStructure) {
                object = ((DOMStructure)e2).getNode();
                if (object.getOwnerDocument() != node3.getOwnerDocument()) {
                    object = node3.getOwnerDocument().importNode((Node)object, true);
                }
                node3.appendChild((Node)object);
                continue;
            }
            throw new MarshalException("X509Data supports the DOM marshaling mechanism only.");
        }
        return node3;
    }

    protected void unmarshalStructures(NodeList nodeList, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        if (nodeList == null) {
            return;
        }
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Object object;
            Object object2;
            Object object3;
            Node node = nodeList.item(i2);
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) continue;
            if (node.getLocalName().equals("X509SubjectName")) {
                object3 = DOMUtils.getAllTextFromChildren((Element)node);
                try {
                    object2 = dOMCryptoContext.getProperty("iaik.xml.crypto.dsig.keyinfo.TrimNames");
                    if (Boolean.TRUE.equals(object2)) {
                        object3 = ((String)object3).trim();
                    }
                    object = new RFC2253NameParser((String)object3).parse();
                    this.content_.add(object.getRFC2253String());
                    continue;
                }
                catch (RFC2253NameParserException rFC2253NameParserException) {
                    throw new d(this, "X509SubjectName '" + (String)object3 + "' is not RFC 2253 compliant.", rFC2253NameParserException);
                }
            }
            if (node.getLocalName().equals("X509SKI")) {
                object3 = X509DataImpl.getBytesFromElement((Element)node);
                this.content_.add(object3);
                continue;
            }
            if (node.getLocalName().equals("X509Certificate")) {
                object3 = X509DataImpl.getBytesFromElementStream((Element)node);
                try {
                    object2 = CertificateFactory.getInstance("X509");
                    object = (X509Certificate)((CertificateFactory)object2).generateCertificate((InputStream)object3);
                    this.content_.add(object);
                    continue;
                }
                catch (CertificateException certificateException) {
                    throw new MarshalException("Failed to parse X509Certificate. " + certificateException.getMessage(), certificateException);
                }
            }
            if (node.getLocalName().equals("X509CRL")) {
                object3 = X509DataImpl.getBytesFromElementStream((Element)node);
                try {
                    object2 = CertificateFactory.getInstance("X509");
                    object = (X509CRL)((CertificateFactory)object2).generateCRL((InputStream)object3);
                    this.content_.add(object);
                    continue;
                }
                catch (CertificateException certificateException) {
                    throw new MarshalException("Failed to parse X509CRL. " + certificateException.getMessage(), certificateException);
                }
                catch (CRLException cRLException) {
                    throw new MarshalException("Failed to parse X509CRL. " + cRLException.getMessage(), cRLException);
                }
            }
            object3 = X509DataImpl.getInstance(node, dOMCryptoContext);
            if (object3 != null) {
                this.content_.add(object3);
                continue;
            }
            this.content_.add(new DOMStructure(node));
        }
    }

    static Class b(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

