/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig.keyinfo;

import iaik.asn1.structures.Name;
import iaik.utils.RFC2253NameParser;
import iaik.utils.RFC2253NameParserException;
import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dsig.keyinfo.e;
import iaik.xml.crypto.utils.DOMUtils;
import java.math.BigInteger;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class X509IssuerSerialType
extends DOMStructure
implements X509IssuerSerial {
    protected Name issuerName_;
    protected BigInteger serialNumber_;

    protected X509IssuerSerialType(Node node) {
        super(node);
    }

    protected X509IssuerSerialType(String string, BigInteger bigInteger) {
        if (string == null) {
            throw new NullPointerException("Argument 'issuerName' must not be null.");
        }
        RFC2253NameParser rFC2253NameParser = new RFC2253NameParser(string);
        try {
            this.issuerName_ = rFC2253NameParser.parse();
        }
        catch (RFC2253NameParserException rFC2253NameParserException) {
            throw new IllegalArgumentException("IssuerName '" + string + "' is not RFC 2253 compliant. " + rFC2253NameParserException.getMessage());
        }
        if (bigInteger == null) {
            throw new NullPointerException("Argument 'serialNumber' must not be null.");
        }
        this.serialNumber_ = bigInteger;
    }

    public String getIssuerName() {
        try {
            return this.issuerName_.getRFC2253String();
        }
        catch (RFC2253NameParserException rFC2253NameParserException) {
            throw new e(this, rFC2253NameParserException.getMessage(), rFC2253NameParserException);
        }
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber_;
    }

    public Node marshal(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Node node3 = super.marshal(dOMCryptoContext, node, node2);
        Document document = DOMUtils.getOwnerDocument(node);
        String string = dOMCryptoContext.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", dOMCryptoContext.getDefaultNamespacePrefix());
        Element element = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", X509IssuerSerialType.getQualifiedName(string, "X509IssuerName"));
        try {
            DOMUtils.addTextToElement(element, this.issuerName_.getRFC2253String());
        }
        catch (RFC2253NameParserException rFC2253NameParserException) {
            throw new MarshalException("Failed to convert issuer DN into an RFC 2253 compliant string. " + rFC2253NameParserException.getMessage(), rFC2253NameParserException);
        }
        node3.appendChild(element);
        Element element2 = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", X509IssuerSerialType.getQualifiedName(string, "X509SerialNumber"));
        DOMUtils.addTextToElement(element2, this.serialNumber_.toString());
        if (!this.isNSDeclInScope(string, "http://www.w3.org/2000/09/xmldsig#")) {
            DOMUtils.createNSDeclAttribute(dOMCryptoContext, element, "http://www.w3.org/2000/09/xmldsig#");
            DOMUtils.createNSDeclAttribute(dOMCryptoContext, element2, "http://www.w3.org/2000/09/xmldsig#");
        }
        node3.appendChild(element2);
        return node3;
    }

    protected void unmarshalStructures(NodeList nodeList, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        if (nodeList == null) {
            return;
        }
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            String string;
            Node node = nodeList.item(i2);
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) continue;
            if (node.getLocalName().equals("X509IssuerName")) {
                string = DOMUtils.getAllTextFromChildren((Element)node);
                Object object = dOMCryptoContext.getProperty("iaik.xml.crypto.dsig.keyinfo.TrimNames");
                if (Boolean.TRUE.equals(object)) {
                    string = string.trim();
                }
                try {
                    this.issuerName_ = new RFC2253NameParser(string).parse();
                    continue;
                }
                catch (RFC2253NameParserException rFC2253NameParserException) {
                    throw new MarshalException("X509IssuerName '" + string + "' is not RFC 2253 compliant.", rFC2253NameParserException);
                }
            }
            if (!node.getLocalName().equals("X509SerialNumber")) continue;
            string = DOMUtils.getAllTextFromChildren((Element)node);
            try {
                this.serialNumber_ = new BigInteger(string);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new MarshalException("Failed to parse X509SerialNumber", numberFormatException);
            }
        }
    }
}

