/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig.spec;

import iaik.xml.crypto.dsig.spec.AlgorithmParameterImpl;
import iaik.xml.crypto.utils.DOMUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XPathParameterImpl
extends AlgorithmParameterImpl {
    protected String xpath_;
    protected Map namespaceMap_;

    public XPathParameterImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.namespaceMap_ = new HashMap();
        this.unmarshal(dOMCryptoContext);
        if (this.xpath_ == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    public XPathParameterImpl(String string, Map map) {
        if (string == null) {
            throw new NullPointerException("Argument 'xpath' must not be null.");
        }
        this.xpath_ = string;
        this.namespaceMap_ = map != null ? map : new HashMap();
    }

    public String getLocalName() {
        return "XPath";
    }

    public String getNamespace() {
        return "http://www.w3.org/2000/09/xmldsig#";
    }

    public String getXpath() {
        return this.xpath_;
    }

    protected Element marshalElement(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Element element = super.marshalElement(dOMCryptoContext, node, node2);
        if (this.xpath_ != null) {
            DOMUtils.addTextToElement(element, this.xpath_);
        }
        return element;
    }

    protected void marshalAttributes(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        super.marshalAttributes(dOMCryptoContext, element);
        if (!this.namespaceMap_.isEmpty()) {
            Document document = DOMUtils.getOwnerDocument(element);
            Set set = this.namespaceMap_.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Attr attr = document.createAttributeNS(DOMUtils.NamespaceSpecNS, "xmlns:" + (String)entry.getKey());
                attr.setValue((String)entry.getValue());
                element.setAttributeNodeNS(attr);
            }
        }
    }

    protected void unmarshalElement(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        super.unmarshalElement(dOMCryptoContext, element);
        this.xpath_ = DOMUtils.getAllTextFromChildren(element);
    }

    protected void unmarshalAttributes(NamedNodeMap namedNodeMap, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        super.unmarshalAttributes(namedNodeMap, dOMCryptoContext);
        for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
            Attr attr = (Attr)namedNodeMap.item(i2);
            if (!DOMUtils.NamespaceSpecNS.equals(attr.getNamespaceURI()) || !attr.getName().startsWith("xmlns:")) continue;
            this.namespaceMap_.put(attr.getLocalName(), attr.getValue());
        }
    }
}

