/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.enc;

import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dsig.keyinfo.KeyInfoImpl;
import iaik.xml.crypto.enc.CarriedKeyNameImpl;
import iaik.xml.crypto.enc.CipherReferenceImpl;
import iaik.xml.crypto.enc.EncryptedTypeImpl;
import iaik.xml.crypto.enc.EncryptionMethodImpl;
import iaik.xml.crypto.enc.ReferenceListImpl;
import iaik.xml.crypto.utils.DOMUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.util.Collections;
import java.util.List;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.enc.EncryptionProperties;
import javax.xml.crypto.enc.ToBeEncryptedKey;
import javax.xml.crypto.enc.XMLDecryptContext;
import javax.xml.crypto.enc.XMLEncryptContext;
import javax.xml.crypto.enc.XMLEncryptionException;
import javax.xml.crypto.enc.dom.DOMEncryptContext;
import javax.xml.crypto.enc.keyinfo.EncryptedKey;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EncryptedKeyImpl
extends EncryptedTypeImpl
implements EncryptedKey {
    protected ReferenceListImpl referenceList_;
    protected CarriedKeyNameImpl carriedKeyName_;
    protected String recipient_;
    protected String keyAlgorithm_;

    public EncryptedKeyImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.cipherData_ == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    public EncryptedKeyImpl(ToBeEncryptedKey toBeEncryptedKey, EncryptionMethodImpl encryptionMethodImpl, KeyInfoImpl keyInfoImpl, EncryptionProperties encryptionProperties, List list, String string, String string2, String string3, CipherReferenceImpl cipherReferenceImpl) {
        super(toBeEncryptedKey, encryptionMethodImpl, keyInfoImpl, encryptionProperties, string, cipherReferenceImpl);
        if (list != null && !list.isEmpty()) {
            this.referenceList_ = new ReferenceListImpl(list);
        }
        if (string2 != null) {
            this.carriedKeyName_ = new CarriedKeyNameImpl(string2);
        }
        this.recipient_ = string3;
    }

    public String getLocalName() {
        return "EncryptedKey";
    }

    public List getReferenceList() {
        return this.referenceList_ != null ? this.referenceList_.getReferences() : Collections.EMPTY_LIST;
    }

    public String getCarriedKeyName() {
        return this.carriedKeyName_ != null ? this.carriedKeyName_.getName() : null;
    }

    public String getRecipient() {
        return this.recipient_;
    }

    protected List getChildStructures() {
        List list = super.getChildStructures();
        if (this.referenceList_ != null) {
            list.add(this.referenceList_);
        }
        if (this.carriedKeyName_ != null) {
            list.add(this.carriedKeyName_);
        }
        return list;
    }

    protected void marshalAttributes(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        super.marshalAttributes(dOMCryptoContext, element);
        Document document = DOMUtils.getOwnerDocument(element);
        if (this.recipient_ != null) {
            Attr attr = document.createAttributeNS("", "Recipient");
            attr.setValue(this.recipient_);
            element.setAttributeNodeNS(attr);
        }
    }

    protected void putChildStructure(DOMStructure dOMStructure) throws MarshalException {
        super.putChildStructure(dOMStructure);
        if (dOMStructure instanceof ReferenceListImpl) {
            this.referenceList_ = (ReferenceListImpl)dOMStructure;
            return;
        }
        if (dOMStructure instanceof CarriedKeyNameImpl) {
            this.carriedKeyName_ = (CarriedKeyNameImpl)dOMStructure;
            return;
        }
    }

    protected void unmarshalAttributes(NamedNodeMap namedNodeMap, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        super.unmarshalAttributes(namedNodeMap, dOMCryptoContext);
        Attr attr = (Attr)namedNodeMap.getNamedItemNS(null, "Recipient");
        if (attr != null) {
            this.recipient_ = attr.getValue();
        }
    }

    public Key decryptKey(XMLDecryptContext xMLDecryptContext, AlgorithmMethod algorithmMethod) throws XMLEncryptionException {
        this.keyAlgorithm_ = algorithmMethod.getAlgorithm();
        Key key = this.selectKey(xMLDecryptContext, false);
        InputStream inputStream = this.cipherData_.getCipherData(xMLDecryptContext);
        Key key2 = null;
        if (this.encryptionMethod_.getAlgorithm().indexOf("kw-") != -1 || this.encryptionMethod_.getAlgorithm().indexOf("rsa-") != -1) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byte[] byArray = new byte[256];
                int n2 = 0;
                while ((n2 = inputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
                byteArrayOutputStream.flush();
            }
            catch (IOException iOException) {
                throw new XMLEncryptionException("Failed to decrypt. " + iOException.getMessage(), iOException);
            }
            key2 = this.encryptionMethod_.unwrapKey(key, byteArrayOutputStream.toByteArray(), this.keyAlgorithm_, 3);
        } else {
            InputStream inputStream2 = this.encryptionMethod_.decrypt(key, inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byte[] byArray = new byte[1024];
                int n3 = 0;
                while ((n3 = inputStream2.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n3);
                }
                byteArrayOutputStream.flush();
            }
            catch (IOException iOException) {
                throw new XMLEncryptionException("Failed to decrypt. " + iOException.getMessage(), iOException);
            }
            key2 = new SecretKeySpec(byteArrayOutputStream.toByteArray(), this.keyAlgorithm_);
        }
        return key2;
    }

    public void encrypt(XMLEncryptContext xMLEncryptContext) throws XMLEncryptionException, MarshalException {
        Object object;
        if (!(xMLEncryptContext instanceof DOMEncryptContext)) {
            throw new XMLEncryptionException("The DOM marshaling mechanism is supported only.");
        }
        DOMEncryptContext dOMEncryptContext = (DOMEncryptContext)xMLEncryptContext;
        if (this.tbe_ == null) {
            throw new XMLEncryptionException("Cannot encrypt an unmarshaled EncryptedKey.");
        }
        if (!(this.tbe_ instanceof ToBeEncryptedKey)) {
            throw new XMLEncryptionException("Failed to encrypt. ToBeEncrypted type '" + this.tbe_ + "' is not supported by EncryptedKey.");
        }
        Key key = this.selectKey(xMLEncryptContext, true);
        Key key2 = ((ToBeEncryptedKey)this.tbe_).getKey();
        byte[] byArray = null;
        if (this.encryptionMethod_.getAlgorithm().indexOf("kw-") != -1 || this.encryptionMethod_.getAlgorithm().indexOf("rsa-") != -1) {
            byArray = this.encryptionMethod_.wrapKey(key, key2);
        } else {
            object = new ByteArrayInputStream(key2.getEncoded());
            InputStream inputStream = this.encryptionMethod_.encrypt(key, (InputStream)object);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byte[] byArray2 = new byte[256];
                int n2 = 0;
                while ((n2 = inputStream.read(byArray2)) != -1) {
                    byteArrayOutputStream.write(byArray2, 0, n2);
                }
                byteArrayOutputStream.flush();
            }
            catch (IOException iOException) {
                throw new XMLEncryptionException("Failed to encrypt. " + iOException.getMessage(), iOException);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        this.cipherData_.setCipherText(byArray);
        object = dOMEncryptContext.getParent();
        if (object != null) {
            this.marshal(dOMEncryptContext, dOMEncryptContext.getParent(), dOMEncryptContext.getNextSibling());
        }
    }
}

