/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.utils;

import iaik.xml.crypto.XSecProvider;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.crypto.utils.MatchDistinguishedName;
import iaik.xml.crypto.utils.X509KeySelectorResult;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.Data;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.RetrievalMethod;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import javax.xml.crypto.enc.XMLEncryptionException;
import javax.xml.crypto.enc.dom.DOMDecryptContext;
import javax.xml.crypto.enc.keyinfo.AgreementMethod;
import javax.xml.crypto.enc.keyinfo.EncryptedKey;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class IndependentKeySelectorImpl
extends KeySelector {
    protected String failReason_;
    private static Class b;
    private static Constructor c;
    static Class a;

    public final KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        KeyInfoHints keyInfoHints = this.newKeyInfoHints(keyInfo, xMLCryptoContext);
        Object object2 = this.select(keyInfoHints, purpose, algorithmMethod, xMLCryptoContext);
        if (object2 != null) {
            arrayList.add(object2);
        }
        object2 = null;
        if (algorithmMethod != null && (object = algorithmMethod.getAlgorithm()) != null) {
            try {
                object2 = KeyFactory.getInstance((String)object);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        if (object2 == null) {
            if (keyInfoHints.encryptedKey_ != null && (object = this.select(keyInfoHints.encryptedKey_, purpose, algorithmMethod, xMLCryptoContext)) != null) {
                arrayList.add(object);
            }
            if (keyInfoHints.agreementMethod_ != null && (object = this.select(keyInfoHints.agreementMethod_, purpose, algorithmMethod, xMLCryptoContext)) != null) {
                arrayList.add(object);
            }
        }
        if (keyInfoHints.keyValue_ != null) {
            arrayList.add(this.select(keyInfoHints.keyValue_, purpose, algorithmMethod, xMLCryptoContext));
        }
        if (!keyInfoHints.x509Data_.isEmpty()) {
            object = null;
            Iterator iterator = keyInfoHints.x509Data_.iterator();
            while (iterator.hasNext() && object == null) {
                object = this.select((X509Data)iterator.next(), purpose, algorithmMethod, xMLCryptoContext);
                if (object == null) continue;
                arrayList.add(object);
            }
        }
        if (keyInfoHints.rawCert_ != null && (object = this.select(keyInfoHints.rawCert_, purpose, algorithmMethod, xMLCryptoContext)) != null) {
            arrayList.add(object);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(this.select(purpose, algorithmMethod, xMLCryptoContext));
        }
        return this.select(keyInfoHints, arrayList.toArray(new KeySelectorResult[arrayList.size()]));
    }

    protected KeyInfoHints newKeyInfoHints(KeyInfo keyInfo, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        return new KeyInfoHints(keyInfo, xMLCryptoContext);
    }

    protected KeySelectorResult select(KeyInfoHints keyInfoHints, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        return null;
    }

    protected KeySelectorResult select(EncryptedKey encryptedKey, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        Key key;
        KeySelector keySelector = xMLCryptoContext.getKeySelector();
        Element element = (Element)((DOMStructure)((Object)encryptedKey)).getNode();
        DOMDecryptContext dOMDecryptContext = new DOMDecryptContext(keySelector, element);
        try {
            key = encryptedKey.decryptKey(dOMDecryptContext, algorithmMethod);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new KeySelectorException("Failed to decrypt EncryptedKey. " + xMLEncryptionException.getMessage(), xMLEncryptionException);
        }
        return new KeySelectorResultImpl(key);
    }

    protected KeySelectorResult select(AgreementMethod agreementMethod, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        return null;
    }

    protected KeySelectorResult select(X509Data x509Data, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        if (purpose != null && purpose != KeySelector.Purpose.VERIFY && purpose != KeySelector.Purpose.ENCRYPT) {
            this.failReason_ = "This KeySelector only supports " + KeySelector.Purpose.VERIFY + " and " + KeySelector.Purpose.ENCRYPT + ".";
        } else if (x509Data != null) {
            Object object;
            Object object2;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList arrayList2 = new ArrayList();
            X509IssuerSerial x509IssuerSerial = null;
            String string = null;
            byte[] byArray = null;
            Iterator iterator = x509Data.getContent().iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                if (object2 instanceof X509Certificate) {
                    object = (X509Certificate[])object2;
                    arrayList.add(object);
                    continue;
                }
                if (object2 instanceof X509CRL) {
                    arrayList2.add(object2);
                    continue;
                }
                if (object2 instanceof String) {
                    string = (String)object2;
                    continue;
                }
                if (object2 instanceof byte[]) {
                    byArray = (byte[])object2;
                    continue;
                }
                if (!(object2 instanceof X509IssuerSerial)) continue;
                x509IssuerSerial = (X509IssuerSerial)object2;
            }
            if (!arrayList.isEmpty()) {
                object2 = new X509Certificate[arrayList.size()];
                arrayList.toArray((T[])object2);
                arrayList.clear();
                try {
                    object = IndependentKeySelectorImpl.convertCertificateChain(object2);
                    arrayList.addAll(Arrays.asList(object));
                }
                catch (Exception exception) {
                    if (exception.getClass().getName().indexOf("CertificateException") != -1) {
                        this.failReason_ = "Error parsing certificate(s) in KeyInfo.";
                    }
                    throw new KeySelectorException(exception);
                }
                object = arrayList.iterator();
                PublicKey publicKey = null;
                while (object.hasNext()) {
                    PublicKey publicKey2;
                    boolean bl;
                    block32: {
                        Object object3;
                        X509Certificate x509Certificate;
                        block31: {
                            x509Certificate = (X509Certificate)object.next();
                            bl = false;
                            publicKey2 = x509Certificate.getPublicKey();
                            this.failReason_ = "";
                            try {
                                object3 = KeyFactory.getInstance(algorithmMethod.getAlgorithm());
                                ((KeyFactory)object3).translateKey(publicKey2);
                                bl = true;
                                if (publicKey != null && !publicKey2.equals(publicKey)) {
                                    this.failReason_ = "Two different certificates in KeyInfo neither belong to the same chain, nor contain the same public key.";
                                    bl = false;
                                    break;
                                }
                                publicKey = publicKey2;
                            }
                            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                                this.failReason_ = "Public key in certificate does not match signature method \"" + algorithmMethod.getAlgorithm() + "\".";
                                bl = false;
                                break;
                            }
                            catch (InvalidKeyException invalidKeyException) {
                                this.failReason_ = "Invalid key for signature method \"" + algorithmMethod.getAlgorithm() + "\".";
                                bl = false;
                                break;
                            }
                            if (string != null) {
                                try {
                                    if (bl &= IndependentKeySelectorImpl.matchSubjectDN(x509Certificate, string)) break block31;
                                    this.failReason_ = "KeyInfo X509SubjectName does not match SubjectDN of KeyInfo X509Certificate.";
                                    break;
                                }
                                catch (Exception exception) {
                                    if (exception.getClass().getName().indexOf("RFC2253NameParserException") != -1) {
                                        this.failReason_ = "Error parsing SubjectDN of certificate in KeyInfo.";
                                    }
                                    throw new KeySelectorException(exception);
                                }
                            }
                        }
                        if (byArray != null && !(bl &= Arrays.equals(byArray, (byte[])(object3 = (Object)x509Certificate.getExtensionValue("2.5.29.14"))))) {
                            this.failReason_ = "X509SKI does not match SubjectDN of KeyInfo X509Certificate.";
                            break;
                        }
                        if (x509IssuerSerial != null) {
                            try {
                                boolean bl2 = true;
                                if (!(bl2 &= IndependentKeySelectorImpl.matchIssuerDN(x509Certificate, x509IssuerSerial))) {
                                    this.failReason_ = "KeyInfo X509IssuerName does not match IssuerDN of KeyInfo X509Certificate. ";
                                }
                                bl &= bl2;
                                boolean bl3 = true;
                                if (!(bl3 &= this.matchIssuerSN(x509Certificate, x509IssuerSerial))) {
                                    this.failReason_ = this.failReason_ + "KeyInfo X509SerialNumber does not match serial number of KeyInfo X509Certificate.";
                                    bl = false;
                                    break;
                                }
                                if (bl) break block32;
                                break;
                            }
                            catch (Exception exception) {
                                if (exception.getClass().getName().indexOf("RFC2253NameParserException") != -1) {
                                    this.failReason_ = "Error parsing IssuerDN of certificate in KeyInfo.";
                                }
                                throw new KeySelectorException(exception);
                            }
                        }
                    }
                    if (!bl) continue;
                    this.failReason_ = null;
                    return new X509KeySelectorResultImpl(publicKey2, arrayList, arrayList2);
                }
            } else {
                this.failReason_ = "No certificate included in X509Data.";
            }
        } else {
            this.failReason_ = "No X509Data included in KeyInfo.";
        }
        return null;
    }

    public static X509Certificate[] convertCertificateChain(Certificate[] certificateArray) throws KeySelectorException {
        if (certificateArray == null) {
            return null;
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
        for (int i2 = 0; i2 < certificateArray.length; ++i2) {
            if (b != null && b.isInstance(certificateArray[i2])) {
                x509CertificateArray[i2] = (X509Certificate)certificateArray[i2];
                continue;
            }
            if (c == null) continue;
            try {
                certificateArray[i2] = (X509Certificate)c.newInstance(new Object[]{certificateArray[i2].getEncoded()});
                continue;
            }
            catch (Exception exception) {
                throw new KeySelectorException(exception);
            }
        }
        return x509CertificateArray;
    }

    protected boolean matchIssuerSN(X509Certificate x509Certificate, X509IssuerSerial x509IssuerSerial) {
        return x509IssuerSerial.getSerialNumber().equals(x509Certificate.getSerialNumber());
    }

    protected static boolean matchSubjectDN(X509Certificate x509Certificate, String string) {
        return MatchDistinguishedName.equals(x509Certificate.getSubjectDN(), string);
    }

    protected static boolean matchIssuerDN(X509Certificate x509Certificate, X509IssuerSerial x509IssuerSerial) throws KeySelectorException {
        return MatchDistinguishedName.equals(x509Certificate.getIssuerDN(), x509IssuerSerial.getIssuerName());
    }

    protected KeySelectorResult select(KeyValue keyValue, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        if (keyValue != null && (purpose == KeySelector.Purpose.VERIFY || purpose == KeySelector.Purpose.ENCRYPT)) {
            PublicKey publicKey;
            try {
                publicKey = keyValue.getPublicKey();
            }
            catch (KeyException keyException) {
                throw new KeySelectorException("Failed to get public key from KeyValue. " + keyException.getMessage(), keyException);
            }
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(algorithmMethod.getAlgorithm());
                Key key = keyFactory.translateKey(publicKey);
                return new KeySelectorResultImpl(key);
            }
            catch (InvalidKeyException invalidKeyException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return null;
    }

    protected KeySelectorResult select(X509Certificate x509Certificate, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        if (purpose != KeySelector.Purpose.VERIFY && purpose != KeySelector.Purpose.ENCRYPT) {
            return null;
        }
        if (x509Certificate != null) {
            PublicKey publicKey;
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(algorithmMethod.getAlgorithm());
                publicKey = (PublicKey)keyFactory.translateKey(x509Certificate.getPublicKey());
            }
            catch (InvalidKeyException invalidKeyException) {
                return null;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return null;
            }
            return new X509KeySelectorResultImpl(publicKey, Collections.nCopies(1, x509Certificate), null);
        }
        return null;
    }

    protected KeySelectorResult select(KeyInfoHints keyInfoHints, KeySelectorResult[] keySelectorResultArray) {
        if (keySelectorResultArray.length == 0) {
            return null;
        }
        return keySelectorResultArray[0];
    }

    protected KeySelectorResult select(KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        return null;
    }

    public String getFailReason() {
        return this.failReason_;
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            b = XSecProvider.classForName("iaik.x509.X509Certificate");
            Class[] classArray = new Class[]{a == null ? (a = IndependentKeySelectorImpl.a("[B")) : a};
            c = b.getConstructor(classArray);
        }
        catch (Throwable throwable) {
            b = null;
            c = null;
        }
    }

    public static class KeyInfoHints
    implements KeyInfo {
        protected EncryptedKey encryptedKey_ = null;
        protected AgreementMethod agreementMethod_ = null;
        protected KeyValue keyValue_ = null;
        protected KeyName keyName_ = null;
        protected List x509Data_ = new ArrayList();
        protected X509Certificate rawCert_ = null;
        private KeyInfo a;

        public KeyInfoHints(KeyInfo keyInfo, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
            if (keyInfo == null) {
                return;
            }
            this.a = keyInfo;
            Iterator iterator = this.getContent().iterator();
            while (iterator.hasNext()) {
                this.collectKeyInfo((XMLStructure)iterator.next(), xMLCryptoContext);
            }
        }

        protected KeyName getKeyName() {
            return this.keyName_;
        }

        protected void collectKeyInfo(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
            if (xMLStructure instanceof EncryptedKey) {
                this.encryptedKey_ = (EncryptedKey)xMLStructure;
            } else if (xMLStructure instanceof AgreementMethod) {
                this.agreementMethod_ = (AgreementMethod)xMLStructure;
            } else if (xMLStructure instanceof KeyValue) {
                this.keyValue_ = (KeyValue)xMLStructure;
            } else if (xMLStructure instanceof KeyName) {
                this.keyName_ = (KeyName)xMLStructure;
            } else if (xMLStructure instanceof X509Data) {
                this.x509Data_.add(xMLStructure);
            } else if (xMLStructure instanceof RetrievalMethod) {
                this.dereferenceRetrievalMethod((RetrievalMethod)xMLStructure, xMLCryptoContext);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void dereferenceRetrievalMethod(RetrievalMethod retrievalMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
            Document document;
            Object object;
            Object object2;
            Object object3;
            Data data;
            if ("http://www.w3.org/2000/09/xmldsig#rawX509Certificate".equals(retrievalMethod.getType())) {
                Data data2;
                try {
                    data2 = retrievalMethod.dereference(xMLCryptoContext);
                }
                catch (URIReferenceException uRIReferenceException) {
                    throw new KeySelectorException("Failed to get certificate from RetrievalMethod, " + uRIReferenceException.getMessage(), uRIReferenceException);
                }
                if (!(data2 instanceof OctetStreamData)) {
                    throw new KeySelectorException("The RetrievalMethod is of Type='http://www.w3.org/2000/09/xmldsig#rawX509Certificate'. Therefore, the dereferenced data must be a valid certificate.");
                }
                InputStream inputStream = ((OctetStreamData)data2).getOctetStream();
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    this.rawCert_ = (X509Certificate)certificateFactory.generateCertificate(inputStream);
                    return;
                }
                catch (CertificateException certificateException) {
                    throw new KeySelectorException("The RetrievalMethod is of Type='http://www.w3.org/2000/09/xmldsig#rawX509Certificate'. Therefore, the dereferenced data must be a valid certificate. " + certificateException.getMessage(), certificateException);
                }
            }
            try {
                data = retrievalMethod.dereference(xMLCryptoContext);
            }
            catch (URIReferenceException uRIReferenceException) {
                throw new KeySelectorException("Failed to dereference RetrievalMethod." + uRIReferenceException.getMessage(), uRIReferenceException);
            }
            if (data instanceof NodeSetData) {
                object3 = null;
                object2 = ((NodeSetData)data).iterator();
                while (object2.hasNext() && object3 == null) {
                    object = (Node)object2.next();
                    if (object.getNodeType() != 1) continue;
                    object3 = (Element)object;
                }
                if (object3 == null) throw new KeySelectorException("Dereferencing RetrievalMethod did not return an XML element.");
                try {
                    document = DOMUtils.newDocument(new Boolean(true), null, null);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new KeySelectorException("Failed to dereference RetrievalMethod." + parserConfigurationException.getMessage(), parserConfigurationException);
                }
                object = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
                document.appendChild((Node)object);
                object.appendChild(document.importNode((Node)object3, true));
            } else {
                try {
                    object3 = (OctetStreamData)data;
                    document = DOMUtils.parse(((OctetStreamData)object3).getOctetStream(), ((OctetStreamData)object3).getURI(), null, xMLCryptoContext);
                }
                catch (SAXException sAXException) {
                    throw new KeySelectorException("Failed to parse Document dereferenced from RetrievalMethod." + sAXException.getMessage(), sAXException);
                }
                catch (IOException iOException) {
                    throw new KeySelectorException("Failed to parse Document dereferenced from RetrievalMethod." + iOException.getMessage(), iOException);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new KeySelectorException("Failed to dereference RetrievalMethod." + parserConfigurationException.getMessage(), parserConfigurationException);
                }
                object3 = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
                object2 = document.getDocumentElement();
                document.replaceChild((Node)object2, (Node)object3);
                object3.appendChild((Node)object2);
            }
            object3 = KeyInfoFactory.getInstance("DOM");
            try {
                object2 = ((KeyInfoFactory)object3).unmarshalKeyInfo(new DOMStructure(document.getDocumentElement()));
            }
            catch (MarshalException marshalException) {
                throw new KeySelectorException("Failed to unmarshal KeyInfo type from dereferenced RetrievalMethod." + marshalException.getMessage(), marshalException);
            }
            object = object2.getContent();
            if (object.isEmpty()) throw new KeySelectorException("Dereferencing RetrievalMethod did not return an KeyInfo element.");
            this.collectKeyInfo((XMLStructure)object.get(0), xMLCryptoContext);
        }

        public List getContent() {
            return this.a.getContent();
        }

        public String getId() {
            return this.a.getId();
        }

        public boolean isFeatureSupported(String string) {
            return this.a.isFeatureSupported(string);
        }

        public void marshal(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext) throws MarshalException {
            this.a.marshal(xMLStructure, xMLCryptoContext);
        }
    }

    public static class X509KeySelectorResultImpl
    implements X509KeySelectorResult {
        protected Key key_;
        protected List certificates_;
        protected List crls_;

        public X509KeySelectorResultImpl(Key key, List list, List list2) {
            this.key_ = key;
            this.certificates_ = list;
            this.crls_ = list2;
        }

        public List getCertificates() {
            return this.certificates_ == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.certificates_);
        }

        public List getCRLs() {
            return this.crls_ == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.crls_);
        }

        public Key getKey() {
            return this.key_;
        }
    }

    public static class KeySelectorResultImpl
    implements KeySelectorResult {
        protected Key key_;

        public KeySelectorResultImpl() {
        }

        public KeySelectorResultImpl(Key key) {
            this.key_ = key;
        }

        public Key getKey() {
            return this.key_;
        }

        public void setKey(Key key) {
            this.key_ = key;
        }
    }
}

