/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.utils;

import iaik.xml.crypto.utils.URIException;
import java.io.File;
import java.net.URLEncoder;
import java.util.StringTokenizer;

public class URI {
    protected static final String UNRESERVED_ = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-_.!~*'()";
    protected static final String RESERVED_ = ";/?:@&=+$,";
    protected static final String SCHEME_CHARS_ = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-_.!~*'()+-.";
    protected static final String AUTHORITY_CHARS_ = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-_.!~*'();:@&=+$,";
    protected static final String PATH_CHARS_ = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-_.!~*'();/:@&=+$,";
    protected static final String QUERY_CHARS_ = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-_.!~*'();/?:@&=+$,";
    protected static final String REFERENCE_CHARS_ = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-_.!~*'();/?:@&=+$,";
    protected static String ADDITIONAL_REFERENCE_CHARS_ = "";
    protected String scheme_ = null;
    protected String authority_ = null;
    protected String path_ = null;
    protected String query_ = null;
    protected String reference_ = null;

    public static void setAdditionalFragmentChars(String string) {
        ADDITIONAL_REFERENCE_CHARS_ = string == null ? "" : string;
    }

    public static URI absolutizeURI(URI uRI, URI uRI2) throws URIException {
        if (uRI == null) {
            throw new NullPointerException("Argument 'base' can not be null");
        }
        if (uRI2 == null) {
            throw new NullPointerException("Argument 'candidate' can not be null");
        }
        URI uRI3 = new URI(uRI2.toString());
        boolean bl = false;
        if (uRI2.scheme_ == null && uRI2.authority_ == null && uRI2.path_ == null && uRI2.query_ == null) {
            return new URI(null, null, null, null, uRI3.reference_);
        }
        if (uRI2.scheme_ != null) {
            return uRI3;
        }
        uRI3.scheme_ = uRI.scheme_;
        if (uRI2.authority_ != null) {
            bl = true;
        } else {
            uRI3.authority_ = uRI.authority_;
        }
        if (!bl && uRI2.path_ != null && !uRI2.path_.startsWith("/")) {
            uRI3.path_ = URI.absolutizePath(uRI.path_, uRI2.path_, '/');
        }
        return uRI3;
    }

    public static String absolutizePath(String string, String string2, char c2) throws URIException {
        int n2;
        int n3;
        if (string == null) {
            throw new NullPointerException("Argument 'basePath' can not be null");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'candidatePath' can not be null");
        }
        if (new File(string2).isAbsolute()) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = string.lastIndexOf(c2) + 1;
        if (n4 != -1) {
            stringBuffer.append(string.substring(0, n4));
        }
        stringBuffer.append(string2);
        String string3 = stringBuffer.toString();
        String string4 = "." + new Character(c2).toString();
        int n5 = 0;
        while ((n3 = string3.indexOf(string4, n5)) != -1) {
            if (n3 == 0 || string3.charAt(n3 - 1) != '.') {
                if (n3 != 0 && string3.charAt(n3 - 1) != c2) {
                    throw new URIException("Further canonicalization of path '" + string3 + "' failed.");
                }
                stringBuffer.delete(n3, n3 + string4.length());
                n5 = n3;
                string3 = stringBuffer.toString();
                continue;
            }
            n5 = n3 + string4.length();
        }
        String string5 = "." + string4;
        n5 = 0;
        while ((n3 = string3.indexOf(string5, n5)) != -1) {
            n2 = n3 + string5.length();
            if (n3 < 2 || string3.charAt(n3 - 1) != c2) {
                throw new URIException("Further canonicalization of path '" + string3 + "' failed.");
            }
            --n3;
            if ((n3 = string3.substring(0, n3).lastIndexOf(c2) + 1) == -1) {
                n3 = 0;
            }
            stringBuffer.delete(n3, n2);
            string3 = stringBuffer.toString();
        }
        String string6 = new Character(c2).toString() + "..";
        if (string3.endsWith(string6)) {
            n2 = string3.length();
            n3 = n2 - string6.length();
            if (n3 == 0) {
                throw new URIException("Further canonicalization of path '" + string3 + "' failed.");
            }
            if ((n3 = string3.substring(0, n3).lastIndexOf(c2)) == -1) {
                n3 = 0;
            }
            stringBuffer.delete(n3, n2);
            string3 = stringBuffer.toString();
        }
        return string3;
    }

    public URI(String string, String string2, String string3, String string4, String string5) {
        if (string != null) {
            this.scheme_ = this.escape(string, SCHEME_CHARS_);
        }
        if (string2 != null) {
            this.authority_ = this.escape(string2, AUTHORITY_CHARS_);
        }
        if (string3 != null) {
            this.path_ = this.escape(string3, PATH_CHARS_);
        }
        if (string4 != null) {
            this.query_ = this.escape(string4, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-_.!~*'();/?:@&=+$,");
        }
        if (string5 != null) {
            this.reference_ = this.escape(string5, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-_.!~*'();/?:@&=+$," + ADDITIONAL_REFERENCE_CHARS_);
        }
    }

    public URI(String string) throws URIException {
        if (string == null) {
            throw new NullPointerException("Argument 'uri' can not be null");
        }
        StringBuffer stringBuffer = new StringBuffer((int)((double)string.length() * 1.2));
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == ' ') {
                stringBuffer.append("%20");
                continue;
            }
            if (c2 > '\u001f' && c2 < '\u007f') {
                stringBuffer.append(c2);
                continue;
            }
            stringBuffer.append(URLEncoder.encode("" + c2));
        }
        string = stringBuffer.toString();
        int n2 = 0;
        this.scheme_ = this.parseComponent(string, n2, SCHEME_CHARS_);
        n2 += this.scheme_.length();
        if (this.scheme_.length() == 0) {
            if (n2 < string.length() && string.charAt(n2) == ':') {
                throw new URIException("URI '" + string + "' can not be parsed successfully.");
            }
            this.scheme_ = null;
        } else if (n2 == string.length() || string.charAt(n2) != ':') {
            this.scheme_ = null;
            n2 = 0;
        } else {
            ++n2;
        }
        if (n2 <= string.length() - 2 && string.substring(n2, n2 + 2).equals("//")) {
            this.authority_ = this.parseComponent(string, n2 += 2, AUTHORITY_CHARS_);
            n2 += this.authority_.length();
        }
        this.path_ = this.parseComponent(string, n2, PATH_CHARS_);
        if ((n2 += this.path_.length()) <= string.length() - 1 && string.substring(n2, n2 + 1).equals("?")) {
            this.query_ = this.parseComponent(string, ++n2, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-_.!~*'();/?:@&=+$,");
            n2 += this.query_.length();
        }
        if (n2 <= string.length() - 1 && string.substring(n2, n2 + 1).equals("#")) {
            this.reference_ = this.parseComponent(string, ++n2, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-_.!~*'();/?:@&=+$," + ADDITIONAL_REFERENCE_CHARS_);
            n2 += this.reference_.length();
        }
        if (n2 < string.length()) {
            throw new URIException("URI '" + string + "' can not be parsed successfully.");
        }
    }

    public String getURIWithoutReference() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.scheme_ != null) {
            stringBuffer.append(this.scheme_ + ":");
        }
        if (this.authority_ != null) {
            stringBuffer.append("//" + this.authority_);
        }
        if (this.path_ != null) {
            stringBuffer.append(this.path_);
        }
        if (this.query_ != null) {
            stringBuffer.append("?" + this.query_);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.scheme_ != null) {
            stringBuffer.append(this.scheme_ + ":");
        }
        if (this.authority_ != null) {
            stringBuffer.append("//" + this.authority_);
        }
        if (this.path_ != null) {
            stringBuffer.append(this.path_);
        }
        if (this.query_ != null) {
            stringBuffer.append("?" + this.query_);
        }
        if (this.reference_ != null) {
            stringBuffer.append("#" + this.reference_);
        }
        return stringBuffer.toString();
    }

    public String toUnescapedString() {
        return this.unescape(this.toString());
    }

    public boolean isEmpty() {
        return this.scheme_ == null && this.authority_ == null && "".equals(this.path_) && this.query_ == null && this.reference_ == null;
    }

    public boolean isReference() {
        return this.scheme_ == null && this.authority_ == null && "".equals(this.path_) && this.query_ == null && this.reference_ != null;
    }

    public boolean isSameDocument() {
        return this.isReference() || this.isEmpty();
    }

    public String getScheme() {
        return this.scheme_;
    }

    public String getSchemeUnescaped() {
        return this.scheme_ == null ? null : this.unescape(this.scheme_);
    }

    public String getAuthority() {
        return this.authority_;
    }

    public String getAuthorityUnescaped() {
        return this.authority_ == null ? null : this.unescape(this.authority_);
    }

    public String getPath() {
        return this.path_;
    }

    public String getPathUnescaped() {
        return this.path_ == null ? null : this.unescape(this.path_);
    }

    public String getQuery() {
        return this.query_;
    }

    public String getQueryUnescaped() {
        return this.query_ == null ? null : this.unescape(this.query_);
    }

    public String getReference() {
        return this.reference_;
    }

    public String getReferenceUnescaped() {
        return this.reference_ == null ? null : this.unescape(this.reference_);
    }

    public boolean isAbsolute() {
        return this.scheme_ != null;
    }

    protected String escape(String string, String string2) {
        byte[] byArray;
        if (string == null) {
            throw new NullPointerException("Argument 'original' can not be null");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'allowedChars' can not be null");
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = byArray[i2] & 0xFF;
            if (n3 < 128 && string2.indexOf((char)n3) != -1) {
                stringBuffer.append((char)n3);
                continue;
            }
            stringBuffer.append('%');
            stringBuffer.append(Integer.toHexString(n3));
        }
        return stringBuffer.toString();
    }

    protected String unescape(String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'escpaed' can not be null");
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n2;
            char c2 = string.charAt(i2);
            if (c2 != '%') {
                stringBuffer.append(c2);
                continue;
            }
            int[] nArray = new int[3];
            nArray[0] = Integer.parseInt(string.substring(i2 + 1, i2 + 3), 16);
            if ((nArray[0] & 0xE0) == 224) {
                nArray[1] = Integer.parseInt(string.substring(i2 + 4, i2 + 6), 16);
                nArray[2] = Integer.parseInt(string.substring(i2 + 7, i2 + 9), 16);
                n2 = ((nArray[0] & 0xF) << 12) + ((nArray[1] & 0x3F) << 6) + (nArray[2] & 0x3F);
                stringBuffer.append((char)n2);
                i2 += 8;
                continue;
            }
            if ((nArray[0] & 0xC0) == 192) {
                nArray[1] = Integer.parseInt(string.substring(i2 + 4, i2 + 6), 16);
                n2 = ((nArray[0] & 0x1F) << 6) + (nArray[1] & 0x3F);
                stringBuffer.append((char)n2);
                i2 += 5;
                continue;
            }
            if ((nArray[0] & 0x80) == 0) {
                stringBuffer.append((char)nArray[0]);
                i2 += 2;
                continue;
            }
            throw new RuntimeException();
        }
        return stringBuffer.toString();
    }

    protected String parseComponent(String string, int n2, String string2) throws URIException {
        int n3;
        if (string == null) {
            throw new NullPointerException("Argument 'uri' can not be null");
        }
        if (n2 < 0 || n2 > string.length()) {
            throw new IllegalArgumentException("Argument 'fromIndex' must me be in [0, uri.legnth()]");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'allowedChars' can not be null");
        }
        if (string2 == AUTHORITY_CHARS_ && n2 < string.length() && string.charAt(n2) == '[' && (n3 = string.indexOf(93, n2 + 1)) != -1) {
            return URI.a(string.substring(n2, n3 + 1));
        }
        string2 = string2 + "%";
        for (n3 = n2; n3 < string.length() && string2.indexOf(string.charAt(n3)) != -1; ++n3) {
        }
        return string.substring(n2, n3);
    }

    private static String a(String string) throws URIException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[.:]", true);
        boolean bl = false;
        int n2 = 8;
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = stringTokenizer.nextToken();
        if (!string2.equals("[")) {
            throw new URIException("ipv6 has top start in URI with '[' " + string);
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string2.equals("[") && string3.equals(":")) {
                bl3 = true;
                string2 = string3;
                continue;
            }
            if (bl3 && !string3.equals(":")) {
                throw new URIException("ipv6 leading single ':' not allowed, has to be \"::\" " + string);
            }
            bl3 = false;
            if (string2.equals(":") && string3.equals(":")) {
                if (bl2) {
                    throw new URIException("ipv6 only one appearance of \"::\" allowed " + string);
                }
                bl2 = true;
                string2 = string3;
                continue;
            }
            if (string2.equals(":") && string3.equals(".")) {
                throw new URIException("\":.\" not allowed " + string);
            }
            if (string2.equals(":") && string3.equals("]")) {
                if (!string.endsWith("::]")) {
                    throw new URIException("not allowed ipv6 ending " + string);
                }
                string2 = string3;
                continue;
            }
            if (string3.equals(":") || string3.equals(".") || string3.equals("]")) {
                int n4;
                String string4 = string2;
                if (string3.equals(".") && n3 == 0) {
                    n2 -= 2;
                    n3 += 4;
                }
                if (n3 > 0 && (string3.equals(".") || string3.equals("]"))) {
                    n4 = -1;
                    try {
                        n4 = Integer.parseInt(string4);
                    }
                    catch (Exception exception) {
                        throw new URIException(" ! (0 >= dec-octet > 255) irregular ipv4 ipv6 mixed address" + string, exception);
                    }
                    if (0 >= n4 || n4 > 255) {
                        throw new URIException(" ! (0 >= dec-octet > 255) irregular ipv4 ipv6 mixed address" + string);
                    }
                    --n3;
                    string2 = string3;
                    continue;
                }
                try {
                    n4 = Integer.parseInt(string4, 16);
                }
                catch (Exception exception) {
                    throw new URIException(" irregular ipv6 address" + string, exception);
                }
                if (string4.length() > 4) {
                    throw new URIException("irregular ipv6 address" + string);
                }
                --n2;
                string2 = string3;
                continue;
            }
            string2 = string3;
        }
        if (!string2.equals("]")) {
            throw new URIException("ipv6 has to stop in URI with ']' " + string);
        }
        if (n3 < 0) {
            throw new URIException("irregular ipv4 address part, too many ipv4 bytes " + string);
        }
        if (n3 > 0) {
            throw new URIException("irregular ipv4 address part, 4 ipv4 bytes needed " + string);
        }
        if (n2 < 0) {
            throw new URIException("irregular ipv6 address, too many ipv6 double bytes " + string);
        }
        if (!bl2 && n2 > 0) {
            throw new URIException("irregular ipv6 address part, more ipv6 double bytes needed " + string);
        }
        return string;
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            return true;
        }
        if (object instanceof URI) {
            URI uRI = (URI)object;
            return this.toUnescapedString().equalsIgnoreCase(uRI.toUnescapedString());
        }
        return this.toString().equalsIgnoreCase(object.toString()) || this.toUnescapedString().equalsIgnoreCase(object.toString());
    }

    public int hashCode() {
        return this.toUnescapedString().toLowerCase().hashCode();
    }

    public URI joinUriReference(URI uRI) {
        String string;
        String string2;
        String string3;
        String string4;
        if (uRI.scheme_ != null && uRI.scheme_.length() != 0) {
            string4 = uRI.scheme_;
            string3 = uRI.authority_;
            string2 = uRI.path_;
            string = uRI.query_;
        } else {
            if (uRI.authority_ != null && uRI.scheme_.length() != 0) {
                string3 = uRI.authority_;
                string2 = URI.c(uRI.path_);
                string = uRI.query_;
            } else {
                if (uRI.path_ == null || uRI.path_.length() == 0) {
                    string2 = this.path_;
                    string = uRI.query_ != null && uRI.query_.length() != 0 ? uRI.query_ : this.query_;
                } else {
                    if (uRI.path_.charAt(0) == '/') {
                        string2 = URI.c(uRI.path_);
                    } else {
                        string2 = this.b(uRI.path_);
                        string2 = URI.c(string2);
                    }
                    string = uRI.query_;
                }
                string3 = this.authority_;
            }
            string4 = this.scheme_;
        }
        return new URI(string4, string3, string2, string, null);
    }

    private String b(String string) {
        if (this.path_ == null) {
            return string;
        }
        int n2 = this.path_.lastIndexOf(47);
        int n3 = this.path_.lastIndexOf("..");
        if (string == null || string.length() == 0) {
            return this.path_;
        }
        if (string.startsWith("/")) {
            return string;
        }
        if (n3 + 2 == this.path_.length() && (n2 == -1 || n2 + 3 == this.path_.length())) {
            return this.path_.substring(0, n3 + 2) + "/" + string;
        }
        return this.path_.substring(0, n2 + 1) + string;
    }

    private static String c(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            if (n2 + 1 < stringBuffer.length() && stringBuffer.charAt(n2) == '/' && stringBuffer.charAt(n2 + 1) == '/') {
                stringBuffer.deleteCharAt(n2);
                continue;
            }
            ++n2;
        }
        StringBuffer stringBuffer2 = new StringBuffer(string.length());
        if (stringBuffer.charAt(0) == '/') {
            stringBuffer.deleteCharAt(0);
            stringBuffer2.append('/');
        }
        n2 = 0;
        while (stringBuffer.length() != 0) {
            int n3;
            int n4;
            if (stringBuffer.length() >= 2 && stringBuffer.charAt(0) == '.' && stringBuffer.charAt(1) == '/') {
                stringBuffer.delete(0, 2);
                continue;
            }
            if (stringBuffer.length() >= 3 && stringBuffer.charAt(0) == '.' && stringBuffer.charAt(1) == '.' && stringBuffer.charAt(2) == '/') {
                stringBuffer.delete(0, 3);
                if (stringBuffer2.length() == 1 && stringBuffer2.charAt(0) == '/') continue;
                stringBuffer2.append("../");
                continue;
            }
            if (stringBuffer.length() >= 2 && stringBuffer.charAt(0) == '/' && stringBuffer.charAt(1) == '.' && (stringBuffer.length() < 3 || stringBuffer.charAt(2) == '/')) {
                stringBuffer.delete(1, stringBuffer.length() < 3 ? 2 : 3);
                continue;
            }
            if (stringBuffer.length() >= 3 && stringBuffer.charAt(0) == '/' && stringBuffer.charAt(1) == '.' && stringBuffer.charAt(2) == '.' && (stringBuffer.length() < 4 || stringBuffer.charAt(3) == '/')) {
                String string2 = stringBuffer.substring(1, 3);
                stringBuffer.delete(1, stringBuffer.length() < 4 ? 3 : 4);
                n4 = stringBuffer2.length();
                if (n4 == 0 || n4 >= 3 && (n4 < 4 || stringBuffer2.charAt(n4 - 4) == '/') && stringBuffer2.charAt(n4 - 3) == '.' && stringBuffer2.charAt(n4 - 2) == '.' && stringBuffer2.charAt(n4 - 1) == '/') {
                    stringBuffer2.append(string2);
                    continue;
                }
                if (n4 >= 2 && (n4 < 3 || stringBuffer2.charAt(n4 - 3) == '/') && stringBuffer2.charAt(n4 - 2) == '.' && stringBuffer2.charAt(n4 - 1) == '.') {
                    stringBuffer2.append("/" + string2);
                    continue;
                }
                int n5 = n4 - 1;
                if (n5 < 0) continue;
                if (stringBuffer2.charAt(n5) == '/') {
                    --n5;
                }
                while (n5 >= 0) {
                    char c2 = stringBuffer2.charAt(n5);
                    if (c2 == '/') {
                        stringBuffer2.deleteCharAt(n5);
                        break;
                    }
                    stringBuffer2.deleteCharAt(n5);
                    --n5;
                }
                if (n5 >= 0 || stringBuffer.length() < 1 || stringBuffer.charAt(0) != '/') continue;
                stringBuffer.deleteCharAt(0);
                continue;
            }
            if (stringBuffer.length() == 1 && stringBuffer.charAt(0) == '.') {
                stringBuffer.deleteCharAt(0);
                continue;
            }
            if (stringBuffer.length() == 2 && stringBuffer.charAt(0) == '.' && stringBuffer.charAt(1) == '.') {
                stringBuffer.delete(0, 3);
                if (stringBuffer2.length() == 1 && stringBuffer2.charAt(0) == '/') continue;
                stringBuffer2.append("..");
                continue;
            }
            for (n3 = 0; n3 < stringBuffer.length(); ++n3) {
                n4 = stringBuffer.charAt(n3);
                if (n3 > 0 && n4 == 47) break;
                stringBuffer2.append((char)n4);
            }
            stringBuffer.delete(0, n3);
        }
        int n6 = stringBuffer2.length();
        if (n6 >= 2 && (n6 < 3 || stringBuffer2.charAt(n6 - 3) == '/') && stringBuffer2.charAt(n6 - 2) == '.' && stringBuffer2.charAt(n6 - 1) == '.') {
            stringBuffer2.append('/');
        }
        return stringBuffer2.toString();
    }
}

