/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.signatures;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;

public abstract class PKCS11Signature
extends SignatureSpi
implements PKCS11EngineClass {
    protected Session b;
    protected TokenManager c;
    protected IAIKPKCS11PublicKey d;
    protected IAIKPKCS11PrivateKey e;
    protected int f;
    protected boolean g;
    protected boolean h;
    protected boolean i;
    protected Signature j;
    protected Mechanism[] k;
    protected MechanismInfo[][] l;

    protected PKCS11Signature() {
    }

    protected Mechanism[] e() {
        if (this.k == null) {
            Mechanism mechanism = (Mechanism)this.c().clone();
            mechanism.setParameters(null);
            this.k = new Mechanism[]{mechanism};
        }
        return this.k;
    }

    protected MechanismInfo[][] f() {
        if (this.l == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setSign(true);
            MechanismInfo mechanismInfo2 = new MechanismInfo();
            mechanismInfo2.setVerify(true);
            this.l = new MechanismInfo[][]{{mechanismInfo, mechanismInfo2}};
        }
        return this.l;
    }

    public boolean isSupportedBy(TokenManager tokenManager) {
        boolean bl;
        try {
            Mechanism[] mechanismArray = this.e();
            MechanismInfo[][] mechanismInfoArray = this.f();
            bl = tokenManager.isMechanismFeatureSupported(mechanismArray, mechanismInfoArray);
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        return bl;
    }

    protected abstract Mechanism c();

    protected void g() {
        DelegateProvider delegateProvider = this.c != null ? this.c.getProvider().getDelegateProvider() : IAIKPkcs11.getGlobalDelegateProvider();
        String string = this.h();
        this.j = delegateProvider.getSignature(string);
        if (this.j == null) {
            throw new IAIKPkcs11Exception("Could not get delegate signature engine for " + string);
        }
    }

    protected abstract String h();

    protected void engineInitVerify(PublicKey publicKey) {
        publicKey = IAIKPkcs11.getGlobalKeyHandler().handleVerificationKey(this.h(), publicKey);
        if (publicKey instanceof IAIKPKCS11Key) {
            this.a(publicKey);
            this.i = false;
        } else if (IAIKPkcs11.isEnableSoftwareDelegation()) {
            this.i = true;
            if (this.j == null) {
                this.g();
            }
            this.j.initVerify(publicKey);
        } else {
            throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        }
    }

    protected void a(PublicKey publicKey) {
        if (!(publicKey instanceof IAIKPKCS11PublicKey)) {
            throw new InvalidKeyException("Public key must be of type iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey!");
        }
        this.d = (IAIKPKCS11PublicKey)publicKey;
        this.c = this.d.getTokenManager();
        this.f = 2;
        this.j();
        this.g = true;
    }

    protected void engineInitSign(PrivateKey privateKey) {
        privateKey = IAIKPkcs11.getGlobalKeyHandler().handleSignatureKey(this.h(), privateKey);
        if (privateKey instanceof IAIKPKCS11Key) {
            this.a(privateKey);
            this.i = false;
        } else if (IAIKPkcs11.isEnableSoftwareDelegation()) {
            this.i = true;
            if (this.j == null) {
                this.g();
            }
            this.j.initSign(privateKey);
        } else {
            throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        }
    }

    protected void i() {
        try {
            if (this.b == null) {
                this.b = this.c.getSession(false);
            }
            this.c.makeAuthorizedSession(this.b, null);
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected void j() {
        this.i();
        try {
            if (this.f == 1) {
                this.b.signInit(this.c(), this.e.getKeyObject());
            } else {
                this.b.verifyInit(this.c(), this.d.getKeyObject());
            }
            this.h = true;
        }
        catch (TokenException tokenException) {
            throw new InvalidKeyException(tokenException.toString());
        }
    }

    protected void k() {
        if (this.h) {
            this.h = false;
            this.c.closeSession(this.b);
            this.b = null;
        } else {
            this.c.disposeSession(this.b);
            this.b = null;
        }
    }

    protected void a(PrivateKey privateKey) {
        if (!(privateKey instanceof IAIKPKCS11PrivateKey)) {
            throw new InvalidKeyException("Private key must be of type iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey!");
        }
        this.e = (IAIKPKCS11PrivateKey)privateKey;
        this.c = this.e.getTokenManager();
        this.f = 1;
        this.j();
        this.g = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineUpdate(byte by) {
        if (this.i) {
            if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
            this.j.update(by);
            return;
        } else {
            this.a(by);
        }
    }

    protected void a(byte by) {
        if (!this.g) {
            throw new SignatureException("Signature object not initialzed");
        }
        byte[] byArray = new byte[]{by};
        this.a(byArray, 0, 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        if (this.i) {
            if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
            this.j.update(byArray, n, n2);
            return;
        } else {
            this.a(byArray, n, n2);
        }
    }

    protected void a(byte[] byArray, int n, int n2) {
        block9: {
            if (!this.g) {
                throw new SignatureException("Signature object not initialzed");
            }
            if (n + n2 > byArray.length) {
                throw new IllegalArgumentException("Arguments must satisfy ((offset + length) <= data.length).");
            }
            if (!this.h) {
                try {
                    this.j();
                }
                catch (InvalidKeyException invalidKeyException) {
                    this.k();
                    throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 signature for next operation: " + invalidKeyException.toString());
                }
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            try {
                if (this.f == 1) {
                    this.b.signUpdate(byArray2);
                    break block9;
                }
                if (this.f == 2) {
                    this.b.verifyUpdate(byArray2);
                    break block9;
                }
                throw new SignatureException("Signature object in undefined state");
            }
            catch (TokenException tokenException) {
                this.k();
                throw new SignatureException(tokenException.toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] engineSign() {
        if (!this.i) return this.d();
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.j.sign();
    }

    protected byte[] d() {
        if (this.f != 1) {
            throw new SignatureException("Signature object not in sign state");
        }
        if (!this.g) {
            throw new SignatureException("Signature object not initialzed");
        }
        if (!this.h) {
            try {
                this.j();
            }
            catch (InvalidKeyException invalidKeyException) {
                this.k();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 signature for next operation: " + invalidKeyException.toString());
            }
        }
        byte[] byArray = null;
        try {
            byArray = this.b.signFinal();
            this.h = false;
        }
        catch (TokenException tokenException) {
            throw new SignatureException(tokenException.toString());
        }
        finally {
            this.k();
        }
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean engineVerify(byte[] byArray) {
        if (!this.i) return this.b(byArray);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.j.verify(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean b(byte[] byArray) {
        boolean bl;
        if (this.f != 2) {
            throw new SignatureException("Signature object not in verify state");
        }
        if (!this.g) {
            throw new SignatureException("Signature object not initialzed");
        }
        if (!this.h) {
            try {
                this.j();
            }
            catch (InvalidKeyException invalidKeyException) {
                this.k();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 signature for next operation: " + invalidKeyException.toString());
            }
        }
        try {
            this.b.verifyFinal(byArray);
            bl = true;
            this.h = false;
        }
        catch (PKCS11Exception pKCS11Exception) {
            long l2 = pKCS11Exception.getErrorCode();
            if (l2 == 192L) {
                bl = false;
                this.h = false;
            } else {
                bl = false;
            }
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        finally {
            this.k();
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        if (this.i) {
            if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
            this.j.setParameter(algorithmParameterSpec);
            return;
        } else {
            this.a(algorithmParameterSpec);
        }
    }

    protected void a(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("This method not supported by this class!");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineSetParameter(String string, Object object) {
        if (this.i) {
            if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
            this.j.setParameter(string, object);
            return;
        } else {
            this.a(string, object);
        }
    }

    protected void a(String string, Object object) {
        throw new UnsupportedOperationException("Method not supported!");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object engineGetParameter(String string) {
        if (!this.i) return this.a(string);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.j.getParameter(string);
    }

    protected Object a(String string) {
        throw new UnsupportedOperationException("Method not supported!");
    }

    protected void finalize() {
        if (this.b != null) {
            this.k();
        }
        super.finalize();
    }
}

