/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.GeneralizedTime;
import iaik.asn1.UTCTime;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class ChoiceOfTime {
    private static final TimeZone a = TimeZone.getTimeZone("GMT");
    private ASN1Object b;

    public ChoiceOfTime() {
        this(new Date(), false);
    }

    public ChoiceOfTime(Date date) {
        this(date, false);
    }

    public ChoiceOfTime(Date date, boolean bl) {
        this(date, bl, true);
    }

    public ChoiceOfTime(Date date, boolean bl, boolean bl2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(a);
        gregorianCalendar.clear();
        gregorianCalendar.setTime(date);
        ASN aSN = bl && gregorianCalendar.get(1) >= 2050 ? ASN.GeneralizedTime : ASN.UTCTime;
        this.a(gregorianCalendar, aSN, bl2);
    }

    public ChoiceOfTime(Date date, ASN aSN) {
        this(date, aSN, true);
    }

    public ChoiceOfTime(Date date, ASN aSN, boolean bl) {
        if (!aSN.equals(ASN.UTCTime) && !aSN.equals(ASN.GeneralizedTime)) {
            throw new IllegalArgumentException("Cannot create ChoiceOfTime for encoding format " + aSN + ". Only UTCTime and GeneralizedTime are allowed!");
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(a);
        gregorianCalendar.clear();
        gregorianCalendar.setTime(date);
        this.a(gregorianCalendar, aSN, bl);
    }

    public ChoiceOfTime(String string, ASN aSN) throws ParseException {
        if (aSN.equals(ASN.UTCTime)) {
            this.b = new UTCTime(string);
        } else if (aSN.equals(ASN.GeneralizedTime)) {
            this.b = new GeneralizedTime(string);
        } else {
            throw new IllegalArgumentException("Cannot create ChoiceOfTime for encoding format " + aSN + ". Only UTCTime and GeneralizedTime are allowed!");
        }
    }

    public ChoiceOfTime(ASN1Object aSN1Object) throws CodingException {
        ASN aSN = aSN1Object.getAsnType();
        if (!aSN.equals(ASN.UTCTime) && !aSN.equals(ASN.GeneralizedTime)) {
            throw new CodingException("Must be a UTCTime or a GeneralizedTime");
        }
        this.b = aSN1Object;
    }

    public ASN1Object toASN1Object() {
        return this.b;
    }

    public ASN getEncodingType() {
        return this.b.getAsnType();
    }

    public void setEncodingType(ASN aSN) throws IllegalArgumentException {
        if (aSN.equals(this.getEncodingType())) {
            return;
        }
        Calendar calendar = this.a();
        this.a(calendar, aSN, true);
    }

    public Date getDate() {
        Calendar calendar = this.a();
        return calendar.getTime();
    }

    private Calendar a() throws IllegalArgumentException {
        String string = (String)this.b.getValue();
        ASN aSN = this.b.getAsnType();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(a);
        gregorianCalendar.clear();
        int n2 = 0;
        int n3 = 0;
        try {
            while (n2 < string.length() - 1) {
                switch (n3) {
                    case 0: {
                        int n4;
                        if (aSN.equals(ASN.UTCTime)) {
                            gregorianCalendar.set(1, n4 += (n4 = Integer.parseInt(string.substring(n2, n2 += 2))) >= 50 ? 1900 : 2000);
                            break;
                        }
                        gregorianCalendar.set(1, new Integer(string.substring(n2, n2 += 4)));
                        break;
                    }
                    case 1: {
                        gregorianCalendar.set(2, new Integer(string.substring(n2, n2 += 2)) - 1);
                        break;
                    }
                    case 2: {
                        gregorianCalendar.set(5, new Integer(string.substring(n2, n2 += 2)));
                        break;
                    }
                    case 3: {
                        gregorianCalendar.set(11, new Integer(string.substring(n2, n2 += 2)));
                        break;
                    }
                    case 4: {
                        gregorianCalendar.set(12, new Integer(string.substring(n2, n2 += 2)));
                        break;
                    }
                    case 5: {
                        if (string.charAt(n2) == '+' || string.charAt(n2) == '-') break;
                        gregorianCalendar.set(13, new Integer(string.substring(n2, n2 += 2)));
                        break;
                    }
                    case 6: {
                        if (string.charAt(n2) != '.' && string.charAt(n2) != ',' || !aSN.equals(ASN.GeneralizedTime)) break;
                        int n4 = ++n2;
                        while (n2 < string.length() && string.charAt(n2) != '+' && string.charAt(n2) != '-' && string.charAt(n2) != 'Z') {
                            ++n2;
                        }
                        if (n2 <= n4) break;
                        String string2 = string.substring(n4, Math.min(n4 + 3, n2));
                        int n5 = 3 - string2.length();
                        if (n5 == 1) {
                            string2 = string2.concat("0");
                        } else if (n5 == 2) {
                            string2 = string2.concat("00");
                        }
                        gregorianCalendar.set(14, new Integer(string2));
                        break;
                    }
                    case 7: {
                        if (string.charAt(n2) == '+') {
                            ((Calendar)gregorianCalendar).add(11, -new Integer(string.substring(++n2, n2 += 2)).intValue());
                            ((Calendar)gregorianCalendar).add(12, -new Integer(string.substring(n2, n2 += 2)).intValue());
                        } else if (string.charAt(n2) == '-') {
                            ((Calendar)gregorianCalendar).add(11, new Integer(string.substring(++n2, n2 += 2)));
                            ((Calendar)gregorianCalendar).add(12, new Integer(string.substring(n2, n2 += 2)));
                        }
                        n2 = string.length();
                        break;
                    }
                    case 8: {
                        n2 = string.length();
                    }
                }
                ++n3;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Error parsing date: " + n2);
        }
        return gregorianCalendar;
    }

    private void a(Calendar calendar, ASN aSN, boolean bl) {
        int n2;
        StringBuffer stringBuffer = aSN.equals(ASN.UTCTime) ? new StringBuffer(ChoiceOfTime.a(calendar.get(1))) : new StringBuffer(String.valueOf(calendar.get(1)));
        stringBuffer.append(ChoiceOfTime.a(calendar.get(2) + 1));
        stringBuffer.append(ChoiceOfTime.a(calendar.get(5)));
        stringBuffer.append(ChoiceOfTime.a(calendar.get(11)));
        stringBuffer.append(ChoiceOfTime.a(calendar.get(12)));
        stringBuffer.append(ChoiceOfTime.a(calendar.get(13)));
        if (bl && aSN.equals(ASN.GeneralizedTime) && (n2 = calendar.get(14)) > 0) {
            stringBuffer.append('.');
            stringBuffer.append(ChoiceOfTime.a(String.valueOf(n2)));
        }
        stringBuffer.append('Z');
        this.b = aSN.equals(ASN.UTCTime) ? new UTCTime(stringBuffer.toString()) : new GeneralizedTime(stringBuffer.toString());
    }

    private static String a(int n2) {
        String string = "0" + String.valueOf(n2);
        return string.substring(string.length() - 2);
    }

    private static String a(String string) {
        int n2;
        for (n2 = string.length() - 1; n2 > 0 && string.charAt(n2) == '0'; --n2) {
        }
        return string.substring(0, n2 + 1);
    }

    public int hashCode() {
        Object object = this.b.getValue();
        return object == null ? -1 : object.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this != object) {
            bl = false;
            if (object instanceof ChoiceOfTime) {
                ChoiceOfTime choiceOfTime = (ChoiceOfTime)object;
                if (this.b != null && choiceOfTime.b != null) {
                    if (this.b.getAsnType().equals(choiceOfTime.b.getAsnType())) {
                        bl = this.b.getValue().equals(choiceOfTime.b.getValue()) ? true : this.getDate().equals(choiceOfTime.getDate());
                    }
                } else {
                    bl = this.b == null && choiceOfTime.b == null;
                }
            }
        }
        return bl;
    }

    public String toString() {
        return this.getDate().toString();
    }
}

