/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.GeneralName;
import java.util.Enumeration;
import java.util.Vector;

public class GeneralNames
implements ASN1Type {
    private Vector a = new Vector();

    public GeneralNames() {
    }

    public GeneralNames(GeneralName generalName) {
        this();
        this.a.addElement(generalName);
    }

    public GeneralNames(ASN1Object aSN1Object) throws CodingException {
        this();
        this.decode(aSN1Object);
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        GeneralName generalName = null;
        if (aSN1Object.isA(ASN.CON_SPEC)) {
            generalName = new GeneralName(aSN1Object);
            this.a.addElement(generalName);
            return;
        }
        for (int i2 = 0; i2 < aSN1Object.countComponents(); ++i2) {
            generalName = new GeneralName(aSN1Object.getComponentAt(i2));
            this.a.addElement(generalName);
        }
    }

    public void addName(GeneralName generalName) {
        this.a.addElement(generalName);
    }

    public void removeAllNames() {
        this.a.removeAllElements();
    }

    public Enumeration getNames() {
        return this.a.elements();
    }

    public GeneralName[] getNames(int n2) {
        Object[] objectArray;
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = this.getNames();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            if (objectArray.getType() != n2) continue;
            vector.addElement(objectArray);
        }
        objectArray = new GeneralName[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean containsGeneralName(int n2) {
        boolean bl = false;
        Enumeration enumeration = this.getNames();
        while (enumeration.hasMoreElements()) {
            GeneralName generalName = (GeneralName)enumeration.nextElement();
            if (generalName.getType() != n2) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public ASN1Object toASN1Object() throws CodingException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            GeneralName generalName = (GeneralName)this.a.elementAt(i2);
            sEQUENCE.addComponent(generalName.toASN1Object());
        }
        return sEQUENCE;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GeneralNames)) {
            return false;
        }
        GeneralNames generalNames = (GeneralNames)object;
        if (this.a.size() != generalNames.a.size()) {
            return false;
        }
        Enumeration enumeration = this.a.elements();
        Enumeration enumeration2 = generalNames.a.elements();
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement().equals(enumeration2.nextElement())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            n2 += enumeration.nextElement().hashCode();
        }
        return n2;
    }

    public boolean contains(GeneralName generalName) {
        if (generalName == null) {
            throw new NullPointerException("generalName must not be null!");
        }
        return this.a.contains(generalName);
    }

    public int size() {
        return this.a.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a.isEmpty()) {
            stringBuffer.append("empty");
        } else {
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                stringBuffer.append(this.a.elementAt(i2) + "\n");
            }
            if (stringBuffer.length() >= 1) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
        }
        return stringBuffer.toString();
    }
}

