/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.PolicyQualifierInfo;

public class PolicyInformation {
    ObjectID a = null;
    PolicyQualifierInfo[] b = null;

    public PolicyInformation(ObjectID objectID, PolicyQualifierInfo[] policyQualifierInfoArray) {
        this.a = objectID;
        this.b = policyQualifierInfoArray;
    }

    public PolicyInformation(ASN1Object aSN1Object) throws CodingException {
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("No PolicyInformation!");
        }
        this.a = (ObjectID)aSN1Object.getComponentAt(0);
        if (aSN1Object.countComponents() == 2) {
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(1);
            this.b = new PolicyQualifierInfo[aSN1Object2.countComponents()];
            for (int i2 = 0; i2 < aSN1Object2.countComponents(); ++i2) {
                PolicyQualifierInfo policyQualifierInfo;
                this.b[i2] = policyQualifierInfo = new PolicyQualifierInfo(aSN1Object2.getComponentAt(i2));
            }
        }
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.a);
        if (this.b != null && this.b.length != 0) {
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            for (int i2 = 0; i2 < this.b.length; ++i2) {
                sEQUENCE2.addComponent(this.b[i2].toASN1Object());
            }
            sEQUENCE.addComponent(sEQUENCE2);
        }
        return sEQUENCE;
    }

    public ObjectID getPolicyIdentifier() {
        return this.a;
    }

    public PolicyQualifierInfo[] getPolicyQualifiers() {
        return this.b;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("policyIdentifier: " + this.a.getName() + "\n");
        if (this.b != null) {
            for (int i2 = 0; i2 < this.b.length; ++i2) {
                stringBuffer.append("policyQualifiers[" + i2 + "]: " + this.b[i2] + "\n");
            }
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }
}

