/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs12;

import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs12.PKCS8ShroudedKeyBag;
import iaik.pkcs.pkcs12.SafeBag;
import iaik.pkcs.pkcs7.Content;
import iaik.pkcs.pkcs7.ContentInfo;
import iaik.pkcs.pkcs7.Data;
import iaik.pkcs.pkcs7.EncryptedContentInfo;
import iaik.pkcs.pkcs7.EncryptedData;
import iaik.pkcs.pkcs7.EncryptedDataStream;
import iaik.security.cipher.PBEKeyBMP;
import iaik.utils.InternalErrorException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;

public class AuthenticatedSafe
implements ASN1Type {
    public static final int UNENCRYPTED = 1;
    public static final int PASSWORD_ENCRYPTED = 2;
    public static final int PUBLIC_KEY_ENCRYPTED = 3;
    EncryptedContentInfo a;
    private ContentInfo d;
    private int e;
    SafeBag[] b;
    private int f;
    static Class c;

    public AuthenticatedSafe(int n2, SafeBag[] safeBagArray) throws PKCSException {
        this(n2, safeBagArray, 1024);
    }

    public AuthenticatedSafe(int n2, SafeBag[] safeBagArray, int n3) throws PKCSException {
        block5: {
            this.f = n3;
            this.e = n2;
            this.b = safeBagArray;
            try {
                byte[] byArray = SafeBag.encodeSafeContents(this.b);
                if (n2 == 2) {
                    this.a = new EncryptedContentInfo(ObjectID.pkcs7_data, byArray);
                    this.a.setBlockSize(this.f);
                    break block5;
                }
                if (n2 == 3) {
                    throw new RuntimeException("PUBLIC_KEY_ENCRYPTED not implemented");
                }
                if (n2 == 1) {
                    Data data = new Data(byArray);
                    data.setBlockSize(this.f);
                    this.d = new ContentInfo(data);
                    break block5;
                }
                throw new PKCSException("Unknown mode!");
            }
            catch (CodingException codingException) {
                throw new PKCSException("Unknown mode! " + codingException);
            }
        }
    }

    public AuthenticatedSafe(ASN1Object aSN1Object) throws PKCSParsingException {
        this.f = 1024;
        try {
            this.decode(aSN1Object);
        }
        catch (CodingException codingException) {
            throw new PKCSParsingException(codingException.toString());
        }
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        try {
            this.d = new ContentInfo(aSN1Object);
        }
        catch (PKCSParsingException pKCSParsingException) {
            throw new CodingException(pKCSParsingException.toString());
        }
        if (this.d.getContentType().equals(ObjectID.pkcs7_encryptedData)) {
            this.e = 2;
            EncryptedData encryptedData = (EncryptedData)this.d.getContent();
            this.a = (EncryptedContentInfo)encryptedData.getEncryptedContentInfo();
        } else {
            if (this.d.getContentType().equals(ObjectID.pkcs7_envelopedData)) {
                this.e = 3;
                throw new CodingException("public-key encrypted not implemented.");
            }
            if (this.d.getContentType().equals(ObjectID.pkcs7_data)) {
                this.e = 1;
                byte[] byArray = ((Data)this.d.getContent()).getData();
                this.b = SafeBag.parseSafeContents(byArray);
            } else {
                throw new CodingException("Unknown content type in AuthenticatedSafes.");
            }
        }
    }

    public ASN1Object toASN1Object() throws CodingException {
        try {
            return this.d.toASN1Object();
        }
        catch (PKCSException pKCSException) {
            throw new CodingException(pKCSException.toString());
        }
    }

    public void encrypt(char[] cArray, AlgorithmID algorithmID) throws NoSuchAlgorithmException, PKCSException {
        switch (this.e) {
            case 2: {
                Object object;
                AlgorithmParameterSpec algorithmParameterSpec = null;
                if (algorithmID.equals(AlgorithmID.pbeWithSHAAnd40BitRC2_CBC) || algorithmID.equals(AlgorithmID.pbeWithSHAAnd3_KeyTripleDES_CBC)) {
                    try {
                        object = algorithmID.getAlgorithmParameters("PBE");
                        algorithmParameterSpec = (AlgorithmParameterSpec)((AlgorithmParameters)object).getParameterSpec(c == null ? (c = AuthenticatedSafe.class$("javax.crypto.spec.PBEParameterSpec")) : c);
                    }
                    catch (Exception exception) {
                        throw new InternalErrorException(exception);
                    }
                } else {
                    throw new NoSuchAlgorithmException(algorithmID.getName() + " not allowed!");
                }
                try {
                    this.a.setupCipher(algorithmID, new PBEKeyBMP(cArray), algorithmParameterSpec);
                }
                catch (KeyException keyException) {
                    throw new PKCSException(keyException.toString());
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new PKCSException(invalidAlgorithmParameterException.toString());
                }
                object = new EncryptedData(this.a);
                ((EncryptedDataStream)object).setBlockSize(this.f);
                this.d = new ContentInfo((Content)object);
                break;
            }
            case 3: {
                throw new RuntimeException("PUBLIC_KEY_ENCRYPTED not implemented");
            }
            case 1: {
                break;
            }
            default: {
                throw new PKCSException("Unknown mode!");
            }
        }
    }

    public void decrypt(char[] cArray) throws PKCSException, NoSuchAlgorithmException {
        switch (this.e) {
            case 2: {
                try {
                    AlgorithmID algorithmID = this.a.getContentEncryptionAlgorithm();
                    AlgorithmParameters algorithmParameters = algorithmID.getAlgorithmParameters("PBE");
                    Object t2 = algorithmParameters.getParameterSpec(c == null ? (c = AuthenticatedSafe.class$("javax.crypto.spec.PBEParameterSpec")) : c);
                    this.a.setupCipher(new PBEKeyBMP(cArray), (AlgorithmParameterSpec)t2);
                    byte[] byArray = this.a.getContent();
                    ASN1Object aSN1Object = DerCoder.decode(byArray);
                    this.b = SafeBag.parseSafeContents(DerCoder.encode(aSN1Object));
                    break;
                }
                catch (Exception exception) {
                    throw new PKCSException(exception.toString());
                }
            }
            case 3: {
                throw new PKCSException("privacy mode PUBLIC_KEY_ENCRYPTED not implemented.");
            }
            case 1: {
                break;
            }
            default: {
                throw new PKCSException("Unknown authenticated safes mode.");
            }
        }
        if (this.b != null) {
            for (int i2 = 0; i2 < this.b.length; ++i2) {
                if (!(this.b[i2] instanceof PKCS8ShroudedKeyBag)) continue;
                try {
                    ((PKCS8ShroudedKeyBag)this.b[i2]).decrypt(cArray);
                    continue;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new PKCSException("Unable to decrypt PrivateKey! " + generalSecurityException);
                }
            }
        }
    }

    public SafeBag[] getSafeBags() {
        return this.b;
    }

    public void setBlockSize(int n2) {
        this.f = n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("mode: ");
        switch (this.e) {
            case 1: {
                stringBuffer.append("UNENCRYPTED\n");
                break;
            }
            case 2: {
                stringBuffer.append("PASSWORD_ENCRYPTED\n");
                stringBuffer.append("Content encrypted with: " + this.a.getContentEncryptionAlgorithm().getName() + "\n");
                break;
            }
            case 3: {
                stringBuffer.append("PUBLIC_KEY_ENCRYPTED\n");
            }
        }
        if (this.b == null) {
            stringBuffer.append("No SafeBags or not decrypted yet.\n");
        } else {
            for (int i2 = 0; i2 < this.b.length; ++i2) {
                stringBuffer.append("\nSafeBag: " + i2 + "\n");
                stringBuffer.append(this.b[i2].toString());
            }
        }
        return stringBuffer.toString();
    }

    int a() {
        return this.e;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

