/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs12;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.pkcs12.Attributes;
import iaik.pkcs.pkcs12.AuthenticatedSafe;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.KeyBag;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.pkcs.pkcs12.PKCS8ShroudedKeyBag;
import iaik.pkcs.pkcs8.EncryptedPrivateKeyInfo;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import iaik.x509.extensions.SubjectKeyIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Set;
import java.util.Vector;

public class PKCS12KeyStore
extends KeyStoreSpi {
    private Hashtable a = new Hashtable();
    private Hashtable b = new Hashtable();

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.a.clear();
        this.b.clear();
        if (inputStream != null) {
            int n2;
            Object object;
            Object[] objectArray;
            PKCS12 pKCS12;
            try {
                pKCS12 = new PKCS12(inputStream);
                if (!pKCS12.verify(cArray)) {
                    throw new IOException(this, "PKCS12 verification error, incorrect password"){
                        private static final long serialVersionUID = -6777747744926386667L;
                        private final PKCS12KeyStore a;
                        {
                            this.a = pKCS12KeyStore;
                        }

                        public Throwable getCause() {
                            return new UnrecoverableKeyException("PKCS12 verification error, incorrect password");
                        }
                    };
                }
            }
            catch (PKCSException pKCSException) {
                throw new IOException(pKCSException.toString());
            }
            AuthenticatedSafe[] authenticatedSafeArray = pKCS12.getAuthenticatedSafes();
            Vector<Object> vector = new Vector<Object>();
            Vector<Object> vector2 = new Vector<Object>();
            for (int i2 = 0; i2 < authenticatedSafeArray.length; ++i2) {
                int n3;
                if (authenticatedSafeArray[i2].a() == 2) {
                    try {
                        authenticatedSafeArray[i2].decrypt(cArray);
                    }
                    catch (Exception exception) {
                        throw new CertificateException("Decryption error: " + exception.toString());
                    }
                    objectArray = authenticatedSafeArray[i2].getSafeBags();
                    for (n3 = 0; n3 < objectArray.length; ++n3) {
                        if (objectArray[n3] instanceof CertificateBag) {
                            vector2.addElement(objectArray[n3]);
                            continue;
                        }
                        if (!(objectArray[n3] instanceof PKCS8ShroudedKeyBag)) continue;
                        try {
                            ((PKCS8ShroudedKeyBag)objectArray[n3]).decrypt(cArray);
                            ASN1Object aSN1Object = ((PKCS8ShroudedKeyBag)objectArray[n3]).toASN1Object();
                            object = new PKCS8ShroudedKeyBag();
                            ((PKCS8ShroudedKeyBag)object).decode(aSN1Object);
                            ((Attributes)object).setFriendlyName(((Attributes)objectArray[n3]).getFriendlyName());
                            ((Attributes)object).setLocalKeyID(((Attributes)objectArray[n3]).getLocalKeyID());
                            vector.addElement(object);
                            continue;
                        }
                        catch (CodingException codingException) {
                            throw new CertificateException(codingException.toString());
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            throw new CertificateException(generalSecurityException.toString());
                        }
                    }
                    continue;
                }
                objectArray = authenticatedSafeArray[i2].getSafeBags();
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    if (objectArray[n3] instanceof PKCS8ShroudedKeyBag) {
                        vector.addElement(objectArray[n3]);
                        continue;
                    }
                    if (!(objectArray[n3] instanceof CertificateBag)) continue;
                    vector2.addElement(objectArray[n3]);
                }
            }
            Object[] objectArray2 = new PKCS8ShroudedKeyBag[vector.size()];
            vector.copyInto(objectArray2);
            objectArray = new CertificateBag[vector2.size()];
            vector2.copyInto(objectArray);
            Certificate[] certificateArray = CertificateBag.getCertificates((CertificateBag[])objectArray);
            for (n2 = 0; n2 < objectArray2.length; ++n2) {
                String string;
                Object object2;
                object = objectArray2[n2];
                Object object3 = null;
                X509Certificate x509Certificate = null;
                byte[] byArray = ((Attributes)object).getLocalKeyID();
                try {
                    String string2;
                    boolean bl = false;
                    if (byArray != null) {
                        for (int i3 = 0; i3 < objectArray.length; ++i3) {
                            object2 = ((Attributes)objectArray[i3]).getLocalKeyID();
                            if (object2 == null || !CryptoUtils.equalsBlock(object2, byArray)) continue;
                            object3 = objectArray[i3];
                            x509Certificate = ((CertificateBag)object3).getCertificate();
                            string = ((Attributes)object).getFriendlyName();
                            if (string != null) {
                                for (int i4 = 0; i4 < objectArray.length; ++i4) {
                                    String string3 = ((Attributes)objectArray[i4]).getFriendlyName();
                                    if (string3 == null || !string.equals(string3) || (object2 = ((Attributes)objectArray[i4]).getLocalKeyID()) == null || !CryptoUtils.equalsBlock(object2, byArray)) continue;
                                    object3 = objectArray[i4];
                                    x509Certificate = ((CertificateBag)object3).getCertificate();
                                    break;
                                }
                            }
                            bl = true;
                            break;
                        }
                    }
                    if (!bl && (string2 = ((Attributes)object).getFriendlyName()) != null) {
                        for (int i5 = 0; i5 < objectArray.length; ++i5) {
                            string = ((Attributes)objectArray[i5]).getFriendlyName();
                            if (string == null || !string2.equals(string)) continue;
                            object3 = objectArray[i5];
                            x509Certificate = ((CertificateBag)object3).getCertificate();
                            bl = true;
                            break;
                        }
                    }
                    if (!bl) {
                        throw new Exception("No localKeyID or friendlyName match!");
                    }
                }
                catch (Exception exception) {
                    throw new CertificateException(exception.toString());
                }
                X509Certificate[] x509CertificateArray = null;
                if (x509Certificate != null) {
                    x509CertificateArray = Util.createCertificateChain(x509Certificate, certificateArray);
                }
                b b2 = new b((PKCS8ShroudedKeyBag)object, x509CertificateArray, byArray);
                object2 = ((Attributes)object).getFriendlyName();
                if (object2 == null && object3 != null) {
                    Principal principal;
                    string = ((Attributes)object3).getFriendlyName();
                    if (string != null) {
                        object2 = string;
                    } else if (x509Certificate != null && (principal = x509Certificate.getSubjectDN()) != null) {
                        object2 = principal.getName();
                    }
                }
                if (object2 == null || this.a.containsKey(object2)) {
                    object2 = Integer.toString(n2);
                    for (int i6 = n2; this.a.containsKey(object2) && i6 < Integer.MAX_VALUE; ++i6) {
                        object2 = Integer.toString(i6);
                    }
                }
                this.a.put(object2, b2);
            }
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                object = ((Attributes)objectArray[n2]).getFriendlyName();
                if (object == null || this.a.containsKey(object)) continue;
                this.b.put(object, new a(((CertificateBag)objectArray[n2]).getCertificate()));
            }
        }
    }

    public Enumeration engineAliases() {
        Vector vector = new Vector(this.a.size() + this.b.size());
        Set set = this.a.keySet();
        vector.addAll(set);
        Set set2 = this.b.keySet();
        vector.addAll(set2);
        return vector.elements();
    }

    public boolean engineContainsAlias(String string) {
        boolean bl = false;
        if (string != null) {
            bl = this.a.containsKey(string) || this.b.containsKey(string);
        }
        return bl;
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        if (string != null) {
            this.a.remove(string);
            this.b.remove(string);
        }
    }

    public Certificate engineGetCertificate(String string) {
        X509Certificate x509Certificate = null;
        if (string != null) {
            X509Certificate[] x509CertificateArray;
            b b2;
            a a2 = (a)this.b.get(string);
            if (a2 != null) {
                x509Certificate = a2.a();
            }
            if (x509Certificate == null && (b2 = (b)this.a.get(string)) != null && (x509CertificateArray = b2.b()) != null && x509CertificateArray.length > 0) {
                x509Certificate = x509CertificateArray[0];
            }
        }
        return x509Certificate;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Object object;
        String string;
        Enumeration enumeration = this.a.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = this.engineGetCertificateChain(string);
            if (((Certificate[])object).length <= 0 || !object[0].equals(certificate)) continue;
            return string;
        }
        enumeration = this.b.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = this.engineGetCertificate(string);
            if (object == null || !((Certificate)object).equals(certificate)) continue;
            return string;
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        b b2;
        X509Certificate[] x509CertificateArray = null;
        if (string != null && (b2 = (b)this.a.get(string)) != null) {
            x509CertificateArray = b2.b();
        }
        return x509CertificateArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Date engineGetCreationDate(String string) {
        Date date = null;
        if (!this.engineContainsAlias(string)) return date;
        b b2 = (b)this.a.get(string);
        if (b2 != null) {
            byte[] byArray = b2.c();
            try {
                String string2 = new String(byArray, "ASCII");
                return new Date(Long.parseLong(string2));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ProviderException(unsupportedEncodingException.toString());
            }
            catch (NumberFormatException numberFormatException) {
                X509Certificate[] x509CertificateArray = b2.b();
                if (x509CertificateArray == null) return date;
                if (x509CertificateArray.length <= 0) return date;
                return x509CertificateArray[0].getNotBefore();
            }
        }
        a a2 = (a)this.b.get(string);
        return a2.a().getNotBefore();
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        b b2;
        PrivateKey privateKey = null;
        if (string != null && (b2 = (b)this.a.get(string)) != null) {
            try {
                PKCS8ShroudedKeyBag pKCS8ShroudedKeyBag = b2.a();
                ASN1Object aSN1Object = pKCS8ShroudedKeyBag.toASN1Object();
                PKCS8ShroudedKeyBag pKCS8ShroudedKeyBag2 = new PKCS8ShroudedKeyBag();
                pKCS8ShroudedKeyBag2.decode(aSN1Object);
                pKCS8ShroudedKeyBag2.decrypt(cArray);
                privateKey = pKCS8ShroudedKeyBag2.getPrivateKey();
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new UnrecoverableKeyException(generalSecurityException.toString());
            }
            catch (CodingException codingException) {
                throw new UnrecoverableKeyException(codingException.toString());
            }
        }
        return privateKey;
    }

    public boolean engineIsCertificateEntry(String string) {
        return string != null ? this.b.containsKey(string) : false;
    }

    public boolean engineIsKeyEntry(String string) {
        return string != null ? this.a.containsKey(string) : false;
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (string == null) {
            throw new NullPointerException("alias must not be null");
        }
        if (certificate == null) {
            throw new NullPointerException("cert must not be null");
        }
        if (this.a.get(string) != null) {
            throw new KeyStoreException("Alias \"" + string + "\" already used for KeyEntry!");
        }
        this.b.put(string, new a((X509Certificate)certificate));
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        X509Certificate[] x509CertificateArray;
        PKCS8ShroudedKeyBag pKCS8ShroudedKeyBag;
        Object object;
        if (string == null) {
            throw new NullPointerException("alias must not be null");
        }
        if (byArray == null) {
            throw new NullPointerException("key must not be null");
        }
        if (certificateArray == null) {
            throw new NullPointerException("chain must not be null");
        }
        if (certificateArray.length == 0) {
            throw new NullPointerException("chain must not be empty");
        }
        if (this.b.get(string) != null) {
            throw new KeyStoreException("Alias \"" + string + "\" already used for CertEntry!");
        }
        byte[] byArray2 = this.a(certificateArray[0], string);
        try {
            object = new EncryptedPrivateKeyInfo(byArray);
            ASN1Object aSN1Object = ((EncryptedPrivateKeyInfo)object).toASN1Object();
            pKCS8ShroudedKeyBag = new PKCS8ShroudedKeyBag();
            pKCS8ShroudedKeyBag.decode(aSN1Object);
            pKCS8ShroudedKeyBag.setFriendlyName(string);
            pKCS8ShroudedKeyBag.setLocalKeyID(byArray2);
            x509CertificateArray = Util.convertCertificateChain(certificateArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KeyStoreException(invalidKeyException.toString());
        }
        catch (CodingException codingException) {
            throw new KeyStoreException(codingException.toString());
        }
        catch (CertificateException certificateException) {
            throw new KeyStoreException(certificateException.toString());
        }
        object = new b(pKCS8ShroudedKeyBag, x509CertificateArray, byArray2);
        this.a.put(string, object);
    }

    private byte[] a(Certificate certificate, String string) {
        byte[] byArray = null;
        try {
            long l2 = System.currentTimeMillis();
            String string2 = Long.toString(l2);
            byArray = string2.getBytes("ASCII");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (byArray == null) {
            try {
                byArray = new SubjectKeyIdentifier(certificate.getPublicKey()).get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (byArray == null && string != null) {
            try {
                byArray = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    byArray = string.getBytes("UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    byArray = string.getBytes();
                }
            }
        }
        if (byArray == null) {
            Random random = new Random();
            byArray = new byte[10];
            random.nextBytes(byArray);
        }
        return byArray;
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        X509Certificate[] x509CertificateArray;
        PKCS8ShroudedKeyBag pKCS8ShroudedKeyBag;
        Object object;
        if (string == null) {
            throw new NullPointerException("alias must not be null!");
        }
        if (key == null) {
            throw new NullPointerException("key must not be null!");
        }
        if (certificateArray == null) {
            throw new NullPointerException("chain must not be null!");
        }
        if (this.b.get(string) != null) {
            throw new KeyStoreException("Alias \"" + string + "\" already used for CertEntry!");
        }
        byte[] byArray = this.a(certificateArray[0], string);
        try {
            object = new KeyBag((PrivateKey)key, string, byArray);
            ((Attributes)object).setLocalKeyID(byArray);
            pKCS8ShroudedKeyBag = new PKCS8ShroudedKeyBag((KeyBag)object);
            pKCS8ShroudedKeyBag.encrypt(cArray, (AlgorithmID)AlgorithmID.pbeWithSHAAnd3_KeyTripleDES_CBC.clone(), 2000);
            x509CertificateArray = Util.convertCertificateChain(certificateArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreException(noSuchAlgorithmException.toString());
        }
        catch (CertificateException certificateException) {
            throw new KeyStoreException(certificateException.toString());
        }
        object = new b(pKCS8ShroudedKeyBag, x509CertificateArray, byArray);
        this.a.put(string, object);
    }

    public int engineSize() {
        return this.a.size() + this.b.size();
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Object object;
        Object object2;
        Object[] objectArray;
        Object[] objectArray2;
        Vector<PKCS8ShroudedKeyBag> vector = new Vector<PKCS8ShroudedKeyBag>(2);
        Vector<Object> vector2 = new Vector<Object>(4);
        Enumeration enumeration = this.a.keys();
        while (enumeration.hasMoreElements()) {
            objectArray2 = (Object[])enumeration.nextElement();
            objectArray = (b)this.a.get(objectArray2);
            object2 = objectArray.a();
            vector.addElement((PKCS8ShroudedKeyBag)object2);
            object = objectArray.b();
            CertificateBag certificateBag = new CertificateBag(object[0], (String)objectArray2, objectArray.c());
            vector2.addElement(certificateBag);
            for (int i2 = 1; i2 < ((Object)object).length; ++i2) {
                certificateBag = new CertificateBag((X509Certificate)object[i2]);
                vector2.addElement(certificateBag);
            }
        }
        enumeration = this.b.keys();
        while (enumeration.hasMoreElements()) {
            objectArray2 = (String)enumeration.nextElement();
            objectArray = (a)this.b.get(objectArray2);
            object2 = objectArray.a();
            object = new CertificateBag((X509Certificate)object2);
            ((Attributes)object).setFriendlyName((String)objectArray2);
            vector2.addElement(object);
        }
        objectArray2 = new KeyBag[vector.size()];
        vector.copyInto(objectArray2);
        objectArray = new CertificateBag[vector2.size()];
        vector2.copyInto(objectArray);
        try {
            object2 = new PKCS12((KeyBag[])objectArray2, (CertificateBag[])objectArray, true);
            ((PKCS12)object2).encrypt(cArray);
            ((PKCS12)object2).toASN1Object();
            ((PKCS12)object2).writeTo(outputStream);
        }
        catch (PKCSException pKCSException) {
            throw new CertificateException(pKCSException.toString());
        }
    }

    private static class a {
        private X509Certificate a;

        a(X509Certificate x509Certificate) {
            this.a = x509Certificate;
        }

        public X509Certificate a() {
            return this.a;
        }
    }

    private static class b {
        private PKCS8ShroudedKeyBag a;
        private X509Certificate[] b;
        private byte[] c;

        b(PKCS8ShroudedKeyBag pKCS8ShroudedKeyBag, X509Certificate[] x509CertificateArray, byte[] byArray) {
            this.a = pKCS8ShroudedKeyBag;
            this.b = x509CertificateArray;
            this.c = byArray;
        }

        public PKCS8ShroudedKeyBag a() {
            return this.a;
        }

        public X509Certificate[] b() {
            return this.b;
        }

        public byte[] c() {
            return this.c;
        }
    }
}

