/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.security.md.SHA;
import iaik.security.random.SecRandom;
import iaik.utils.NumberTheory;
import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public class DHParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private SecureRandom a;
    private int b = 1024;
    private int c = 300;

    protected void engineInit(int n2, SecureRandom secureRandom) {
        this.a = secureRandom;
        this.b = n2;
        this.c = -1;
        this.a();
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.a = secureRandom;
        if (algorithmParameterSpec instanceof DHGenParameterSpec) {
            this.b = ((DHGenParameterSpec)algorithmParameterSpec).getPrimeSize();
            this.c = ((DHGenParameterSpec)algorithmParameterSpec).getExponentSize();
            if (this.c > this.b) {
                throw new InvalidAlgorithmParameterException("The size of the exponent must be less than the size of the modulus");
            }
        } else {
            throw new InvalidAlgorithmParameterException("Parameter must be a DHGenParameterSpec.");
        }
        this.a();
    }

    private void a() throws IllegalArgumentException {
        if (this.b < 512 || this.c != 0 && this.c < 160) {
            throw new IllegalArgumentException("Prime must be at least 512, exponent at least 160 bits long!");
        }
    }

    private static void a(byte[] byArray) {
        int n2 = byArray.length;
        while (n2 > 0) {
            int n3 = --n2;
            byArray[n3] = (byte)(byArray[n3] + 1);
            byte by = byArray[n3];
            if (by == 0) continue;
            break;
        }
    }

    protected AlgorithmParameters engineGenerateParameters() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        Object object;
        BigInteger bigInteger3;
        int n2;
        BigInteger bigInteger4;
        byte[] byArray;
        int n3;
        block14: {
            Object object2;
            Object object3;
            Object object4;
            if (this.a == null) {
                this.a = SecRandom.getDefault();
            }
            n3 = this.b;
            int n4 = this.c;
            if (n4 <= 0) {
                n4 = 300;
            }
            int n5 = (n4 + 159) / 160;
            int n6 = (n3 + 159) / 160;
            int n7 = (n3 + 1023) / 1024;
            BigInteger bigInteger5 = NumberTheory.TWO.pow(n4);
            BigInteger bigInteger6 = NumberTheory.TWO.pow(n3);
            BigInteger bigInteger7 = NumberTheory.TWO.pow(n3 - 1);
            byArray = new byte[(n4 + 7) / 8];
            SHA sHA = new SHA();
            byte[] byArray2 = new byte[20 * n5];
            do {
                int n8;
                this.a.nextBytes(byArray);
                byte[] byArray3 = (byte[])byArray.clone();
                object4 = (byte[])byArray.clone();
                for (n8 = 0; n8 < n5; ++n8) {
                    DHParameterGenerator.a((byte[])object4);
                }
                for (n8 = 0; n8 < n5; ++n8) {
                    object3 = sHA.digest(byArray3);
                    object2 = sHA.digest((byte[])object4);
                    DHParameterGenerator.a(byArray3);
                    DHParameterGenerator.a((byte[])object4);
                    int n9 = 0;
                    int n10 = n8 * 20;
                    while (n9 < 20) {
                        byArray2[n10] = (byte)(object3[n9] ^ object2[n9]);
                        ++n9;
                        ++n10;
                    }
                }
                bigInteger4 = new BigInteger(1, byArray2);
                bigInteger4 = bigInteger4.mod(bigInteger5);
                bigInteger4 = bigInteger4.setBit(0);
            } while (!NumberTheory.isProbablePrime(bigInteger4 = bigInteger4.setBit(n4 - 1)));
            n2 = 0;
            object4 = new BigInteger(1, byArray);
            BigInteger bigInteger8 = BigInteger.valueOf(n5);
            bigInteger8 = bigInteger8.add(bigInteger8);
            object3 = BigInteger.valueOf(n6);
            object2 = NumberTheory.ZERO;
            byte[] byArray4 = new byte[20 * n6];
            do {
                Object object5;
                bigInteger3 = ((BigInteger)object4).add(bigInteger8).add((BigInteger)object2);
                object = bigInteger3.toByteArray();
                for (int i2 = 0; i2 < n6; ++i2) {
                    object5 = sHA.digest((byte[])object);
                    DHParameterGenerator.a(object);
                    int n11 = 0;
                    int n12 = i2 * 20;
                    while (n11 < 20) {
                        byArray4[n12] = object5[n11];
                        ++n11;
                        ++n12;
                    }
                }
                bigInteger2 = new BigInteger(1, byArray4).mod(bigInteger6);
                object5 = bigInteger2.setBit(n3 - 1);
                bigInteger = ((BigInteger)object5).subtract(((BigInteger)object5).mod(bigInteger4.add(bigInteger4))).add(NumberTheory.ONE);
                if (bigInteger.compareTo(bigInteger7) > 0 && NumberTheory.isProbablePrime(bigInteger)) break block14;
                object2 = ((BigInteger)object2).add((BigInteger)object3);
            } while (++n2 < 4096 * n7);
            throw new RuntimeException("Parameter generation failed!");
        }
        object = bigInteger.subtract(NumberTheory.ONE).divide(bigInteger4);
        while ((bigInteger3 = (bigInteger2 = new BigInteger(n3 + 4, this.a).mod(bigInteger.subtract(NumberTheory.ONE)).add(NumberTheory.ONE)).modPow((BigInteger)object, bigInteger)).compareTo(NumberTheory.ONE) == 0) {
        }
        try {
            return this.a(bigInteger, bigInteger3, bigInteger4, (BigInteger)object, byArray, n2, this.c);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException(invalidParameterSpecException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.toString());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException(noSuchProviderException.toString());
        }
    }

    AlgorithmParameters a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, byte[] byArray, int n2, int n3) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidParameterSpecException {
        DHParameterSpec dHParameterSpec = n3 < 0 ? new DHParameterSpec(bigInteger, bigInteger2) : new DHParameterSpec(bigInteger, bigInteger2, n3);
        AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("DH", "IAIK");
        algorithmParameters.init(dHParameterSpec);
        return algorithmParameters;
    }
}

