/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dsa;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.security.dsa.DSAParams;
import iaik.security.dsa.SHA2withDSAParameterSpec;
import iaik.security.dsa.SHA2withDSAParams;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class DSAParameters
extends AlgorithmParametersSpi {
    DSAParams a;

    protected byte[] engineGetEncoded() throws IOException {
        return DerCoder.encode(this.a.toASN1Object());
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        DSAParameterSpec dSAParameterSpec;
        if (this.a instanceof SHA2withDSAParams) {
            dSAParameterSpec = new SHA2withDSAParameterSpec(this.a.getP(), this.a.getQ(), this.a.getG());
            ((SHA2withDSAParameterSpec)dSAParameterSpec).a(((SHA2withDSAParams)this.a).getCounter());
            ((SHA2withDSAParameterSpec)dSAParameterSpec).a(((SHA2withDSAParams)this.a).getSeed());
        } else {
            dSAParameterSpec = new DSAParameterSpec(this.a.getP(), this.a.getQ(), this.a.getG());
        }
        if (!clazz.isInstance(dSAParameterSpec)) {
            throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
        }
        return dSAParameterSpec;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof DSAParameterSpec) {
            if (algorithmParameterSpec instanceof SHA2withDSAParameterSpec) {
                SHA2withDSAParameterSpec sHA2withDSAParameterSpec = (SHA2withDSAParameterSpec)algorithmParameterSpec;
                this.a = new SHA2withDSAParams(sHA2withDSAParameterSpec.getP(), sHA2withDSAParameterSpec.getQ(), sHA2withDSAParameterSpec.getG());
                ((SHA2withDSAParams)this.a).a(sHA2withDSAParameterSpec.getCounter());
                ((SHA2withDSAParams)this.a).a(sHA2withDSAParameterSpec.getSeed());
            } else {
                DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameterSpec;
                this.a = new DSAParams(dSAParameterSpec.getP(), dSAParameterSpec.getQ(), dSAParameterSpec.getG());
            }
        } else {
            throw new InvalidParameterSpecException("Parameter must be DSAParameterSpec.");
        }
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            ASN1Object aSN1Object = DerCoder.decode(byArray);
            this.a = new DSAParams(aSN1Object);
        }
        catch (CodingException codingException) {
            throw new IOException("DER decoding error. " + codingException.toString());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        return this.a.toString();
    }
}

