/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dsa;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import java.math.BigInteger;

public class DSAParams
implements java.security.interfaces.DSAParams {
    private BigInteger a;
    private BigInteger b;
    private BigInteger c;

    public DSAParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this.a = bigInteger;
        this.b = bigInteger2;
        this.c = bigInteger3;
    }

    public DSAParams(java.security.interfaces.DSAParams dSAParams) {
        this(dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
    }

    public DSAParams(ASN1Object aSN1Object) throws CodingException {
        this.a(aSN1Object);
    }

    public BigInteger getP() {
        return this.a;
    }

    public BigInteger getQ() {
        return this.b;
    }

    public BigInteger getG() {
        return this.c;
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new INTEGER(this.a));
        sEQUENCE.addComponent(new INTEGER(this.b));
        sEQUENCE.addComponent(new INTEGER(this.c));
        return sEQUENCE;
    }

    private void a(ASN1Object aSN1Object) throws CodingException {
        try {
            if (!aSN1Object.isA(ASN.SEQUENCE)) {
                throw new CodingException("DSA parameters must be ASN.1 SEQUENCE.");
            }
            if (aSN1Object.countComponents() < 3) {
                throw new CodingException("DSA parameeters must contain p, q and g.");
            }
            this.a = (BigInteger)aSN1Object.getComponentAt(0).getValue();
            this.b = (BigInteger)aSN1Object.getComponentAt(1).getValue();
            this.c = (BigInteger)aSN1Object.getComponentAt(2).getValue();
        }
        catch (Exception exception) {
            throw new CodingException(exception.toString());
        }
    }

    public int hashCode() {
        return this.a.hashCode() ^ this.b.hashCode() ^ this.c.hashCode();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DSAParams) {
            DSAParams dSAParams = (DSAParams)object;
            if (!this.a.equals(dSAParams.getP())) {
                return false;
            }
            if (!this.b.equals(dSAParams.getQ())) {
                return false;
            }
            return this.c.equals(dSAParams.getG());
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("p: " + this.a.toString(16) + "\n");
        stringBuffer.append("q: " + this.b.toString(16) + "\n");
        stringBuffer.append("g: " + this.c.toString(16) + "\n");
        return stringBuffer.toString();
    }
}

