/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dsa;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import iaik.security.dsa.DSAParams;
import iaik.utils.InternalErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.spec.DSAPrivateKeySpec;

public class DSAPrivateKey
extends PrivateKeyInfo
implements java.security.interfaces.DSAPrivateKey {
    private transient ASN1 c;
    private BigInteger d;
    private transient DSAParams e;

    public DSAPrivateKey(BigInteger bigInteger, java.security.interfaces.DSAParams dSAParams) {
        this.d = bigInteger;
        this.e = dSAParams instanceof DSAParams ? (DSAParams)dSAParams : new DSAParams(dSAParams);
        this.a();
    }

    public DSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this.d = bigInteger;
        this.e = new DSAParams(bigInteger2, bigInteger3, bigInteger4);
        this.a();
    }

    public DSAPrivateKey(DSAPrivateKeySpec dSAPrivateKeySpec) {
        this(dSAPrivateKeySpec.getX(), dSAPrivateKeySpec.getP(), dSAPrivateKeySpec.getQ(), dSAPrivateKeySpec.getG());
    }

    public DSAPrivateKey(java.security.interfaces.DSAPrivateKey dSAPrivateKey) {
        this(dSAPrivateKey.getX(), dSAPrivateKey.getParams());
    }

    public DSAPrivateKey(byte[] byArray) throws InvalidKeyException {
        super(byArray);
    }

    public DSAPrivateKey(ASN1Object aSN1Object) throws InvalidKeyException {
        super(aSN1Object);
    }

    public DSAPrivateKey(InputStream inputStream) throws InvalidKeyException, IOException {
        super(inputStream);
    }

    public BigInteger getX() {
        return this.d;
    }

    public java.security.interfaces.DSAParams getParams() {
        return this.e;
    }

    public byte[] encode() {
        return this.c.toByteArray();
    }

    private void a() {
        try {
            this.private_key_algorithm = (AlgorithmID)AlgorithmID.dsa.clone();
            this.private_key_algorithm.setParameter(this.e.toASN1Object());
            this.c = new ASN1(new INTEGER(this.d));
        }
        catch (CodingException codingException) {
            throw new InternalErrorException(codingException);
        }
        this.createPrivateKeyInfo();
    }

    protected void decode(byte[] byArray) throws InvalidKeyException {
        try {
            this.c = new ASN1(byArray);
            this.d = (BigInteger)this.c.toASN1Object().getValue();
            this.e = new DSAParams(this.private_key_algorithm.getParameter());
        }
        catch (Exception exception) {
            throw new InvalidKeyException("No DSA private key.");
        }
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public int hashCode() {
        return this.e.hashCode() ^ this.d.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof DSAPrivateKey) {
            DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)object;
            if (!this.d.equals(dSAPrivateKey.getX())) {
                return false;
            }
            return this.e.equals(dSAPrivateKey.getParams());
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DSA private key");
        stringBuffer.append(this.e == null ? ":\n" : " (" + this.e.getP().bitLength() + " bits):\n");
        stringBuffer.append("x: " + this.d.toString(16) + "\n");
        if (this.e != null) {
            stringBuffer.append(this.e.toString());
        }
        return stringBuffer.toString();
    }
}

