/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.rsa;

import iaik.security.rsa.RSAPrivateKey;
import iaik.security.rsa.RSAPublicKey;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class RSAKeyFactory
extends KeyFactorySpi {
    static Class a;
    static Class b;
    static Class c;
    static Class d;
    static Class e;

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof RSAPrivateCrtKeySpec) {
                return new RSAPrivateKey((RSAPrivateCrtKeySpec)keySpec);
            }
            if (keySpec instanceof RSAPrivateKeySpec) {
                return new RSAPrivateKey((RSAPrivateKeySpec)keySpec);
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                return new RSAPrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Only RSA key specs allowed.");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Invalid KeySpec.");
        }
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof RSAPublicKeySpec) {
                return new RSAPublicKey((RSAPublicKeySpec)keySpec);
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new RSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Only RSA key specs allowed.");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Invalid KeySpec.");
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (key instanceof java.security.interfaces.RSAPublicKey) {
            if ((a == null ? (a = RSAKeyFactory.class$("java.security.spec.RSAPublicKeySpec")) : a).isAssignableFrom(clazz)) {
                java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)key;
                return new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            }
            if ((b == null ? (b = RSAKeyFactory.class$("java.security.spec.X509EncodedKeySpec")) : b).isAssignableFrom(clazz)) {
                return new X509EncodedKeySpec(key.getEncoded());
            }
            throw new InvalidKeySpecException("Can't convert key to KeySpec.");
        }
        if (key instanceof java.security.interfaces.RSAPrivateKey) {
            java.security.interfaces.RSAPrivateKey rSAPrivateKey = (java.security.interfaces.RSAPrivateKey)key;
            if ((c == null ? (c = RSAKeyFactory.class$("java.security.spec.RSAPrivateCrtKeySpec")) : c).isAssignableFrom(clazz) && key instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)key;
                return new RSAPrivateCrtKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
            }
            if ((d == null ? (d = RSAKeyFactory.class$("java.security.spec.RSAPrivateKeySpec")) : d).isAssignableFrom(clazz)) {
                return new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
            }
            if ((e == null ? (e = RSAKeyFactory.class$("java.security.spec.PKCS8EncodedKeySpec")) : e).isAssignableFrom(clazz)) {
                return new PKCS8EncodedKeySpec(rSAPrivateKey.getEncoded());
            }
            throw new InvalidKeySpecException("Can't convert key to KeySpec.");
        }
        throw new InvalidKeySpecException("Can only convert RSA keys.");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof java.security.interfaces.RSAPublicKey) {
            BigInteger bigInteger = ((java.security.interfaces.RSAPublicKey)key).getModulus();
            BigInteger bigInteger2 = ((java.security.interfaces.RSAPublicKey)key).getPublicExponent();
            return new RSAPublicKey(bigInteger, bigInteger2);
        }
        if (key instanceof java.security.interfaces.RSAPrivateKey) {
            BigInteger bigInteger = ((java.security.interfaces.RSAPrivateKey)key).getModulus();
            BigInteger bigInteger3 = ((java.security.interfaces.RSAPrivateKey)key).getPrivateExponent();
            if (key instanceof RSAPrivateCrtKey) {
                BigInteger bigInteger4 = ((RSAPrivateCrtKey)key).getPublicExponent();
                BigInteger bigInteger5 = ((RSAPrivateCrtKey)key).getPrimeP();
                BigInteger bigInteger6 = ((RSAPrivateCrtKey)key).getPrimeQ();
                BigInteger bigInteger7 = ((RSAPrivateCrtKey)key).getPrimeExponentP();
                BigInteger bigInteger8 = ((RSAPrivateCrtKey)key).getPrimeExponentQ();
                BigInteger bigInteger9 = ((RSAPrivateCrtKey)key).getCrtCoefficient();
                return new RSAPrivateKey(bigInteger, bigInteger4, bigInteger3, bigInteger5, bigInteger6, bigInteger7, bigInteger8, bigInteger9);
            }
            return new RSAPrivateKey(bigInteger, bigInteger3);
        }
        throw new InvalidKeyException("Only keys of type RSAPublicKey and RSAPrivateKey can be translated.");
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

