/*
 * Decompiled with CFR 0.152.
 */
package iaik.utils;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Mac;

public class MacInputStream
extends FilterInputStream {
    protected boolean macingActive_;
    protected Mac macEngine_;

    public MacInputStream(InputStream inputStream, Mac mac) {
        super(inputStream);
        if (inputStream == null) {
            throw new NullPointerException("Argument \"stream\" must not be null.");
        }
        if (mac == null) {
            throw new NullPointerException("Argument \"macEngine\" must not be null.");
        }
        this.macingActive_ = true;
        this.setMac(mac);
    }

    public Mac getMac() {
        return this.macEngine_;
    }

    public void setMac(Mac mac) {
        if (mac == null) {
            throw new NullPointerException("Argument \"macEngine\" must not be null.");
        }
        this.macEngine_ = mac;
    }

    public int read() throws IOException {
        int n2 = this.in.read();
        if (this.macingActive_ && n2 != -1) {
            this.macEngine_.update((byte)n2);
        }
        return n2;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.in.read(byArray, n2, n3);
        if (this.macingActive_ && n4 != -1) {
            this.macEngine_.update(byArray, n2, n4);
        }
        return n4;
    }

    public void on(boolean bl) {
        this.macingActive_ = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MAC Input Stream (");
        stringBuffer.append(this.macingActive_ ? "MACing active" : "MACing inactive");
        stringBuffer.append(") using ");
        stringBuffer.append(this.macEngine_.toString());
        return stringBuffer.toString();
    }
}

