/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509;

import iaik.pkcs.NetscapeCertList;
import iaik.pkcs.PKCS7CertList;
import iaik.pkcs.PKCSException;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.CertPath;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class X509CertPath
extends CertPath {
    public static final String PKI_PATH = "PkiPath";
    static final String a = "PkiPath".toUpperCase();
    public static final String DER = "DER";
    public static final String PEM = "PEM";
    public static final String PKCS7 = "PKCS7";
    public static final String NETSCAPE = "NETSCAPE";
    public static final String DEFAULT_ENCODING_FORMAT = "PkiPath";
    private static final List b;
    private X509Certificate[] c;

    static Iterator a() {
        return b.iterator();
    }

    public X509CertPath(X509Certificate[] x509CertificateArray) {
        super("X.509");
        if (x509CertificateArray == null) {
            throw new NullPointerException("Certificates must not be null!");
        }
        X509Certificate[] x509CertificateArray2 = null;
        if (x509CertificateArray.length > 0) {
            x509CertificateArray2 = Util.arrangeCertificateChain(x509CertificateArray, false);
        }
        this.c = x509CertificateArray2 == null ? x509CertificateArray : x509CertificateArray2;
    }

    public X509CertPath(List list) throws CertificateException {
        super("X.509");
        Object object;
        if (list == null) {
            throw new NullPointerException("Certificates must not be null!");
        }
        this.c = new X509Certificate[list.size()];
        Iterator iterator = list.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object instanceof java.security.cert.X509Certificate) {
                this.c[n2++] = Util.convertCertificate((java.security.cert.X509Certificate)object);
                continue;
            }
            throw new CertificateException("Certificate list must contain X509Certificate objects only!");
        }
        if (this.c.length > 0 && (object = Util.arrangeCertificateChain(this.c, false)) != null) {
            this.c = object;
        }
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            Object[] objectArray = new X509Certificate[this.c.length];
            if (objectArray.length > 0) {
                System.arraycopy(this.c, 0, objectArray, 0, this.c.length);
                Util.reverseArray(objectArray, 0, objectArray.length);
            }
            return Util.encodeAsPkiPath((X509Certificate[])objectArray, false);
        }
        catch (CertificateException certificateException) {
            throw new CertificateEncodingException(certificateException.toString());
        }
    }

    public byte[] getEncoded(String string) throws CertificateEncodingException {
        if (string == null) {
            throw new NullPointerException("encoding must not be null!");
        }
        byte[] byArray = null;
        String string2 = string.toUpperCase();
        if (string2.equals(a)) {
            byArray = this.getEncoded();
        } else if (string2.equals(DER)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
            try {
                for (int i2 = 0; i2 < this.c.length; ++i2) {
                    this.c[i2].writeTo(byteArrayOutputStream);
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new CertificateEncodingException(iOException.toString());
            }
        } else if (string2.equals(PEM)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
            try {
                for (int i3 = 0; i3 < this.c.length; ++i3) {
                    byteArrayOutputStream.write(Util.toPemArray(this.c[i3]));
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new CertificateEncodingException(iOException.toString());
            }
        } else if (string2.equals(PKCS7)) {
            PKCS7CertList pKCS7CertList = new PKCS7CertList();
            pKCS7CertList.setCertificateList(this.c);
            try {
                byArray = pKCS7CertList.toByteArray();
            }
            catch (PKCSException pKCSException) {
                throw new CertificateEncodingException(pKCSException.toString());
            }
        } else if (string2.equals(NETSCAPE)) {
            NetscapeCertList netscapeCertList = new NetscapeCertList();
            netscapeCertList.setCertificateList(this.c);
            try {
                byArray = netscapeCertList.toByteArray();
            }
            catch (PKCSException pKCSException) {
                throw new CertificateEncodingException(pKCSException.toString());
            }
        } else {
            throw new CertificateEncodingException("Requested encoding format \"" + string + "\" not supported!");
        }
        return byArray;
    }

    public Iterator getEncodings() {
        return b.iterator();
    }

    public List getCertificates() {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            arrayList.add(this.c[i2]);
        }
        return Collections.unmodifiableList(arrayList);
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("PkiPath");
        arrayList.add(DER);
        arrayList.add(PEM);
        arrayList.add(PKCS7);
        arrayList.add(NETSCAPE);
        b = Collections.unmodifiableList(arrayList);
    }
}

