/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.extensions;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.PolicyInformation;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;

public class CertificatePolicies
extends V3Extension {
    public static final ObjectID oid = ObjectID.certExt_CertificatePolicies;
    private PolicyInformation[] a = null;

    public CertificatePolicies() {
    }

    public CertificatePolicies(PolicyInformation[] policyInformationArray) {
        this.a = policyInformationArray;
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        try {
            this.a = new PolicyInformation[aSN1Object.countComponents()];
            for (int i2 = 0; i2 < aSN1Object.countComponents(); ++i2) {
                this.a[i2] = new PolicyInformation(aSN1Object.getComponentAt(i2));
            }
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException(codingException.getMessage());
        }
    }

    public ASN1Object toASN1Object() {
        if (this.a == null) {
            throw new NullPointerException("No PolicyInformations set!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            sEQUENCE.addComponent(this.a[i2].toASN1Object());
        }
        return sEQUENCE;
    }

    public PolicyInformation[] getPolicyInformation() {
        return this.a;
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                stringBuffer.append("certificatePolicy[" + i2 + "]: " + this.a[i2] + "\n");
            }
            if (stringBuffer.length() >= 1) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
        }
        return stringBuffer.toString();
    }
}

