/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.extensions.priv;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1String;
import iaik.asn1.ObjectID;
import iaik.asn1.UTF8String;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;

public class PublicAuthorityIdentifier
extends V3Extension {
    public static final ObjectID oid = ObjectID.certExt_PublicAuthorityIdentifier;
    protected ASN1String code_;
    private ASN1Object a;

    public PublicAuthorityIdentifier() {
        this.code_ = null;
        this.a = null;
    }

    public PublicAuthorityIdentifier(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("code must not be null!");
        }
        this.code_ = new UTF8String(string);
        this.a = this.code_;
    }

    public PublicAuthorityIdentifier(ASN1String aSN1String) {
        if (aSN1String == null) {
            throw new IllegalArgumentException("code must not be null!");
        }
        if (!(aSN1String.isA(ASN.T61String) || aSN1String.isA(ASN.PrintableString) || aSN1String.isA(ASN.UNIString) || aSN1String.isA(ASN.UTF8String) || aSN1String.isA(ASN.BMPString))) {
            throw new IllegalArgumentException("PublicAuthorityIdentifier code must be TeletexString, PrintableString, UniversalString, UTF8String or BMPString!");
        }
        this.code_ = aSN1String;
        this.a = this.code_;
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        if (aSN1Object.isA(ASN.BOOLEAN)) {
            boolean bl = (Boolean)aSN1Object.getValue();
            if (!bl) {
                throw new X509ExtensionException("Boolean value in PublicAuthorityIdentifier extension must be true but is false!");
            }
        } else if (aSN1Object.isStringType()) {
            this.code_ = (ASN1String)aSN1Object;
        } else {
            throw new X509ExtensionException("Value in PublicAuthorityIdentifier extension must be of type BOOLEAN, TeletexString, PrintableString, UniversalString, UTF8String or BMPString!");
        }
        this.a = aSN1Object;
    }

    public ASN1Object toASN1Object() {
        if (this.a == null) {
            throw new NullPointerException("PublicAuthorityIdentifier code must not be null!");
        }
        return this.a;
    }

    public ASN1String getCode() {
        return this.code_;
    }

    public String getCodeString() {
        return this.code_ != null ? (String)this.code_.getValue() : null;
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof PublicAuthorityIdentifier) {
            PublicAuthorityIdentifier publicAuthorityIdentifier = (PublicAuthorityIdentifier)object;
            bl = this.code_ != null && publicAuthorityIdentifier.code_ != null ? this.code_.equals(publicAuthorityIdentifier.code_) : this.code_ == null && publicAuthorityIdentifier.code_ == null;
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.code_ != null) {
            stringBuffer.append("code: ");
            stringBuffer.append(this.code_.toString());
        } else if (this.a != null) {
            stringBuffer.append("isPublicAuthority: true");
        }
        return stringBuffer.toString();
    }
}

