/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1;

import iaik.asn1.ASN;
import iaik.asn1.ASN1String;
import iaik.asn1.CodingException;
import iaik.utils.UTF8CodingException;
import iaik.utils.Util;

public class UTF8String
extends ASN1String {
    private static boolean a = false;

    public static void setSkipInvalidEncodedUTF8Characters(boolean bl) {
        a = bl;
    }

    protected UTF8String() {
        this.asnType = ASN.UTF8String;
    }

    public UTF8String(String string) {
        this();
        this.setValue(string);
    }

    public Object getValue() {
        try {
            return UTF8String.getStringFromUTF8Encoding(this.value, a);
        }
        catch (CodingException codingException) {
            throw new RuntimeException("Error in UTF8 conversion: " + codingException.getMessage());
        }
    }

    public void setValue(Object object) {
        try {
            this.value = UTF8String.getUTF8EncodingFromString((String)object);
        }
        catch (CodingException codingException) {
            throw new RuntimeException("Error in UTF8 conversion: " + codingException.getMessage());
        }
    }

    public static byte[] getUTF8EncodingFromString(String string) throws CodingException {
        try {
            return Util.getUTF8EncodingFromCharArray(string.toCharArray());
        }
        catch (UTF8CodingException uTF8CodingException) {
            throw new CodingException(uTF8CodingException.getMessage());
        }
    }

    public static byte[] getUTF8EncodingFromCharArray(char[] cArray) throws CodingException {
        try {
            return Util.getUTF8EncodingFromCharArray(cArray);
        }
        catch (UTF8CodingException uTF8CodingException) {
            throw new CodingException(uTF8CodingException.getMessage());
        }
    }

    public static char[] getCharsFromUTF8Encoding(byte[] byArray) throws CodingException {
        try {
            return Util.getCharsFromUTF8Encoding(byArray, a);
        }
        catch (UTF8CodingException uTF8CodingException) {
            throw new CodingException(uTF8CodingException.getMessage());
        }
    }

    public static char[] getCharsFromUTF8Encoding(byte[] byArray, boolean bl) throws CodingException {
        try {
            return Util.getCharsFromUTF8Encoding(byArray, bl);
        }
        catch (UTF8CodingException uTF8CodingException) {
            throw new CodingException(uTF8CodingException.getMessage());
        }
    }

    public static String getStringFromUTF8Encoding(byte[] byArray) throws CodingException {
        try {
            return Util.getStringFromUTF8Encoding(byArray, a);
        }
        catch (UTF8CodingException uTF8CodingException) {
            throw new CodingException(uTF8CodingException.getMessage());
        }
    }

    public static String getStringFromUTF8Encoding(byte[] byArray, boolean bl) throws CodingException {
        try {
            return Util.getStringFromUTF8Encoding(byArray, bl);
        }
        catch (UTF8CodingException uTF8CodingException) {
            throw new CodingException(uTF8CodingException.getMessage());
        }
    }

    public static String getRFC2253String(String string) throws CodingException {
        try {
            return Util.getRFC2253String(string.toCharArray());
        }
        catch (UTF8CodingException uTF8CodingException) {
            throw new CodingException(uTF8CodingException.getMessage());
        }
    }

    public static String getRFC2253String(String string, boolean bl) throws CodingException {
        try {
            return Util.getRFC2253String(string.toCharArray(), bl);
        }
        catch (UTF8CodingException uTF8CodingException) {
            throw new CodingException(uTF8CodingException.getMessage());
        }
    }

    public static String getRFC2253String(char[] cArray) throws CodingException {
        try {
            return Util.getRFC2253String(cArray);
        }
        catch (UTF8CodingException uTF8CodingException) {
            throw new CodingException(uTF8CodingException.getMessage());
        }
    }

    public static String getRFC2253String(char[] cArray, boolean bl) throws CodingException {
        try {
            return Util.getRFC2253String(cArray, bl);
        }
        catch (UTF8CodingException uTF8CodingException) {
            throw new CodingException(uTF8CodingException.getMessage());
        }
    }
}

