/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.SET;
import iaik.asn1.structures.AttributeValue;
import iaik.asn1.structures.UnknownAttributeValue;
import iaik.utils.CryptoUtils;
import iaik.utils.ObjectFactory;
import iaik.utils.Util;

public class Attribute
implements ASN1Type {
    private static ObjectFactory d = new ObjectFactory();
    private static final Class e = a == null ? (a = Attribute.class$("iaik.asn1.structures.AttributeValue")) : a;
    private ObjectID f;
    private AttributeValue[] g;
    private boolean h;
    static Class a;
    static Class b;
    static Class c;

    public static AttributeValue create(ObjectID objectID) throws InstantiationException {
        return (AttributeValue)d.create(objectID);
    }

    public static void register(ObjectID objectID, Class clazz) {
        if (!e.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class " + clazz + " is no AttributeValue implementation!");
        }
        d.register((Object)objectID, clazz);
    }

    public Attribute() {
        this.h = false;
    }

    public Attribute(ObjectID objectID, ASN1Object[] aSN1ObjectArray) {
        this(objectID, aSN1ObjectArray, false);
    }

    public Attribute(ObjectID objectID, ASN1Object[] aSN1ObjectArray, boolean bl) {
        this.f = objectID;
        if (aSN1ObjectArray != null) {
            this.g = new AttributeValue[aSN1ObjectArray.length];
            for (int i2 = 0; i2 < aSN1ObjectArray.length; ++i2) {
                this.g[i2] = new UnknownAttributeValue(objectID, aSN1ObjectArray[i2]);
            }
        }
        this.h = bl;
    }

    public Attribute(AttributeValue attributeValue) throws CodingException {
        this(attributeValue, false);
    }

    public Attribute(AttributeValue attributeValue, boolean bl) throws CodingException {
        if (attributeValue == null) {
            throw new NullPointerException("attributeValue must not be null!");
        }
        this.f = attributeValue.getAttributeType();
        this.g = new AttributeValue[]{attributeValue};
        this.h = bl;
    }

    public Attribute(ASN1Object aSN1Object) throws CodingException {
        this.decode(aSN1Object);
    }

    public void addAttributeValue(AttributeValue attributeValue) throws CodingException, IllegalArgumentException {
        if (attributeValue == null) {
            throw new NullPointerException("attributeValue must not be null!");
        }
        ObjectID objectID = attributeValue.getAttributeType();
        if (this.f != null) {
            if (!this.f.equals(objectID)) {
                throw new IllegalArgumentException("Cannot add AttributeValue: Invalid type: " + objectID.getName() + ". Expected " + this.f.getName());
            }
        } else {
            this.f = objectID;
        }
        if (this.g == null) {
            this.g = new AttributeValue[1];
        } else if (attributeValue.multipleAllowed()) {
            this.g = (AttributeValue[])Util.resizeArray(this.g, this.g.length + 1);
        } else if (this.g.length > 1) {
            this.g = new AttributeValue[1];
        }
        this.g[this.g.length - 1] = attributeValue;
    }

    public void setAttributeValue(AttributeValue attributeValue) throws CodingException, IllegalArgumentException {
        if (attributeValue != null) {
            ObjectID objectID = attributeValue.getAttributeType();
            if (this.f != null) {
                if (!this.f.equals(objectID)) {
                    throw new IllegalArgumentException("Cannot set AttributeValue: Invalid type: " + objectID.getName() + ". Expected " + this.f.getName());
                }
            } else {
                this.f = objectID;
            }
            this.g = new AttributeValue[]{attributeValue};
        } else {
            this.g = null;
        }
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.f = (ObjectID)aSN1Object.getComponentAt(0);
        SET sET = (SET)aSN1Object.getComponentAt(1);
        this.g = new AttributeValue[sET.countComponents()];
        for (int i2 = 0; i2 < sET.countComponents(); ++i2) {
            ASN1Object aSN1Object2 = sET.getComponentAt(i2);
            try {
                this.g[i2] = Attribute.create(this.f);
            }
            catch (InstantiationException instantiationException) {
                this.g[i2] = new UnknownAttributeValue(this.f);
            }
            this.g[i2].decode(aSN1Object2);
        }
    }

    public ASN1Object toASN1Object() {
        return this.toASN1Object(this.h);
    }

    public ASN1Object toASN1Object(boolean bl) {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.f);
        SET sET = new SET(bl);
        if (this.g != null) {
            for (int i2 = 0; i2 < this.g.length; ++i2) {
                try {
                    sET.addComponent(this.g[i2].toASN1Object());
                    continue;
                }
                catch (CodingException codingException) {
                    throw new RuntimeException("ASN.1 component error: " + codingException.toString());
                }
            }
        }
        sEQUENCE.addComponent(sET);
        return sEQUENCE;
    }

    public ObjectID getType() {
        return this.f;
    }

    public ASN1Object[] getValue() {
        ASN1Object[] aSN1ObjectArray = null;
        if (this.g != null) {
            aSN1ObjectArray = new ASN1Object[this.g.length];
            for (int i2 = 0; i2 < this.g.length; ++i2) {
                try {
                    aSN1ObjectArray[i2] = this.g[i2].toASN1Object();
                    continue;
                }
                catch (CodingException codingException) {
                    throw new RuntimeException("ASN.1 component error: " + codingException.toString());
                }
            }
        }
        return aSN1ObjectArray;
    }

    public AttributeValue getAttributeValue() throws CodingException {
        if (this.g == null || this.g.length == 0) {
            return null;
        }
        return this.g[0];
    }

    public AttributeValue[] getAttributeValues() throws CodingException {
        if (this.g == null) {
            return new AttributeValue[0];
        }
        return this.g;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof Attribute) {
            Attribute attribute = (Attribute)object;
            if (this.f != null && attribute.f != null) {
                bl = this.f.equals(attribute.f);
            } else {
                boolean bl2 = bl = this.f == null && attribute.f == null;
            }
            if (bl) {
                bl = this.g != null && attribute.g != null ? (this.g.length == attribute.g.length ? CryptoUtils.equalsBlock(DerCoder.encode(this.toASN1Object()), DerCoder.encode(attribute.toASN1Object())) : false) : this.g == null && attribute.g == null;
            }
        }
        return bl;
    }

    public int hashCode() {
        return this.f == null ? 0 : this.f.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.f != null) {
            stringBuffer.append(this.f.getName() + ":\n");
        }
        if (this.g != null && this.g.length > 0) {
            for (int i2 = 0; i2 < this.g.length; ++i2) {
                stringBuffer.append(this.g[i2].toString());
            }
        }
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Attribute.register(ObjectID.extensionRequest, b == null ? (b = Attribute.class$("iaik.pkcs.pkcs9.ExtensionRequest")) : b);
        Attribute.register(ObjectID.challengePassword, c == null ? (c = Attribute.class$("iaik.pkcs.pkcs9.ChallengePassword")) : c);
    }
}

