/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1String;
import iaik.asn1.CodingException;
import iaik.asn1.IA5String;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.UTF8String;
import iaik.utils.InternalErrorException;
import java.math.BigInteger;

public class PolicyQualifierInfo {
    ObjectID a;
    String b;
    ASN1Object c;
    int[] d;
    ASN1Object e;
    private ASN1Object f;

    public PolicyQualifierInfo(String string) {
        this.a = ObjectID.id_pkix_cps;
        this.b = string;
        this.a();
    }

    public PolicyQualifierInfo(String string, int[] nArray, String string2) {
        this.a = ObjectID.id_pkix_unotice;
        if (string == null || nArray == null) {
            this.c = null;
            this.d = null;
        } else {
            this.c = new UTF8String(string);
            this.d = nArray;
        }
        if (string2 != null) {
            if (string2.length() > 200) {
                throw new IllegalArgumentException("explicitText too long! Maximal 200 characters allowed!");
            }
            this.e = new UTF8String(string2);
        }
        this.a();
    }

    public PolicyQualifierInfo(ASN1Object aSN1Object, int[] nArray, ASN1Object aSN1Object2) {
        this.a = ObjectID.id_pkix_unotice;
        if (aSN1Object == null || nArray == null) {
            this.c = null;
            this.d = null;
        } else {
            if (!aSN1Object.isStringType()) {
                throw new IllegalArgumentException("Invalid ASN.1 type for organization (only string types allowed): " + aSN1Object.getAsnType());
            }
            this.c = aSN1Object;
            this.d = nArray;
        }
        if (aSN1Object2 != null && !aSN1Object2.isStringType()) {
            throw new IllegalArgumentException("Invalid ASN.1 type for explicitText (only string types allowed): " + aSN1Object2.getAsnType());
        }
        this.e = aSN1Object2;
        this.a();
    }

    public PolicyQualifierInfo(ASN1Object aSN1Object) throws CodingException {
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("No PolicyQualifierInfo!");
        }
        this.a = (ObjectID)aSN1Object.getComponentAt(0);
        this.f = aSN1Object;
        int n2 = aSN1Object.countComponents();
        if (n2 != 2) {
            throw new CodingException("Invalid number (" + n2 + ") of policyQualifierInfo components!");
        }
        if (this.a.equals(ObjectID.id_pkix_cps)) {
            this.b = (String)aSN1Object.getComponentAt(1).getValue();
        } else if (this.a.equals(ObjectID.id_pkix_unotice)) {
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(1);
            for (int i2 = 0; i2 < aSN1Object2.countComponents(); ++i2) {
                ASN1Object aSN1Object3 = aSN1Object2.getComponentAt(i2);
                if (aSN1Object3.isA(ASN.SEQUENCE)) {
                    this.c = aSN1Object3.getComponentAt(0);
                    ASN1Object aSN1Object4 = aSN1Object3.getComponentAt(1);
                    this.d = new int[aSN1Object4.countComponents()];
                    for (int i3 = 0; i3 < aSN1Object4.countComponents(); ++i3) {
                        this.d[i3] = ((BigInteger)aSN1Object4.getComponentAt(i3).getValue()).intValue();
                    }
                    continue;
                }
                if (!(aSN1Object3 instanceof ASN1String)) {
                    throw new CodingException("Invalid ASN.1 type for explicit text!");
                }
                this.e = aSN1Object3;
            }
        }
    }

    public ObjectID getPolicyQualifier() {
        return this.a;
    }

    public ASN1Object getQualifierValue() {
        try {
            return this.f.getComponentAt(1);
        }
        catch (CodingException codingException) {
            return null;
        }
    }

    public String getCPSuri() {
        return this.b;
    }

    public ASN1Object getOrganization() {
        return this.c;
    }

    public ASN1Object getExplicitTest() {
        return this.e;
    }

    public ASN1Object getExplicitText() {
        return this.e;
    }

    public int[] getNoticeNumbers() {
        return this.d;
    }

    public ASN1Object toASN1Object() {
        return this.f;
    }

    private void a() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.a);
        if (this.a.equals(ObjectID.id_pkix_cps)) {
            sEQUENCE.addComponent(new IA5String(this.b));
        } else if (this.a.equals(ObjectID.id_pkix_unotice)) {
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            if (this.c != null) {
                SEQUENCE sEQUENCE3 = new SEQUENCE();
                sEQUENCE3.addComponent(this.c);
                SEQUENCE sEQUENCE4 = new SEQUENCE();
                for (int i2 = 0; i2 < this.d.length; ++i2) {
                    sEQUENCE4.addComponent(new INTEGER(this.d[i2]));
                }
                sEQUENCE3.addComponent(sEQUENCE4);
                sEQUENCE2.addComponent(sEQUENCE3);
            }
            if (this.e != null) {
                sEQUENCE2.addComponent(this.e);
            }
            sEQUENCE.addComponent(sEQUENCE2);
        } else {
            throw new InternalErrorException("Unknown policyQualifierId");
        }
        this.f = sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("policyQualifierId: " + this.a.getName() + "\n");
        if (this.a.equals(ObjectID.id_pkix_cps)) {
            stringBuffer.append("CPS URI: " + this.b + "\n");
        } else if (this.a.equals(ObjectID.id_pkix_unotice)) {
            if (this.c != null) {
                stringBuffer.append("organization: " + this.c.getValue() + "\n");
            }
            if (this.d != null) {
                for (int i2 = 0; i2 < this.d.length; ++i2) {
                    stringBuffer.append("noticeNumber[" + i2 + "]: " + this.d[i2] + "\n");
                }
            }
            if (this.e != null) {
                stringBuffer.append("displayText: " + this.e.getValue() + "\n");
            }
        } else {
            stringBuffer.append("Unknown qualifier " + this.a + "\n");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }
}

