/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs1;

import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs1.MGF1;
import iaik.pkcs.pkcs1.MaskGenerationAlgorithm;
import iaik.pkcs.pkcs1.RSAOaepPSourceParameterSpec;
import iaik.security.md.SHA;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class RSAOaepParameterSpec
extends RSAOaepPSourceParameterSpec
implements Cloneable {
    public static final AlgorithmID DEFAULT_HASH_ALGORITHM = (AlgorithmID)AlgorithmID.sha1.clone();
    public static final AlgorithmID DEFAULT_MASK_GEN_ALGORITHM = (AlgorithmID)AlgorithmID.mgf1.clone();
    private AlgorithmID a;
    private MessageDigest b;
    private AlgorithmID c;
    private MaskGenerationAlgorithm d;
    private Boolean e;

    public RSAOaepParameterSpec() {
        this.a = (AlgorithmID)DEFAULT_HASH_ALGORITHM.clone();
        this.b = new SHA();
        this.c = (AlgorithmID)AlgorithmID.mgf1.clone();
        this.c.setParameter(this.a.toASN1Object());
        this.d = new MGF1(this.a, this.b);
    }

    public RSAOaepParameterSpec(AlgorithmID algorithmID, AlgorithmID algorithmID2, AlgorithmID algorithmID3) {
        super(algorithmID3);
        if (algorithmID == null) {
            throw new IllegalArgumentException("HashAlgorithm id must not be null!");
        }
        this.a = algorithmID;
        if (algorithmID2 == null) {
            throw new IllegalArgumentException("MaskGenAlgorithm id must no be null!");
        }
        this.c = algorithmID2;
    }

    public AlgorithmID getHashAlgorithm() {
        return this.a;
    }

    public AlgorithmID getMaskGenAlgorithm() {
        return this.c;
    }

    public void setHashEngine(MessageDigest messageDigest) {
        this.b = messageDigest;
    }

    public MessageDigest getHashEngine() throws NoSuchAlgorithmException {
        if (this.b == null) {
            try {
                this.b = this.a.getMessageDigestInstance("IAIK");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.b = this.a.getMessageDigestInstance();
            }
        } else {
            this.b.reset();
        }
        return this.b;
    }

    public void setMGFEngine(MaskGenerationAlgorithm maskGenerationAlgorithm) {
        this.d = maskGenerationAlgorithm;
    }

    public MaskGenerationAlgorithm getMGFEngine() throws NoSuchAlgorithmException {
        if (this.d == null) {
            this.d = this.c.getMaskGenerationAlgorithmInstance();
            AlgorithmParameters algorithmParameters = this.c.getAlgorithmParameters();
            try {
                this.d.setParameters(algorithmParameters);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new NoSuchAlgorithmException("Cannot init MGF parameters: " + invalidAlgorithmParameterException.getMessage());
            }
        }
        return this.d;
    }

    public void setEncodeDefaultValues(Boolean bl) {
        this.e = bl;
    }

    public Boolean getEncodeDefaultValues() {
        return this.e;
    }

    public Object clone() {
        RSAOaepParameterSpec rSAOaepParameterSpec = null;
        try {
            rSAOaepParameterSpec = (RSAOaepParameterSpec)super.clone();
            rSAOaepParameterSpec.a = (AlgorithmID)this.a.clone();
            rSAOaepParameterSpec.c = (AlgorithmID)this.c.clone();
            rSAOaepParameterSpec.pSourceAlgorithm_ = (AlgorithmID)this.pSourceAlgorithm_.clone();
            if (this.b != null) {
                rSAOaepParameterSpec.b = (MessageDigest)this.b.clone();
            }
            if (this.d != null) {
                rSAOaepParameterSpec.d = (MaskGenerationAlgorithm)this.d.clone();
            }
            if (this.e != null) {
                rSAOaepParameterSpec.e = new Boolean(this.e);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return rSAOaepParameterSpec;
    }

    public int hashCode() {
        return this.a.hashCode() ^ this.c.hashCode() ^ this.pSourceAlgorithm_.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof RSAOaepParameterSpec) {
            RSAOaepParameterSpec rSAOaepParameterSpec = (RSAOaepParameterSpec)object;
            bl = super.equals(object) && this.a.equals(rSAOaepParameterSpec.a) && this.c.equals(rSAOaepParameterSpec.c, true) && this.pSourceAlgorithm_.equals(rSAOaepParameterSpec.pSourceAlgorithm_, true);
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Hash algorithm: " + this.a + "\n");
        stringBuffer.append("Mask generation algorithm: " + this.c + "\n");
        stringBuffer.append("PSource algorithm: " + this.pSourceAlgorithm_ + "\n");
        return stringBuffer.toString();
    }

    static {
        DEFAULT_MASK_GEN_ALGORITHM.setParameter(DEFAULT_HASH_ALGORITHM.toASN1Object());
    }
}

