/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs1;

import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs1.MGF1;
import iaik.pkcs.pkcs1.MaskGenerationAlgorithm;
import iaik.pkcs.pkcs1.RSAPssSaltParameterSpec;
import iaik.security.md.SHA;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class RSAPssParameterSpec
extends RSAPssSaltParameterSpec
implements Cloneable {
    public static final AlgorithmID DEFAULT_HASH_ALGORITHM = (AlgorithmID)AlgorithmID.sha1.clone();
    public static final AlgorithmID DEFAULT_MASK_GEN_ALGORITHM = (AlgorithmID)AlgorithmID.mgf1.clone();
    public static final int DEFAULT_TRAILER_FIELD;
    private AlgorithmID a;
    private MessageDigest b;
    private AlgorithmID c;
    private MaskGenerationAlgorithm d;
    private int e;
    private Boolean f;

    public RSAPssParameterSpec() {
        this.a = (AlgorithmID)DEFAULT_HASH_ALGORITHM.clone();
        this.b = new SHA();
        this.c = (AlgorithmID)AlgorithmID.mgf1.clone();
        this.c.setParameter(this.a.toASN1Object());
        this.d = new MGF1(this.c, this.b);
        this.e = DEFAULT_TRAILER_FIELD;
    }

    public RSAPssParameterSpec(AlgorithmID algorithmID, AlgorithmID algorithmID2, int n2) {
        super(n2);
        if (algorithmID == null) {
            throw new IllegalArgumentException("Cannot create RSAPssParameterSpec. Missing hashAlgorithm id!");
        }
        this.a = algorithmID;
        if (algorithmID2 == null) {
            throw new IllegalArgumentException("Cannot create RSAPssParameterSpec. Missing maskGenAlgorithm id!");
        }
        this.c = algorithmID2;
        this.e = DEFAULT_TRAILER_FIELD;
    }

    public RSAPssParameterSpec(AlgorithmID algorithmID, AlgorithmID algorithmID2, byte[] byArray) {
        super(byArray);
        if (algorithmID == null) {
            throw new IllegalArgumentException("Cannot create RSAPssParameterSpec. Missing hashAlgorithm id!");
        }
        this.a = algorithmID;
        if (algorithmID2 == null) {
            throw new IllegalArgumentException("Cannot create RSAPssParameterSpec. Missing maskGenAlgorithm id!");
        }
        this.c = algorithmID2;
        this.e = DEFAULT_TRAILER_FIELD;
    }

    public void setTrailerField(int n2) {
        this.e = n2;
    }

    public int getTrailerField() {
        return this.e;
    }

    public AlgorithmID getHashAlgorithm() {
        return this.a;
    }

    public AlgorithmID getMaskGenAlgorithm() {
        return this.c;
    }

    public void setHashEngine(MessageDigest messageDigest) {
        this.b = messageDigest;
    }

    public MessageDigest getHashEngine() throws NoSuchAlgorithmException {
        if (this.b == null) {
            try {
                this.b = this.a.getMessageDigestInstance("IAIK");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.b = this.a.getMessageDigestInstance();
            }
        } else {
            this.b.reset();
        }
        return this.b;
    }

    public void setMGFEngine(MaskGenerationAlgorithm maskGenerationAlgorithm) {
        this.d = maskGenerationAlgorithm;
    }

    public MaskGenerationAlgorithm getMGFEngine() throws NoSuchAlgorithmException {
        if (this.d == null) {
            this.d = this.c.getMaskGenerationAlgorithmInstance();
            AlgorithmParameters algorithmParameters = this.c.getAlgorithmParameters();
            try {
                this.d.setParameters(algorithmParameters);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new NoSuchAlgorithmException("Cannot init MGF parameters: " + invalidAlgorithmParameterException.getMessage());
            }
        }
        return this.d;
    }

    public void setEncodeDefaultValues(Boolean bl) {
        this.f = bl;
    }

    public Boolean getEncodeDefaultValues() {
        return this.f;
    }

    public Object clone() {
        RSAPssParameterSpec rSAPssParameterSpec = null;
        try {
            rSAPssParameterSpec = (RSAPssParameterSpec)super.clone();
            rSAPssParameterSpec.a = (AlgorithmID)this.a.clone();
            rSAPssParameterSpec.c = (AlgorithmID)this.c.clone();
            rSAPssParameterSpec.saltLength_ = this.saltLength_;
            rSAPssParameterSpec.e = this.e;
            if (this.b != null) {
                rSAPssParameterSpec.b = (MessageDigest)this.b.clone();
            }
            if (this.d != null) {
                rSAPssParameterSpec.d = (MaskGenerationAlgorithm)this.d.clone();
            }
            if (this.f != null) {
                rSAPssParameterSpec.f = new Boolean(this.f);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return rSAPssParameterSpec;
    }

    public int hashCode() {
        return this.a.hashCode() ^ this.c.hashCode() ^ this.saltLength_;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof RSAPssParameterSpec) {
            RSAPssParameterSpec rSAPssParameterSpec = (RSAPssParameterSpec)object;
            bl = super.equals(object);
            if (bl) {
                boolean bl2 = this.a.equals(rSAPssParameterSpec.a) && this.c.equals(rSAPssParameterSpec.c, true) && this.e == rSAPssParameterSpec.e;
                bl &= bl2;
            }
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Hash algorithm: " + this.a + "\n");
        stringBuffer.append("Mask generation algorithm: " + this.c + "\n");
        stringBuffer.append("Salt length: " + this.saltLength_ + "\n");
        stringBuffer.append("Trailer field: " + this.e + "\n");
        return stringBuffer.toString();
    }

    static {
        DEFAULT_MASK_GEN_ALGORITHM.setParameter(DEFAULT_HASH_ALGORITHM.toASN1Object());
        DEFAULT_TRAILER_FIELD = 1;
    }
}

