/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs12;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.pkcs.pkcs12.SafeBag;
import iaik.x509.X509Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;

public class CertificateBag
extends SafeBag {
    X509Certificate c;
    ASN1Object d = ObjectID.x509Certificate;

    public static X509Certificate[] getCertificates(CertificateBag[] certificateBagArray) {
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateBagArray.length];
        for (int i2 = 0; i2 < certificateBagArray.length; ++i2) {
            x509CertificateArray[i2] = certificateBagArray[i2].getCertificate();
        }
        return x509CertificateArray;
    }

    protected CertificateBag() {
        this.e = ObjectID.pkcs12_certBag;
    }

    public CertificateBag(X509Certificate x509Certificate) {
        this.c = x509Certificate;
        this.e = ObjectID.pkcs12_certBag;
    }

    public CertificateBag(X509Certificate x509Certificate, String string, byte[] byArray) {
        super(string, byArray);
        this.c = x509Certificate;
        this.e = ObjectID.pkcs12_certBag;
    }

    public X509Certificate getCertificate() {
        return this.c;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.d = aSN1Object.getComponentAt(0);
        ASN1Object aSN1Object2 = (ASN1Object)aSN1Object.getComponentAt(1).getValue();
        try {
            this.c = new X509Certificate((byte[])aSN1Object2.getValue());
        }
        catch (CertificateException certificateException) {
            throw new CodingException("Error decoding certifcate! " + certificateException);
        }
    }

    public ASN1Object toASN1Object() throws CodingException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.d);
        try {
            OCTET_STRING oCTET_STRING = new OCTET_STRING(this.c.getEncoded());
            sEQUENCE.addComponent(new CON_SPEC(0, oCTET_STRING));
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new CodingException("Error encoding certificate!" + certificateEncodingException);
        }
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Certificate type: " + this.c.getType() + "\n");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }
}

