/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs12;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.Attribute;
import iaik.pkcs.PKCSException;
import iaik.pkcs.pkcs12.Attributes;
import iaik.pkcs.pkcs12.a;
import iaik.utils.Util;

public abstract class SafeBag
extends Attributes
implements ASN1Type {
    ObjectID e;
    private static a c = new a();
    static Class f;
    static Class g;
    static Class h;
    static Class i;
    static Class j;
    static Class k;
    static Class l;

    public static SafeBag create(ObjectID objectID) throws PKCSException {
        try {
            return (SafeBag)c.create(objectID);
        }
        catch (InstantiationException instantiationException) {
            throw new PKCSException("No PKCS#12 bag type registered for the given object ID! " + instantiationException);
        }
    }

    public static void register(ObjectID objectID, Class clazz) {
        c.register((Object)objectID, clazz);
    }

    protected static byte[] encodeSafeContents(SafeBag[] safeBagArray) throws CodingException {
        ASN1Object aSN1Object = SafeBag.encodeSafeContentsAsASN1Object(safeBagArray);
        return DerCoder.encode(aSN1Object);
    }

    protected static ASN1Object encodeSafeContentsAsASN1Object(SafeBag[] safeBagArray) throws CodingException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        for (int i2 = 0; i2 < safeBagArray.length; ++i2) {
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent(safeBagArray[i2].getBagType());
            sEQUENCE2.addComponent(new CON_SPEC(0, safeBagArray[i2].toASN1Object()));
            ASN1Type[] aSN1TypeArray = safeBagArray[i2].getAttributes();
            if (aSN1TypeArray != null) {
                sEQUENCE2.addComponent(ASN.createSetOf(aSN1TypeArray));
            }
            sEQUENCE.addComponent(sEQUENCE2);
        }
        return sEQUENCE;
    }

    protected static SafeBag[] parseSafeContents(byte[] byArray) throws CodingException {
        ASN1Object aSN1Object = DerCoder.decode(byArray);
        return SafeBag.parseSafeContents(aSN1Object);
    }

    protected static SafeBag[] parseSafeContents(ASN1Object aSN1Object) throws CodingException {
        SafeBag[] safeBagArray = null;
        ASN1Object aSN1Object2 = aSN1Object;
        safeBagArray = new SafeBag[aSN1Object2.countComponents()];
        for (int i2 = 0; i2 < aSN1Object2.countComponents(); ++i2) {
            ASN1Object aSN1Object3 = aSN1Object2.getComponentAt(i2);
            ObjectID objectID = (ObjectID)aSN1Object3.getComponentAt(0);
            SafeBag safeBag = null;
            try {
                safeBag = SafeBag.create(objectID);
            }
            catch (PKCSException pKCSException) {
                // empty catch block
            }
            ASN1Object aSN1Object4 = aSN1Object3.getComponentAt(1);
            if (aSN1Object4.getAsnType().getTag() != 0) {
                throw new CodingException("No PKCS#12 SafeBag!");
            }
            safeBag.decode((ASN1Object)aSN1Object4.getValue());
            if (aSN1Object3.countComponents() > 2) {
                Attribute[] attributeArray = (Attribute[])ASN.parseSequenceOf(aSN1Object3.getComponentAt(2), l == null ? SafeBag.class$("iaik.asn1.structures.Attribute") : l);
                safeBag.setAttributes(attributeArray);
            }
            safeBagArray[i2] = safeBag;
        }
        return safeBagArray;
    }

    protected SafeBag() {
    }

    protected SafeBag(String string, byte[] byArray) {
        super(string, byArray);
    }

    public ObjectID getBagType() {
        return this.e;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Bag type: " + this.e + "\n");
        if (this.a != null) {
            stringBuffer.append("Friendly name: " + this.a + "\n");
        }
        if (this.b != null) {
            stringBuffer.append("local key ID: " + Util.toString(this.b) + "\n");
        }
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        SafeBag.register(ObjectID.pkcs12_keyBag, f == null ? (f = SafeBag.class$("iaik.pkcs.pkcs12.KeyBag")) : f);
        SafeBag.register(ObjectID.pkcs12_pkcs8ShroudedKeyBag, g == null ? (g = SafeBag.class$("iaik.pkcs.pkcs12.PKCS8ShroudedKeyBag")) : g);
        SafeBag.register(ObjectID.pkcs12_certBag, h == null ? (h = SafeBag.class$("iaik.pkcs.pkcs12.CertificateBag")) : h);
        SafeBag.register(ObjectID.pkcs12_crlBag, i == null ? (i = SafeBag.class$("iaik.pkcs.pkcs12.CRLBag")) : i);
        SafeBag.register(ObjectID.pkcs12_secretBag, j == null ? (j = SafeBag.class$("iaik.pkcs.pkcs12.SecretBag")) : j);
        SafeBag.register(ObjectID.pkcs12_safeContentsBag, k == null ? (k = SafeBag.class$("iaik.pkcs.pkcs12.SafeContentsBag")) : k);
    }
}

