/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.EncodeListener;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.ContentInfoStream;
import iaik.pkcs.pkcs7.ContentStream;
import iaik.pkcs.pkcs7.DataStream;
import iaik.utils.CryptoUtils;
import iaik.utils.EOFListener;
import iaik.utils.NotifyEOFInputStream;
import iaik.utils.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestedDataStream
implements EncodeListener,
ContentStream,
EOFListener {
    public static final int IMPLICIT = 1;
    public static final int EXPLICIT = 2;
    int b = 0;
    AlgorithmID c;
    MessageDigest d;
    protected ObjectID content_type;
    protected DerInputStream this_object;
    protected int block_size = 2048;
    private ContentInfoStream a;
    byte[] e;
    byte[] f;
    protected InputStream input_stream;
    protected int mode = 1;

    protected DigestedDataStream() {
    }

    public DigestedDataStream(InputStream inputStream, AlgorithmID algorithmID, int n2) throws PKCSException {
        this();
        if (algorithmID == null) {
            throw new PKCSException("No digestAlgorithm specified!");
        }
        if (n2 != 1 && n2 != 2) {
            throw new PKCSException("Illegal mode specification: " + n2 + "!");
        }
        if (inputStream == null) {
            throw new PKCSException("No data input stream specified!");
        }
        this.content_type = ObjectID.pkcs7_data;
        this.mode = n2;
        this.input_stream = inputStream;
        this.c = (AlgorithmID)algorithmID.clone();
        try {
            this.setupMessageDigest(this.c, false);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCSException(noSuchAlgorithmException.getMessage());
        }
    }

    public DigestedDataStream(ObjectID objectID, AlgorithmID algorithmID, byte[] byArray) {
        this();
        this.mode = 2;
        this.content_type = objectID;
        this.a = new ContentInfoStream(objectID);
        this.c = algorithmID;
        this.e = byArray;
    }

    public DigestedDataStream(InputStream inputStream) throws IOException, PKCSParsingException {
        this();
        this.decode(inputStream);
    }

    public DigestedDataStream(InputStream inputStream, AlgorithmID algorithmID) throws IOException {
        this();
        if (algorithmID == null) {
            throw new IOException("No digestAlgorithm specified!");
        }
        if (inputStream == null) {
            throw new IOException("No input stream supplied!");
        }
        this.input_stream = inputStream;
        this.mode = 2;
        this.c = algorithmID;
        try {
            this.setupMessageDigest(this.c, true);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException(noSuchAlgorithmException.getMessage());
        }
    }

    void setupMessageDigest(AlgorithmID algorithmID, boolean bl) throws NoSuchAlgorithmException {
        this.d = this.c.getMessageDigestInstance();
        this.input_stream = new DigestInputStream(this.input_stream, this.d);
    }

    public void decode(InputStream inputStream) throws IOException, PKCSParsingException {
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        this.this_object = ((DerInputStream)inputStream).readSequence();
        this.b = this.this_object.readInteger().intValue();
        this.c = new AlgorithmID(this.this_object);
        this.a = new ContentInfoStream(this.this_object);
        this.content_type = this.a.getContentType();
        if (!this.a.hasContent()) {
            this.mode = 2;
            this.notifyEOF();
            return;
        }
        if (!this.content_type.equals(ObjectID.pkcs7_data)) {
            throw new IOException("DigestedData only for content type Data at this time!");
        }
        DataStream dataStream = (DataStream)this.a.getContent();
        this.input_stream = dataStream.getInputStream();
        try {
            this.setupMessageDigest(this.c, true);
            this.input_stream = new NotifyEOFInputStream(this.input_stream);
            ((NotifyEOFInputStream)this.input_stream).addEOFListener(this);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("No implementation for hash algorithm: " + noSuchAlgorithmException.getMessage());
        }
    }

    public ObjectID getContentType() {
        return ObjectID.pkcs7_digestedData;
    }

    public int getVersion() {
        return this.b;
    }

    public AlgorithmID getDigestAlgorithm() {
        return this.c;
    }

    public byte[] getDigest() {
        return this.e;
    }

    public void setDigest(byte[] byArray) {
        this.e = byArray;
    }

    public void setBlockSize(int n2) {
        this.block_size = n2;
    }

    public int getBlockSize() {
        return this.block_size;
    }

    public InputStream getInputStream() {
        return this.input_stream;
    }

    public ASN1Object toASN1Object() throws PKCSException {
        return this.toASN1Object(-1);
    }

    protected ASN1Object toASN1Object(int n2) throws PKCSException {
        if (n2 <= 0) {
            n2 = this.block_size;
        }
        if (this.c == null) {
            throw new PKCSException("digestAlgorithm not set!");
        }
        if (this.mode == 1) {
            if (this.input_stream == null) {
                throw new PKCSException("InputStream not set!");
            }
            if (this.d == null) {
                throw new PKCSException("Message Digest not initialized for digest computation!");
            }
            this.a = new ContentInfoStream(new DataStream(this.input_stream, n2));
        } else if (this.a == null) {
            this.a = new ContentInfoStream(ObjectID.pkcs7_data);
        }
        SEQUENCE sEQUENCE = new SEQUENCE(true);
        sEQUENCE.addComponent(new INTEGER(this.b));
        sEQUENCE.addComponent(this.c.toASN1Object());
        sEQUENCE.addComponent(this.a.toASN1Object());
        if (this.e != null) {
            sEQUENCE.addComponent(new OCTET_STRING(this.e));
        } else {
            OCTET_STRING oCTET_STRING = new OCTET_STRING();
            oCTET_STRING.addEncodeListener(this, 1);
            sEQUENCE.addComponent(oCTET_STRING);
        }
        return sEQUENCE;
    }

    public void encodeCalled(ASN1Object aSN1Object, int n2) throws CodingException {
        try {
            if (this.e != null) {
                aSN1Object.setValue(this.e);
            } else {
                if (this.d == null) {
                    throw new CodingException("Message Digest not initialized!");
                }
                this.e = this.d.digest();
                aSN1Object.setValue(this.e);
            }
        }
        catch (Exception exception) {
            throw new CodingException("Unable to calculate digest: " + exception.getMessage());
        }
    }

    public void notifyEOF() throws IOException {
        this.e = this.this_object.readOctetStringByteArray();
    }

    public boolean verify() throws PKCSException {
        if (this.e == null) {
            throw new PKCSException("digest value not parsed from encoding!");
        }
        if (this.f != null) {
            return CryptoUtils.secureEqualsBlock(this.f, this.e);
        }
        if (this.d == null) {
            throw new PKCSException("MessageDigest not initialized for digest computation!");
        }
        this.f = this.d.digest();
        return CryptoUtils.secureEqualsBlock(this.f, this.e);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            DerCoder.encodeTo(this.toASN1Object(), outputStream);
        }
        catch (PKCSException pKCSException) {
            throw new IOException(pKCSException.toString());
        }
    }

    public void writeTo(OutputStream outputStream, int n2) throws IOException {
        try {
            DerCoder.encodeTo(this.toASN1Object(n2), outputStream);
        }
        catch (PKCSException pKCSException) {
            throw new IOException(pKCSException.toString());
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.b + "\n");
        if (this.c != null) {
            stringBuffer.append("digestAlgorithm: " + this.c.getName());
        }
        stringBuffer.append("ContentInfo: " + this.a);
        stringBuffer.append("\n");
        stringBuffer.append("digest: " + Util.toString(this.e));
        return stringBuffer.toString();
    }
}

