/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.security.cipher.GCMParameterSpec;
import iaik.utils.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public class GCMParameters
extends AlgorithmParametersSpi {
    private byte[] a;
    private int b;
    private byte[] c;
    private byte[] d;

    public GCMParameters() throws InvalidAlgorithmParameterException {
        this(null, null, null, -1);
    }

    public GCMParameters(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) throws InvalidAlgorithmParameterException {
        this.a = byArray2;
        this.b = n2;
        this.c = byArray;
        this.d = byArray3;
        if ((this.d == null || this.d.length == 0) && n2 == -1) {
            n2 = 12;
        } else {
            if (n2 == -1) {
                n2 = this.d.length;
            }
            if ((n2 < 12 || n2 > 16) && n2 != 4 && n2 != 8) {
                throw new InvalidAlgorithmParameterException("Invalid MAC length - valid length values: 4,8,12,13,14,15,16 bytes!");
            }
        }
    }

    protected byte[] engineGetEncoded() throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new OCTET_STRING(this.a));
        sEQUENCE.addComponent(new INTEGER(this.b));
        return DerCoder.encode(sEQUENCE);
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        GCMParameterSpec gCMParameterSpec;
        try {
            gCMParameterSpec = this.d == null ? new GCMParameterSpec(this.c, this.a, this.b) : new GCMParameterSpec(this.c, this.a, this.d);
        }
        catch (Exception exception) {
            throw new InvalidParameterSpecException(exception.toString());
        }
        if (!gCMParameterSpec.getClass().isAssignableFrom(clazz)) {
            throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
        }
        return gCMParameterSpec;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof GCMParameterSpec) {
            GCMParameterSpec gCMParameterSpec = (GCMParameterSpec)algorithmParameterSpec;
            this.a = gCMParameterSpec.getNonce();
            this.b = gCMParameterSpec.getMacLength();
            this.c = gCMParameterSpec.getAAD();
            this.d = gCMParameterSpec.getMac();
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            this.a = ((IvParameterSpec)algorithmParameterSpec).getIV();
        } else {
            throw new InvalidParameterSpecException("Can not initialize from class " + algorithmParameterSpec.getClass().getName());
        }
    }

    protected void engineInit(byte[] byArray) throws IOException {
        block5: {
            try {
                ASN1Object aSN1Object = DerCoder.decode(byArray);
                if (aSN1Object.isA(ASN.SEQUENCE)) {
                    this.a = (byte[])aSN1Object.getComponentAt(0).getValue();
                    this.b = ((BigInteger)aSN1Object.getComponentAt(1).getValue()).intValue();
                    if (this.b == -1) {
                        this.b = 12;
                    }
                    if ((this.b < 12 || this.b > 16) && this.b != 4 && this.b != 8) {
                        throw new IOException("Invalid MAC length - valid length values: 4,8,12,13,14,15,16 bytes!");
                    }
                    break block5;
                }
                throw new IOException("Cannot decode GCM params. Invalid ASN.1 type!");
            }
            catch (CodingException codingException) {
                throw new IOException("DER decoding error. " + codingException.toString());
            }
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AAD: " + (this.c != null ? Util.toString(this.c) : "null") + "\n");
        stringBuffer.append("nonce: " + (this.a != null ? Util.toString(this.a) : "null") + "\n");
        stringBuffer.append("macLength: " + this.b + "\n");
        return stringBuffer.toString();
    }
}

