/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dsa;

import iaik.security.dsa.SHA2withDSAGenParameterSpec;
import iaik.security.dsa.SHA2withDSAParameterSpec;
import iaik.security.dsa.SHA2withDSAParams;
import iaik.security.random.SecRandom;
import iaik.utils.NumberTheory;
import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public abstract class SHA2withDSAParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private int c = -1;
    private int d = -1;
    private int e = -1;
    MessageDigest a;
    private int f;
    SecureRandom b;

    SHA2withDSAParameterGenerator(MessageDigest messageDigest, int n2) {
        this.a = messageDigest;
        this.f = n2;
    }

    protected void engineInit(int n2, SecureRandom secureRandom) {
        this.b = secureRandom;
        this.d = n2;
        switch (n2) {
            case 1024: {
                this.c = 160;
                break;
            }
            case 2048: {
                this.c = 256;
                break;
            }
            case 3072: {
                this.c = 256;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid prime modulus length (" + n2 + "). Must be 1024, 2048 or 3072.");
            }
        }
        this.e = -1;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof SHA2withDSAGenParameterSpec) {
            SHA2withDSAGenParameterSpec sHA2withDSAGenParameterSpec = (SHA2withDSAGenParameterSpec)algorithmParameterSpec;
            this.d = sHA2withDSAGenParameterSpec.getL();
            this.c = sHA2withDSAGenParameterSpec.getN();
            this.e = sHA2withDSAGenParameterSpec.getSeedlen();
            if (this.f < this.c) {
                throw new InvalidAlgorithmParameterException("Invalid parameters. Hash output length (" + this.f + ") must be greater than N (" + this.c + ")");
            }
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be SHA2withDSAGenParameterSpec.");
        }
        this.b = secureRandom;
    }

    protected AlgorithmParameters engineGenerateParameters() {
        if (this.b == null) {
            this.b = SecRandom.getDefault();
        }
        if (this.d == -1) {
            this.d = 2048;
            this.e = this.c = this.f;
        }
        if (this.e == -1) {
            this.e = this.c;
        }
        SHA2withDSAParams sHA2withDSAParams = this.a(this.d, this.c, this.e, this.a, this.f);
        SHA2withDSAParameterSpec sHA2withDSAParameterSpec = new SHA2withDSAParameterSpec(sHA2withDSAParams.getP(), sHA2withDSAParams.getQ(), sHA2withDSAParams.getG());
        sHA2withDSAParameterSpec.a(sHA2withDSAParams.getCounter());
        sHA2withDSAParameterSpec.a(sHA2withDSAParams.getSeed());
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("DSA", "IAIK");
            algorithmParameters.init(sHA2withDSAParameterSpec);
            return algorithmParameters;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException(invalidParameterSpecException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.toString());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException(noSuchProviderException.toString());
        }
    }

    private synchronized SHA2withDSAParams a(int n2, int n3, int n4, MessageDigest messageDigest, int n5) {
        BigInteger bigInteger;
        Object object;
        BigInteger bigInteger2;
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = null;
        int n6 = n4 / 8;
        messageDigest.reset();
        BigInteger bigInteger5 = NumberTheory.TWO.pow(n3 - 1);
        BigInteger bigInteger6 = bigInteger5.add(NumberTheory.ONE);
        int n7 = 4 * n2 - 1;
        BigInteger bigInteger7 = NumberTheory.TWO.pow(n2 - 1);
        int n8 = (n2 + n5 - 1) / n5 - 1;
        int n9 = n2 - 1 - n8 * n5;
        BigInteger bigInteger8 = NumberTheory.TWO.pow(n9);
        byte[] byArray = new byte[n6];
        int n10 = 0;
        boolean bl = true;
        block0: while (bl) {
            BigInteger bigInteger9;
            do {
                this.b.nextBytes(byArray);
            } while (!NumberTheory.isProbablePrime(bigInteger4 = bigInteger6.add(bigInteger9 = new BigInteger(1, messageDigest.digest(byArray)).mod(bigInteger5)).subtract(bigInteger9.mod(NumberTheory.TWO))));
            int n11 = 1;
            for (n10 = 0; n10 <= n7; ++n10) {
                BigInteger bigInteger10;
                bigInteger2 = NumberTheory.ZERO;
                int n12 = 0;
                for (int i2 = 0; i2 < n8; ++i2) {
                    object = messageDigest.digest(SHA2withDSAParameterGenerator.a(byArray, n11 + i2));
                    bigInteger2 = bigInteger2.add(new BigInteger(1, (byte[])object).shiftLeft(n12));
                    n12 += n5;
                }
                object = messageDigest.digest(SHA2withDSAParameterGenerator.a(byArray, n11 + n8));
                BigInteger bigInteger11 = (bigInteger2 = bigInteger2.add(new BigInteger(1, (byte[])object).mod(bigInteger8).shiftLeft(n12))).add(bigInteger7);
                bigInteger3 = bigInteger11.subtract((bigInteger10 = bigInteger11.mod(bigInteger4.shiftLeft(1))).subtract(NumberTheory.ONE));
                if (bigInteger3.compareTo(bigInteger7) >= 0 && NumberTheory.isProbablePrime(bigInteger3)) {
                    bl = false;
                    continue block0;
                }
                n11 += n8 + 1;
            }
        }
        bigInteger2 = bigInteger3.subtract(NumberTheory.ONE).divide(bigInteger4);
        BigInteger bigInteger12 = NumberTheory.ONE;
        while ((bigInteger = (bigInteger12 = bigInteger12.add(NumberTheory.ONE)).modPow(bigInteger2, bigInteger3)).compareTo(NumberTheory.ONE) == 0) {
        }
        object = new SHA2withDSAParams(bigInteger3, bigInteger4, bigInteger);
        ((SHA2withDSAParams)object).a(n10);
        ((SHA2withDSAParams)object).a(byArray);
        return object;
    }

    private static byte[] a(byte[] byArray, int n2) {
        int n3 = byArray.length;
        byte[] byArray2 = new byte[n3];
        for (int i2 = n3 - 1; i2 >= 0; --i2) {
            byArray2[i2] = (byte)(n2 += byArray[i2] & 0xFF);
            if ((n2 >>>= 8) != 0) continue;
            System.arraycopy(byArray, 0, byArray2, 0, i2);
            break;
        }
        return byArray2;
    }

    public static void validateParameters(BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, int n2, MessageDigest messageDigest, int n3) throws InvalidAlgorithmParameterException {
        if (messageDigest == null) {
            throw new NullPointerException("hashEngine must not be null!");
        }
        int n4 = bigInteger.bitLength();
        int n5 = bigInteger2.bitLength();
        switch (n4) {
            case 1024: {
                if (n5 == 160) break;
                throw new InvalidAlgorithmParameterException("Invalid (L,N) pair: (" + n4 + "/" + n5 + ")");
            }
            case 2048: {
                if (n5 == 224 || n5 == 256) break;
                throw new InvalidAlgorithmParameterException("Invalid (L,N) pair: (" + n4 + "/" + n5 + ")");
            }
            case 3072: {
                if (n5 == 256) break;
                throw new InvalidAlgorithmParameterException("Invalid (L,N) pair: (" + n4 + "/" + n5 + ")");
            }
            default: {
                throw new InvalidAlgorithmParameterException("Invalid (L,N) pair: (" + n4 + "/" + n5 + ")");
            }
        }
        if (n2 > 4 * n4 - 1) {
            throw new InvalidAlgorithmParameterException("Invalid counter (" + n2 + "). Must not be > 4L-1!");
        }
        int n6 = byArray.length * 8;
        if (n6 < n5) {
            throw new InvalidAlgorithmParameterException("Invalid seed. Must not be shorter than N!");
        }
        messageDigest.reset();
        BigInteger bigInteger3 = NumberTheory.TWO.pow(n5 - 1);
        BigInteger bigInteger4 = new BigInteger(1, messageDigest.digest(byArray)).mod(bigInteger3);
        BigInteger bigInteger5 = bigInteger4.mod(NumberTheory.TWO);
        BigInteger bigInteger6 = bigInteger3.add(bigInteger4).add(NumberTheory.ONE).subtract(bigInteger5);
        if (bigInteger6.compareTo(bigInteger2) != 0) {
            throw new InvalidAlgorithmParameterException("Invalid q. Does not match to computed q!");
        }
        if (!NumberTheory.isProbablePrime(bigInteger6)) {
            throw new InvalidAlgorithmParameterException("Computed q not prime!");
        }
        int n7 = (n4 + n3 - 1) / n3 - 1;
        int n8 = n4 - 1 - n7 * n3;
        int n9 = 1;
        BigInteger bigInteger7 = NumberTheory.TWO.pow(n8);
        BigInteger bigInteger8 = NumberTheory.TWO.pow(n4 - 1);
        int n10 = 0;
        BigInteger bigInteger9 = null;
        for (n10 = 0; n10 <= n2; ++n10) {
            BigInteger bigInteger10;
            byte[] byArray2;
            BigInteger bigInteger11 = NumberTheory.ZERO;
            int n11 = 0;
            for (int i2 = 0; i2 < n7; ++i2) {
                byArray2 = messageDigest.digest(SHA2withDSAParameterGenerator.a(byArray, n9 + i2));
                bigInteger11 = bigInteger11.add(new BigInteger(1, byArray2).shiftLeft(n11));
                n11 += n3;
            }
            byArray2 = messageDigest.digest(SHA2withDSAParameterGenerator.a(byArray, n9 + n7));
            BigInteger bigInteger12 = (bigInteger11 = bigInteger11.add(new BigInteger(1, byArray2).mod(bigInteger7).shiftLeft(n11))).add(bigInteger8);
            bigInteger9 = bigInteger12.subtract((bigInteger10 = bigInteger12.mod(bigInteger2.shiftLeft(1))).subtract(NumberTheory.ONE));
            if (bigInteger9.compareTo(bigInteger8) >= 0 && NumberTheory.isProbablePrime(bigInteger9)) break;
            n9 += n7 + 1;
        }
        if (n10 != n2) {
            throw new InvalidAlgorithmParameterException("Invalid counter!");
        }
        if (bigInteger9.compareTo(bigInteger) != 0) {
            throw new InvalidAlgorithmParameterException("Invalid p. Does not match to computed p!");
        }
        if (!NumberTheory.isProbablePrime(bigInteger9)) {
            throw new InvalidAlgorithmParameterException("Computed p not prime!");
        }
    }
}

