/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.elgamal;

import iaik.security.elgamal.ElGamalParameterSpec;
import iaik.security.elgamal.ElGamalPrivateKey;
import iaik.security.elgamal.ElGamalPrivateKeySpec;
import iaik.security.elgamal.ElGamalPublicKey;
import iaik.security.elgamal.ElGamalPublicKeySpec;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class ElGamalKeyFactory
extends KeyFactorySpi {
    static Class a;
    static Class b;
    static Class c;
    static Class d;

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof ElGamalPrivateKeySpec) {
                return new ElGamalPrivateKey((ElGamalPrivateKeySpec)keySpec);
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                return new ElGamalPrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Only ElGamal key specs allowed.");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Invalid KeySpec.");
        }
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof ElGamalPublicKeySpec) {
                return new ElGamalPublicKey((ElGamalPublicKeySpec)keySpec);
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new ElGamalPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Only ElGamal key specs allowed.");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Invalid KeySpec.");
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (key instanceof ElGamalPublicKey) {
            if ((a == null ? (a = ElGamalKeyFactory.class$("iaik.security.elgamal.ElGamalPublicKeySpec")) : a).isAssignableFrom(clazz)) {
                ElGamalPublicKey elGamalPublicKey = (ElGamalPublicKey)key;
                ElGamalParameterSpec elGamalParameterSpec = elGamalPublicKey.getParams();
                return new ElGamalPublicKeySpec(elGamalPublicKey.getY(), elGamalParameterSpec.getP(), elGamalParameterSpec.getG());
            }
            if ((b == null ? (b = ElGamalKeyFactory.class$("java.security.spec.X509EncodedKeySpec")) : b).isAssignableFrom(clazz)) {
                return new X509EncodedKeySpec(key.getEncoded());
            }
            throw new InvalidKeySpecException("Can't convert key to KeySpec.");
        }
        if (key instanceof ElGamalPrivateKey) {
            ElGamalPrivateKey elGamalPrivateKey = (ElGamalPrivateKey)key;
            if ((c == null ? (c = ElGamalKeyFactory.class$("iaik.security.elgamal.ElGamalPrivateKeySpec")) : c).isAssignableFrom(clazz)) {
                ElGamalParameterSpec elGamalParameterSpec = elGamalPrivateKey.getParams();
                return new ElGamalPrivateKeySpec(elGamalPrivateKey.getX(), elGamalParameterSpec.getP(), elGamalParameterSpec.getG());
            }
            if ((d == null ? (d = ElGamalKeyFactory.class$("java.security.spec.PKCS8EncodedKeySpec")) : d).isAssignableFrom(clazz)) {
                return new PKCS8EncodedKeySpec(elGamalPrivateKey.getEncoded());
            }
            throw new InvalidKeySpecException("Can't convert key to KeySpec.");
        }
        throw new InvalidKeySpecException("Can only convert ElGamal keys.");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof ElGamalPublicKey) {
            BigInteger bigInteger = ((ElGamalPublicKey)key).getY();
            ElGamalParameterSpec elGamalParameterSpec = ((ElGamalPublicKey)key).getParams();
            return new ElGamalPublicKey(bigInteger, elGamalParameterSpec);
        }
        if (key instanceof ElGamalPrivateKey) {
            BigInteger bigInteger = ((ElGamalPrivateKey)key).getX();
            ElGamalParameterSpec elGamalParameterSpec = ((ElGamalPrivateKey)key).getParams();
            return new ElGamalPrivateKey(bigInteger, elGamalParameterSpec);
        }
        throw new InvalidKeyException("Only keys of type ElGamalPublicKey and ElGamalPrivateKey can be translated.");
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

