/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.elgamal;

import iaik.security.elgamal.ElGamalParameterSpec;
import iaik.security.elgamal.ElGamalPrivateKey;
import iaik.security.elgamal.ElGamalPublicKey;
import iaik.security.random.SecRandom;
import iaik.utils.NumberTheory;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public final class ElGamalKeyPairGenerator
extends KeyPairGenerator {
    private static final BigInteger a = BigInteger.valueOf(2L);
    private ElGamalParameterSpec b;
    private SecureRandom c = new SecureRandom();
    private boolean d = false;
    private BigInteger e;
    private BigInteger f;
    private int g;

    public ElGamalKeyPairGenerator() {
        super("ElGamal");
    }

    public void initialize(int n2) {
        this.initialize(n2, null);
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 < 128) {
            throw new IllegalArgumentException("Invalid key size!");
        }
        this.c = secureRandom == null ? SecRandom.getDefault() : secureRandom;
        BigInteger bigInteger = NumberTheory.nextPrime(new BigInteger(n2, 80, this.c));
        try {
            this.initialize(new ElGamalParameterSpec(bigInteger, a), secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.initialize(algorithmParameterSpec, null);
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null) {
            throw new NullPointerException();
        }
        if (!(algorithmParameterSpec instanceof ElGamalParameterSpec)) {
            throw new InvalidAlgorithmParameterException("No ElGamal params!");
        }
        this.c = secureRandom == null ? SecRandom.getDefault() : secureRandom;
        this.b = (ElGamalParameterSpec)algorithmParameterSpec;
        this.e = this.b.getP();
        this.f = this.e.subtract(BigInteger.ONE);
        this.g = this.e.bitLength();
        this.d = true;
    }

    public KeyPair generateKeyPair() {
        if (!this.d) {
            throw new IllegalStateException("Not initialized");
        }
        BigInteger bigInteger = this.a();
        BigInteger bigInteger2 = this.b.getG().modPow(bigInteger, this.e);
        ElGamalPrivateKey elGamalPrivateKey = new ElGamalPrivateKey(bigInteger, this.b);
        ElGamalPublicKey elGamalPublicKey = new ElGamalPublicKey(bigInteger2, this.b);
        return new KeyPair(elGamalPublicKey, elGamalPrivateKey);
    }

    private BigInteger a() {
        BigInteger bigInteger;
        int n2 = this.b.getL();
        if (n2 > 0) {
            return new BigInteger(n2, this.c).setBit(n2 - 1);
        }
        while ((bigInteger = new BigInteger(this.g, this.c)).equals(BigInteger.ZERO) || bigInteger.compareTo(this.f) > 0) {
        }
        return bigInteger;
    }
}

