/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.rsa;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs1.RSACipher;
import iaik.utils.InternalErrorException;
import iaik.x509.PublicKeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.spec.RSAPublicKeySpec;

public class RSAPublicKey
extends PublicKeyInfo
implements java.security.interfaces.RSAPublicKey {
    private transient ASN1 a;
    private BigInteger c;
    private BigInteger d;

    RSAPublicKey() {
    }

    public RSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.a(bigInteger, bigInteger2);
        this.a(true);
    }

    public RSAPublicKey(RSAPublicKeySpec rSAPublicKeySpec) {
        this(rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
    }

    public RSAPublicKey(java.security.interfaces.RSAPublicKey rSAPublicKey) {
        this(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
    }

    public RSAPublicKey(byte[] byArray) throws InvalidKeyException {
        super(byArray);
    }

    public RSAPublicKey(ASN1Object aSN1Object) throws InvalidKeyException {
        super(aSN1Object);
    }

    public RSAPublicKey(InputStream inputStream) throws IOException, InvalidKeyException {
        super(inputStream);
    }

    void a(BigInteger bigInteger, BigInteger bigInteger2) {
        this.c = bigInteger;
        this.d = bigInteger2;
    }

    protected void decode(byte[] byArray) throws InvalidKeyException {
        try {
            this.a = new ASN1(byArray);
            this.c = (BigInteger)this.a.getComponentAt(0).getValue();
            this.d = (BigInteger)this.a.getComponentAt(1).getValue();
        }
        catch (Exception exception) {
            throw new InvalidKeyException("No RSA Public Key: " + exception.toString());
        }
    }

    public static RSAPublicKey parse(byte[] byArray) throws InvalidKeyException {
        RSAPublicKey rSAPublicKey = new RSAPublicKey();
        rSAPublicKey.decode(byArray);
        rSAPublicKey.a(true);
        return rSAPublicKey;
    }

    void a(boolean bl) {
        SEQUENCE sEQUENCE = null;
        try {
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(new INTEGER(this.c));
            sEQUENCE.addComponent(new INTEGER(this.d));
            this.a = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new InternalErrorException(codingException);
        }
        if (bl) {
            this.public_key_algorithm = (AlgorithmID)AlgorithmID.rsaEncryption.clone();
            this.createPublicKeyInfo();
        }
    }

    public byte[] encode() {
        return this.a.toByteArray();
    }

    public BigInteger crypt(BigInteger bigInteger) {
        return new RSACipher().rawPublicRSA(bigInteger, this);
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public BigInteger getPublicExponent() {
        return this.d;
    }

    public BigInteger getModulus() {
        return this.c;
    }

    public byte[] getFingerprint() {
        return this.a.fingerprint();
    }

    public int hashCode() {
        return this.d.hashCode() ^ this.c.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getAlgorithm() + " public key (" + this.c.bitLength() + " bits):\n");
        stringBuffer.append("public exponent: " + this.d.toString(16) + "\n");
        stringBuffer.append("modulus: " + this.c.toString(16) + "\n");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RSAPublicKey)) {
            return false;
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)object;
        return this.c.equals(rSAPublicKey.c) && this.d.equals(rSAPublicKey.d);
    }
}

