/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.rsa;

import iaik.security.md.Md5;
import iaik.security.md.SHA;
import iaik.security.rsa.RSA;
import iaik.utils.CryptoUtils;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;

public class SSLRSASignature
extends SignatureSpi {
    private MessageDigest a = new Md5();
    private MessageDigest b = new SHA();
    private RSA c;

    public SSLRSASignature() throws NoSuchAlgorithmException {
        try {
            this.c = RSA.a();
            this.c.setMode("ECB");
            this.c.setPadding("PKCS1Padding");
        }
        catch (Exception exception) {
            throw new NoSuchAlgorithmException(exception.toString());
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.c.init(2, publicKey, null);
        this.a.reset();
        this.b.reset();
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.appRandom = secureRandom;
        this.c.init(1, privateKey, secureRandom);
        this.a.reset();
        this.b.reset();
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = new byte[36];
        System.arraycopy(this.a.digest(), 0, byArray, 0, 16);
        System.arraycopy(this.b.digest(), 0, byArray, 16, 20);
        try {
            return this.c.doFinal(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        byte[] byArray2 = new byte[36];
        System.arraycopy(this.a.digest(), 0, byArray2, 0, 16);
        System.arraycopy(this.b.digest(), 0, byArray2, 16, 20);
        try {
            byte[] byArray3 = this.c.doFinal(byArray, 0, byArray.length);
            return CryptoUtils.secureEqualsBlock(byArray2, byArray3);
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    protected void engineUpdate(byte by) {
        this.a.update(by);
        this.b.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        this.a.update(byArray, n2, n3);
        this.b.update(byArray, n2, n3);
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("Method not supported!");
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("Method not supported!");
    }
}

