/*
 * Decompiled with CFR 0.152.
 */
package iaik.utils;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.Mac;

public class MacOutputStream
extends FilterOutputStream {
    protected boolean macingActive_;
    protected Mac macEngine_;

    public MacOutputStream(OutputStream outputStream, Mac mac) {
        super(outputStream);
        if (outputStream == null) {
            throw new NullPointerException("Argument \"stream\" must not be null.");
        }
        if (mac == null) {
            throw new NullPointerException("Argument \"macEngine\" must not be null.");
        }
        this.macingActive_ = true;
        this.setMac(mac);
    }

    public Mac getMac() {
        return this.macEngine_;
    }

    public void setMac(Mac mac) {
        if (mac == null) {
            throw new NullPointerException("Argument \"macEngine\" must not be null.");
        }
        this.macEngine_ = mac;
    }

    public void write(int n2) throws IOException {
        if (this.macingActive_) {
            this.macEngine_.update((byte)n2);
        }
        this.out.write(n2);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (this.macingActive_) {
            this.macEngine_.update(byArray, n2, n3);
        }
        this.out.write(byArray, n2, n3);
    }

    public void on(boolean bl) {
        this.macingActive_ = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MAC Input Stream (");
        stringBuffer.append(this.macingActive_ ? "MACing active" : "MACing inactive");
        stringBuffer.append(") using ");
        stringBuffer.append(this.macEngine_.toString());
        return stringBuffer.toString();
    }
}

