/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.security.md.Md5;
import iaik.utils.CryptoUtils;
import iaik.utils.InternalErrorException;
import iaik.utils.Util;
import iaik.x509.RawPublicKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

public abstract class PublicKeyInfo
implements ASN1Type,
Cloneable,
PublicKey {
    ASN1 b;
    protected AlgorithmID public_key_algorithm;

    protected PublicKeyInfo() {
    }

    public PublicKeyInfo(ASN1Object aSN1Object) throws InvalidKeyException {
        try {
            this.b = new ASN1(aSN1Object);
            this.a();
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("No PublicKeyInfo: " + codingException.toString());
        }
    }

    public PublicKeyInfo(InputStream inputStream) throws InvalidKeyException, IOException {
        try {
            this.b = new ASN1(inputStream);
            this.a();
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("No PublicKeyInfo: " + codingException.toString());
        }
    }

    public PublicKeyInfo(byte[] byArray) throws InvalidKeyException {
        try {
            this.b = new ASN1(byArray);
            this.a();
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("No PublicKeyInfo: " + codingException.toString());
        }
    }

    protected abstract void decode(byte[] var1) throws InvalidKeyException;

    protected abstract byte[] encode();

    public abstract String getAlgorithm();

    public AlgorithmID getAlgorithmID() {
        return this.public_key_algorithm;
    }

    public Object clone() {
        PublicKeyInfo publicKeyInfo = null;
        try {
            publicKeyInfo = (PublicKeyInfo)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return publicKeyInfo;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.b = new ASN1(aSN1Object);
        try {
            this.a();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CodingException(invalidKeyException.toString());
        }
    }

    private void a() throws InvalidKeyException {
        try {
            this.public_key_algorithm = new AlgorithmID(this.b.getComponentAt(0));
            this.decode((byte[])this.b.getComponentAt(1).getValue());
        }
        catch (Exception exception) {
            throw new InvalidKeyException("No PublicKeyInfo: " + exception.toString());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.getEncoded());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this.b = new ASN1(objectInputStream);
            this.a();
        }
        catch (CodingException codingException) {
            throw new IOException("Unable to restore PublicKeyInfo: " + codingException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException("Unable to restore PublicKeyInfo: " + invalidKeyException.toString());
        }
    }

    protected void createPublicKeyInfo() {
        SEQUENCE sEQUENCE = null;
        try {
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(this.public_key_algorithm.toASN1Object());
            sEQUENCE.addComponent(new BIT_STRING(this.encode()));
            this.b = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new InternalErrorException("CodingException!");
        }
    }

    public static PublicKey getPublicKey(ASN1Object aSN1Object) throws InvalidKeyException {
        return PublicKeyInfo.getPublicKey(aSN1Object, null);
    }

    public static PublicKey getPublicKey(ASN1Object aSN1Object, String string) throws InvalidKeyException {
        AlgorithmID algorithmID = null;
        PublicKey publicKey = null;
        try {
            algorithmID = new AlgorithmID(aSN1Object.getComponentAt(0));
            KeyFactory keyFactory = algorithmID.getKeyFactoryInstance(string);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(DerCoder.encode(aSN1Object));
            publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            publicKey = new RawPublicKey(aSN1Object);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Can't parse PublicKeyInfo: " + invalidKeySpecException.toString());
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("Can't parse PublicKeyInfo: " + codingException.toString());
        }
        return publicKey;
    }

    public static PublicKey getPublicKey(byte[] byArray) throws InvalidKeyException {
        return PublicKeyInfo.getPublicKey(byArray, null);
    }

    public static PublicKey getPublicKey(byte[] byArray, String string) throws InvalidKeyException {
        try {
            return PublicKeyInfo.getPublicKey(DerCoder.decode(byArray), string);
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("Can't parse PublicKeyInfo.");
        }
    }

    public ASN1Object toASN1Object() {
        return this.b.toASN1Object();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PublicKey)) {
            return false;
        }
        return CryptoUtils.equalsBlock(this.getEncoded(), ((PublicKey)object).getEncoded());
    }

    public int hashCode() {
        return Util.calculateHashCode(this.getEncoded());
    }

    public byte[] getEncoded() {
        return this.b.toByteArray();
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getFingerprint() {
        Md5 md5 = new Md5();
        md5.update(this.encode());
        return md5.digest();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.b.writeTo(outputStream);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("This PublicKeyInfo contains a ");
        if (this.public_key_algorithm.equals(AlgorithmID.rsaEncryption)) {
            stringBuffer.append("RSA public key.");
        } else if (this.public_key_algorithm.equals(AlgorithmID.dsa)) {
            stringBuffer.append("DSA public key.");
        } else if (this.public_key_algorithm.equals(AlgorithmID.dhKeyAgreement)) {
            stringBuffer.append("DH public key.");
        } else if (this.public_key_algorithm.equals(AlgorithmID.ecPublicKey)) {
            stringBuffer.append("EC public key.");
        } else {
            stringBuffer.append(this.public_key_algorithm.getName() + " key.");
        }
        return stringBuffer.toString();
    }
}

