/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509;

import iaik.asn1.ASN1Object;
import iaik.asn1.BOOLEAN;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.EncodedASN1Object;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.utils.InternalErrorException;
import iaik.utils.ObjectFactory;
import iaik.utils.Util;
import iaik.x509.UnknownExtension;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.ErrorExtension;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public class X509Extensions {
    private static final Class P = a == null ? (a = X509Extensions.class$("iaik.x509.V3Extension")) : a;
    private static final ObjectFactory Q = new ObjectFactory();
    protected volatile Hashtable critical_extensions;
    protected volatile Hashtable noncritical_extensions;
    private int R = 4;
    private int S = 11;
    private final Object T = new Object();
    static Class a;
    static Class b;
    static Class c;
    static Class d;
    static Class e;
    static Class f;
    static Class g;
    static Class h;
    static Class i;
    static Class j;
    static Class k;
    static Class l;
    static Class m;
    static Class n;
    static Class o;
    static Class p;
    static Class q;
    static Class r;
    static Class s;
    static Class t;
    static Class u;
    static Class v;
    static Class w;
    static Class x;
    static Class y;
    static Class z;
    static Class A;
    static Class B;
    static Class C;
    static Class D;
    static Class E;
    static Class F;
    static Class G;
    static Class H;
    static Class I;
    static Class J;
    static Class K;
    static Class L;
    static Class M;
    static Class N;
    static Class O;

    public static V3Extension create(ObjectID objectID) throws InstantiationException {
        return (V3Extension)Q.create(objectID);
    }

    public static void register(ObjectID objectID, Class clazz) {
        if (!P.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class " + clazz + " is no V3Extension implementation!");
        }
        Q.register((Object)objectID, clazz);
    }

    public X509Extensions() {
    }

    public X509Extensions(int n2, int n3) {
        this();
        this.R = n2;
        this.S = n3;
    }

    public X509Extensions(ASN1Object aSN1Object) throws X509ExtensionException {
        this();
        this.parseExtensions(aSN1Object);
    }

    public boolean addExtension(V3Extension v3Extension) throws X509ExtensionException {
        ASN1Object aSN1Object = v3Extension.toASN1Object();
        byte[] byArray = aSN1Object == null ? new byte[]{} : DerCoder.encode(aSN1Object);
        ObjectID objectID = v3Extension.getObjectID();
        if (v3Extension.isCritical()) {
            if (this.noncritical_extensions != null && this.noncritical_extensions.get(objectID) != null) {
                throw new IllegalArgumentException(objectID.getName() + " has been already added as non critical extension!");
            }
            this.createExtensionsTable(true);
            return this.critical_extensions.put(objectID, byArray) != null;
        }
        if (this.critical_extensions != null && this.critical_extensions.get(objectID) != null) {
            throw new IllegalArgumentException(objectID.getName() + " has been already added as critical extension!");
        }
        this.createExtensionsTable(false);
        return this.noncritical_extensions.put(objectID, byArray) != null;
    }

    public boolean removeExtension(ObjectID objectID) {
        if (this.critical_extensions != null && this.critical_extensions.remove(objectID) != null) {
            return true;
        }
        if (this.noncritical_extensions != null && this.noncritical_extensions.remove(objectID) != null) {
            return true;
        }
        return true;
    }

    public void removeAllExtensions() {
        if (this.critical_extensions != null) {
            this.critical_extensions.clear();
            this.critical_extensions = null;
        }
        if (this.noncritical_extensions != null) {
            this.noncritical_extensions.clear();
            this.noncritical_extensions = null;
        }
    }

    public Enumeration listExtensions() {
        ObjectID objectID;
        Enumeration enumeration;
        Vector<V3Extension> vector = new Vector<V3Extension>();
        if (this.critical_extensions != null) {
            enumeration = this.critical_extensions.keys();
            while (enumeration.hasMoreElements()) {
                objectID = (ObjectID)enumeration.nextElement();
                try {
                    vector.addElement(this.getExtension(objectID));
                }
                catch (X509ExtensionInitException x509ExtensionInitException) {
                    vector.addElement(new ErrorExtension(objectID, true, x509ExtensionInitException.getMessage()));
                }
            }
        }
        if (this.noncritical_extensions != null) {
            enumeration = this.noncritical_extensions.keys();
            while (enumeration.hasMoreElements()) {
                objectID = (ObjectID)enumeration.nextElement();
                try {
                    vector.addElement(this.getExtension(objectID));
                }
                catch (X509ExtensionInitException x509ExtensionInitException) {
                    vector.addElement(new ErrorExtension(objectID, false, x509ExtensionInitException.getMessage()));
                }
            }
        }
        return vector.elements();
    }

    public boolean hasExtensions() {
        boolean bl = false;
        if (this.critical_extensions != null) {
            boolean bl2 = bl = !this.critical_extensions.isEmpty();
        }
        if (!bl && this.noncritical_extensions != null) {
            bl = !this.noncritical_extensions.isEmpty();
        }
        return bl;
    }

    public int countExtensions() {
        int n2 = this.critical_extensions == null ? 0 : this.critical_extensions.size();
        int n3 = this.noncritical_extensions == null ? 0 : this.noncritical_extensions.size();
        return n2 + n3;
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        byte[] byArray = null;
        boolean bl = true;
        if (this.critical_extensions != null) {
            byArray = (byte[])this.critical_extensions.get(objectID);
        }
        if (byArray == null) {
            if (this.noncritical_extensions != null) {
                byArray = (byte[])this.noncritical_extensions.get(objectID);
            }
            if (byArray == null) {
                return null;
            }
            bl = false;
        }
        V3Extension v3Extension = null;
        try {
            v3Extension = X509Extensions.create(objectID);
        }
        catch (InstantiationException instantiationException) {
            v3Extension = new UnknownExtension(objectID);
        }
        v3Extension.setCritical(bl);
        if (byArray.length > 0) {
            try {
                ASN1Object aSN1Object = DerCoder.decode(byArray);
                v3Extension.init(aSN1Object);
            }
            catch (X509ExtensionException x509ExtensionException) {
                throw new X509ExtensionInitException(this, objectID, bl, x509ExtensionException.toString(), x509ExtensionException){
                    private static final long serialVersionUID = 5967316399896097627L;
                    private final X509ExtensionException c;
                    private final X509Extensions d;
                    {
                        this.d = x509Extensions;
                        this.c = x509ExtensionException;
                    }

                    public Throwable getCause() {
                        return this.c;
                    }
                };
            }
            catch (CodingException codingException) {
                if (v3Extension instanceof UnknownExtension) {
                    try {
                        v3Extension.init(new EncodedASN1Object(byArray));
                    }
                    catch (X509ExtensionException x509ExtensionException) {
                        throw new X509ExtensionInitException(objectID, bl, x509ExtensionException.toString());
                    }
                }
                throw new X509ExtensionInitException(this, objectID, bl, codingException.toString(), codingException){
                    private static final long serialVersionUID = 8448508552538211036L;
                    private final CodingException c;
                    private final X509Extensions d;
                    {
                        this.d = x509Extensions;
                        this.c = codingException;
                    }

                    public Throwable getCause() {
                        return this.c;
                    }
                };
            }
        }
        return v3Extension;
    }

    public Set getCriticalExtensionOIDs() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.critical_extensions != null) {
            Enumeration enumeration = this.critical_extensions.keys();
            while (enumeration.hasMoreElements()) {
                ObjectID objectID = (ObjectID)enumeration.nextElement();
                hashSet.add(objectID.getID());
            }
        }
        return hashSet;
    }

    public Set getNonCriticalExtensionOIDs() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.noncritical_extensions != null) {
            Enumeration enumeration = this.noncritical_extensions.keys();
            while (enumeration.hasMoreElements()) {
                ObjectID objectID = (ObjectID)enumeration.nextElement();
                hashSet.add(objectID.getID());
            }
        }
        return hashSet;
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (this.critical_extensions != null) {
            try {
                Enumeration enumeration = this.critical_extensions.keys();
                while (enumeration.hasMoreElements()) {
                    V3Extension v3Extension = this.getExtension((ObjectID)enumeration.nextElement());
                    if (!(v3Extension instanceof UnknownExtension)) continue;
                    return true;
                }
            }
            catch (X509ExtensionInitException x509ExtensionInitException) {
                return true;
            }
        }
        return false;
    }

    public byte[] getExtensionValue(String string) {
        byte[] byArray = this.getRawExtensionValue(string);
        if (byArray != null) {
            byArray = DerCoder.encode(new OCTET_STRING(byArray));
        }
        return byArray;
    }

    public byte[] getRawExtensionValue(String string) {
        byte[] byArray = null;
        ObjectID objectID = ObjectID.getObjectID(string);
        Object var4_4 = null;
        if (this.critical_extensions != null) {
            var4_4 = this.critical_extensions.get(objectID);
        }
        if (var4_4 != null) {
            byArray = var4_4;
        } else if (this.noncritical_extensions != null) {
            byArray = (byte[])this.noncritical_extensions.get(objectID);
        }
        return byArray;
    }

    boolean a(ObjectID objectID) {
        boolean bl = false;
        if (this.critical_extensions != null) {
            boolean bl2 = bl = this.critical_extensions.get(objectID) != null;
        }
        if (!bl && this.noncritical_extensions != null) {
            bl = this.noncritical_extensions.get(objectID) != null;
        }
        return bl;
    }

    protected void parseExtensions(ASN1Object aSN1Object) throws X509ExtensionException {
        try {
            for (int i2 = 0; i2 < aSN1Object.countComponents(); ++i2) {
                boolean bl = false;
                ASN1Object aSN1Object2 = aSN1Object.getComponentAt(i2);
                ObjectID objectID = (ObjectID)aSN1Object2.getComponentAt(0);
                int n2 = aSN1Object2.countComponents();
                if (n2 == 3) {
                    bl = (Boolean)aSN1Object2.getComponentAt(1).getValue();
                }
                byte[] byArray = (byte[])aSN1Object2.getComponentAt(n2 - 1).getValue();
                if (bl) {
                    this.createExtensionsTable(true);
                    this.critical_extensions.put(objectID, byArray);
                    continue;
                }
                this.createExtensionsTable(false);
                this.noncritical_extensions.put(objectID, byArray);
            }
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException(codingException.getMessage());
        }
    }

    public void decode(ASN1Object aSN1Object) throws X509ExtensionException {
        this.parseExtensions(aSN1Object);
    }

    public ASN1Object toASN1Object() throws X509ExtensionException {
        byte[] byArray;
        ObjectID objectID;
        Enumeration enumeration;
        SEQUENCE sEQUENCE = null;
        SEQUENCE sEQUENCE2 = null;
        sEQUENCE2 = new SEQUENCE();
        if (this.critical_extensions != null) {
            enumeration = this.critical_extensions.keys();
            while (enumeration.hasMoreElements()) {
                sEQUENCE = new SEQUENCE();
                objectID = (ObjectID)enumeration.nextElement();
                sEQUENCE.addComponent(objectID);
                sEQUENCE.addComponent(new BOOLEAN(true));
                byArray = (byte[])this.critical_extensions.get(objectID);
                if (byArray == null) {
                    throw new InternalErrorException("Extension value = null!");
                }
                sEQUENCE.addComponent(new OCTET_STRING(byArray));
                sEQUENCE2.addComponent(sEQUENCE);
            }
        }
        if (this.noncritical_extensions != null) {
            enumeration = this.noncritical_extensions.keys();
            while (enumeration.hasMoreElements()) {
                sEQUENCE = new SEQUENCE();
                objectID = (ObjectID)enumeration.nextElement();
                sEQUENCE.addComponent(objectID);
                byArray = (byte[])this.noncritical_extensions.get(objectID);
                if (byArray == null) {
                    throw new InternalErrorException("Extension value = null!");
                }
                sEQUENCE.addComponent(new OCTET_STRING(byArray));
                sEQUENCE2.addComponent(sEQUENCE);
            }
        }
        return sEQUENCE2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createExtensionsTable(boolean bl) {
        if (bl) {
            Hashtable hashtable = this.critical_extensions;
            if (hashtable == null) {
                Object object = this.T;
                synchronized (object) {
                    hashtable = this.critical_extensions;
                    if (hashtable == null) {
                        this.critical_extensions = hashtable = new Hashtable(this.R, 0.75f);
                    }
                }
            }
        } else {
            Hashtable hashtable = this.noncritical_extensions;
            if (this.noncritical_extensions == null) {
                Object object = this.T;
                synchronized (object) {
                    hashtable = this.noncritical_extensions;
                    if (hashtable == null) {
                        this.noncritical_extensions = hashtable = new Hashtable(this.S, 0.75f);
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        V3Extension v3Extension = null;
        Enumeration enumeration = this.listExtensions();
        int n2 = 1;
        while (enumeration.hasMoreElements()) {
            v3Extension = (V3Extension)enumeration.nextElement();
            stringBuffer.append("Extension " + n2 + ":     ");
            if (v3Extension.isCritical()) {
                stringBuffer.append("critical        ");
            } else {
                stringBuffer.append("not critical    ");
            }
            String string = v3Extension.getName();
            if (string == null || string.trim().length() == 0) {
                stringBuffer.append("Unknown Extension");
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append("\n");
            stringBuffer.append(v3Extension + "\n\n");
            ++n2;
        }
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        X509Extensions.register(ObjectID.certExt_AuthorityKeyIdentifier, b == null ? (b = X509Extensions.class$("iaik.x509.extensions.AuthorityKeyIdentifier")) : b);
        X509Extensions.register(ObjectID.certExt_BasicConstraints, c == null ? (c = X509Extensions.class$("iaik.x509.extensions.BasicConstraints")) : c);
        X509Extensions.register(ObjectID.certExt_CertificatePolicies, d == null ? (d = X509Extensions.class$("iaik.x509.extensions.CertificatePolicies")) : d);
        X509Extensions.register(ObjectID.certExt_CrlDistributionPoints, e == null ? (e = X509Extensions.class$("iaik.x509.extensions.CRLDistributionPoints")) : e);
        X509Extensions.register(ObjectID.certExt_ExtendedKeyUsage, f == null ? (f = X509Extensions.class$("iaik.x509.extensions.ExtendedKeyUsage")) : f);
        X509Extensions.register(ObjectID.certExt_IssuerAltName, g == null ? (g = X509Extensions.class$("iaik.x509.extensions.IssuerAltName")) : g);
        X509Extensions.register(ObjectID.certExt_KeyUsage, h == null ? (h = X509Extensions.class$("iaik.x509.extensions.KeyUsage")) : h);
        X509Extensions.register(ObjectID.certExt_NameConstraints, i == null ? (i = X509Extensions.class$("iaik.x509.extensions.NameConstraints")) : i);
        X509Extensions.register(ObjectID.certExt_PolicyConstraints, j == null ? (j = X509Extensions.class$("iaik.x509.extensions.PolicyConstraints")) : j);
        X509Extensions.register(ObjectID.certExt_PolicyMappings, k == null ? (k = X509Extensions.class$("iaik.x509.extensions.PolicyMappings")) : k);
        X509Extensions.register(ObjectID.certExt_PrivateKeyUsagePeriod, l == null ? (l = X509Extensions.class$("iaik.x509.extensions.PrivateKeyUsagePeriod")) : l);
        X509Extensions.register(ObjectID.certExt_SubjectAltName, m == null ? (m = X509Extensions.class$("iaik.x509.extensions.SubjectAltName")) : m);
        X509Extensions.register(ObjectID.certExt_SubjectKeyIdentifier, n == null ? (n = X509Extensions.class$("iaik.x509.extensions.SubjectKeyIdentifier")) : n);
        X509Extensions.register(ObjectID.certExt_SubjectDirectoryAttributes, o == null ? (o = X509Extensions.class$("iaik.x509.extensions.SubjectDirectoryAttributes")) : o);
        X509Extensions.register(ObjectID.certExt_AuthorityInfoAccess, p == null ? (p = X509Extensions.class$("iaik.x509.extensions.AuthorityInfoAccess")) : p);
        X509Extensions.register(ObjectID.certExt_SubjectInfoAccess, q == null ? (q = X509Extensions.class$("iaik.x509.extensions.SubjectInfoAccess")) : q);
        X509Extensions.register(ObjectID.certExt_InhibitAnyPolicy, r == null ? (r = X509Extensions.class$("iaik.x509.extensions.InhibitAnyPolicy")) : r);
        X509Extensions.register(ObjectID.certExt_FreshestCRL, s == null ? (s = X509Extensions.class$("iaik.x509.extensions.FreshestCRL")) : s);
        X509Extensions.register(ObjectID.smimeCapabilities, t == null ? (t = X509Extensions.class$("iaik.x509.extensions.smime.SMIMECapabilities")) : t);
        X509Extensions.register(ObjectID.crlExt_CrlNumber, u == null ? (u = X509Extensions.class$("iaik.x509.extensions.CRLNumber")) : u);
        X509Extensions.register(ObjectID.crlExt_DeltaCRLIndicator, v == null ? (v = X509Extensions.class$("iaik.x509.extensions.DeltaCRLIndicator")) : v);
        X509Extensions.register(ObjectID.crlExt_IssuingDistributionPoint, w == null ? (w = X509Extensions.class$("iaik.x509.extensions.IssuingDistributionPoint")) : w);
        X509Extensions.register(ObjectID.crlExt_ReasonCode, x == null ? (x = X509Extensions.class$("iaik.x509.extensions.ReasonCode")) : x);
        X509Extensions.register(ObjectID.crlExt_HoldInstructionCode, y == null ? (y = X509Extensions.class$("iaik.x509.extensions.HoldInstructionCode")) : y);
        X509Extensions.register(ObjectID.crlExt_InvalidityDate, z == null ? (z = X509Extensions.class$("iaik.x509.extensions.InvalidityDate")) : z);
        X509Extensions.register(ObjectID.crlExt_CertificateIssuer, A == null ? (A = X509Extensions.class$("iaik.x509.extensions.CertificateIssuer")) : A);
        X509Extensions.register(ObjectID.crlExt_ExpiredCertsOnCRL, B == null ? (B = X509Extensions.class$("iaik.x509.extensions.ExpiredCertsOnCRL")) : B);
        X509Extensions.register(ObjectID.certExt_NetscapeBaseUrl, C == null ? (C = X509Extensions.class$("iaik.x509.extensions.netscape.NetscapeBaseUrl")) : C);
        X509Extensions.register(ObjectID.certExt_NetscapeCaPolicyUrl, D == null ? (D = X509Extensions.class$("iaik.x509.extensions.netscape.NetscapeCaPolicyUrl")) : D);
        X509Extensions.register(ObjectID.certExt_NetscapeCaRevocationUrl, E == null ? (E = X509Extensions.class$("iaik.x509.extensions.netscape.NetscapeCaRevocationUrl")) : E);
        X509Extensions.register(ObjectID.certExt_NetscapeCertRenewalUrl, F == null ? (F = X509Extensions.class$("iaik.x509.extensions.netscape.NetscapeCertRenewalUrl")) : F);
        X509Extensions.register(ObjectID.certExt_NetscapeCertType, G == null ? (G = X509Extensions.class$("iaik.x509.extensions.netscape.NetscapeCertType")) : G);
        X509Extensions.register(ObjectID.certExt_NetscapeComment, H == null ? (H = X509Extensions.class$("iaik.x509.extensions.netscape.NetscapeComment")) : H);
        X509Extensions.register(ObjectID.certExt_NetscapeRevocationUrl, I == null ? (I = X509Extensions.class$("iaik.x509.extensions.netscape.NetscapeRevocationUrl")) : I);
        X509Extensions.register(ObjectID.certExt_NetscapeSSLServerName, J == null ? (J = X509Extensions.class$("iaik.x509.extensions.netscape.NetscapeSSLServerName")) : J);
        X509Extensions.register(ObjectID.certExt_BiometricInfo, K == null ? (K = X509Extensions.class$("iaik.x509.extensions.qualified.BiometricInfo")) : K);
        X509Extensions.register(ObjectID.certExt_QcStatements, L == null ? (L = X509Extensions.class$("iaik.x509.extensions.qualified.QCStatements")) : L);
        X509Extensions.register(ObjectID.certExt_NoCheck, M == null ? (M = X509Extensions.class$("iaik.x509.extensions.ocsp.NoCheck")) : M);
        X509Extensions.register(ObjectID.certExt_PublicAuthorityIdentifier, N == null ? (N = X509Extensions.class$("iaik.x509.extensions.priv.PublicAuthorityIdentifier")) : N);
        X509Extensions.register(ObjectID.certExt_PublicServiceProvider, O == null ? (O = X509Extensions.class$("iaik.x509.extensions.priv.PublicServiceProvider")) : O);
        Util.toString(null, -1, 1);
    }
}

