/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr.attributes;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.ConstructedType;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.SET;
import iaik.asn1.structures.AttributeValue;
import iaik.utils.Util;
import iaik.x509.attr.SecurityCategory;
import iaik.x509.attr.UnknownSecurityCategory;
import java.util.Enumeration;
import java.util.Hashtable;

public class Clearance
extends AttributeValue {
    public static final ObjectID oid = ObjectID.clearance;
    public static final int UNMARKED = 1;
    public static final int UNCLASSIFIED = 2;
    public static final int RESTRICTED = 4;
    public static final int CONFIDENTIAL = 8;
    public static final int SECRET = 16;
    public static final int TOP_SECRET = 32;
    private static Hashtable a = new Hashtable(10);
    private ObjectID b;
    private int c = 2;
    private SecurityCategory[] d;

    public static void setSecurityClassificationName(int n2, String string) {
        if (n2 < 64) {
            throw new IllegalArgumentException("Bits 0 through 5 are reserved for basic security classification hierachy.");
        }
        String string2 = Integer.toBinaryString(n2);
        int n3 = 0;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string2.charAt(i2) != '1' || ++n3 <= 1) continue;
            StringBuffer stringBuffer = new StringBuffer(string2);
            stringBuffer.reverse();
            throw new IllegalArgumentException("Invalid security classification value: " + stringBuffer.toString() + ". Only one bit must be set!");
        }
        a.put(new Integer(n2), string);
    }

    public static String getSecurityClassificationName(int n2) {
        Object v2;
        if (a != null && (v2 = a.get(new Integer(n2))) instanceof String) {
            return (String)v2;
        }
        return null;
    }

    public Clearance() {
    }

    public Clearance(ObjectID objectID) {
        this();
        if (objectID == null) {
            throw new NullPointerException("policy id must not be null!");
        }
        this.b = objectID;
    }

    public Clearance(ASN1Object aSN1Object) throws CodingException {
        this();
        this.decode(aSN1Object);
    }

    public ObjectID getPolicyId() {
        return this.b;
    }

    public void setClassList(int n2) throws IllegalArgumentException {
        if (n2 < 1) {
            throw new IllegalArgumentException("Invalid classList value: " + n2 + ". Must be > 0");
        }
        this.c = n2;
    }

    public int getClassList() {
        return this.c;
    }

    public boolean isSecurityClassificationValueSet(int n2) {
        return (this.c & n2) != 0;
    }

    public boolean isClassListBitSet(int n2) {
        boolean bl = false;
        String string = this.getClassListAsBinaryString();
        if (n2 < string.length()) {
            bl = string.charAt(n2) == '1';
        }
        return bl;
    }

    public boolean[] getClassListAsBooleanArray() {
        StringBuffer stringBuffer = new StringBuffer(Integer.toBinaryString(this.c));
        int n2 = stringBuffer.length();
        boolean[] blArray = new boolean[n2 < 6 ? 6 : n2];
        int n3 = 0;
        for (int i2 = this.c; i2 != 0; i2 >>= 1) {
            if ((i2 & 1) != 0) {
                blArray[n3] = true;
            }
            ++n3;
        }
        return blArray;
    }

    public String getClassListAsBinaryString() {
        StringBuffer stringBuffer = new StringBuffer(Integer.toBinaryString(this.c));
        stringBuffer.reverse();
        int n2 = stringBuffer.length();
        if (n2 < 6) {
            for (int i2 = n2; i2 < 6; ++i2) {
                stringBuffer.append('0');
            }
        }
        return stringBuffer.toString();
    }

    public String getClassListBitNames() {
        StringBuffer stringBuffer = new StringBuffer();
        if (a != null) {
            Enumeration enumeration = a.keys();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                Integer n3 = (Integer)enumeration.nextElement();
                if ((n3 & this.c) == 0) continue;
                if (n2++ > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(a.get(n3));
            }
        }
        return stringBuffer.toString();
    }

    public void setSecurityCategories(SecurityCategory[] securityCategoryArray) {
        this.d = securityCategoryArray != null ? securityCategoryArray : null;
    }

    public SecurityCategory[] getSecurityCategories() {
        return this.d == null ? new SecurityCategory[]{} : this.d;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        ObjectID objectID;
        if (aSN1Object == null) {
            throw new NullPointerException("Cannot decode null!");
        }
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("Invalid ASN.1 type: " + aSN1Object.getAsnType().getName() + ". Expected SEQUENCE!");
        }
        int n2 = aSN1Object.countComponents();
        if (n2 < 1 || n2 > 3) {
            throw new CodingException("Invalid number of components: " + n2);
        }
        int n3 = 2;
        SecurityCategory[] securityCategoryArray = null;
        ASN1Object aSN1Object2 = aSN1Object.getComponentAt(0);
        if (!aSN1Object2.isA(ASN.CON_SPEC)) {
            if (!aSN1Object2.isA(ASN.ObjectID)) {
                throw new CodingException("Invalid ASN.1 type (" + aSN1Object.getAsnType().getName() + ") of first (policyID) component. Expected OBJECT IDENTIFIER or CON_SPEC!");
            }
            objectID = (ObjectID)aSN1Object2;
        } else {
            CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object2;
            int n4 = cON_SPEC.getAsnType().getTag();
            if (n4 != 0) {
                throw new CodingException("Invalid tag number (" + n4 + ") of first (policyID) component. Expected 0!");
            }
            cON_SPEC.forceImplicitlyTagged(ASN.ObjectID);
            objectID = (ObjectID)cON_SPEC.getValue();
        }
        if (n2 > 1) {
            for (int i2 = 1; i2 < n2; ++i2) {
                ASN1Object aSN1Object3;
                aSN1Object2 = aSN1Object.getComponentAt(i2);
                if (!aSN1Object2.isA(ASN.CON_SPEC)) {
                    if (aSN1Object2.isA(ASN.BIT_STRING)) {
                        n3 = Clearance.a((BIT_STRING)aSN1Object2);
                        continue;
                    }
                    if (aSN1Object2.isA(ASN.SET)) {
                        securityCategoryArray = Clearance.a((SET)aSN1Object2);
                        continue;
                    }
                    throw new CodingException("Invalid ASN.1 type (" + aSN1Object.getAsnType().getName() + ") of component " + (i2 + 1));
                }
                CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object2;
                int n5 = cON_SPEC.getAsnType().getTag();
                if (n5 == 1) {
                    cON_SPEC.forceImplicitlyTagged(ASN.BIT_STRING);
                    aSN1Object3 = (BIT_STRING)cON_SPEC.getValue();
                    n3 = Clearance.a(aSN1Object3);
                    continue;
                }
                if (n5 == 2) {
                    cON_SPEC.forceImplicitlyTagged(ASN.SET);
                    aSN1Object3 = (SET)cON_SPEC.getValue();
                    securityCategoryArray = Clearance.a((SET)aSN1Object3);
                    continue;
                }
                throw new CodingException("Invalid component tag: " + n5);
            }
        }
        this.b = objectID;
        this.c = n3;
        this.d = securityCategoryArray;
    }

    private static int a(BIT_STRING bIT_STRING) {
        StringBuffer stringBuffer = new StringBuffer(bIT_STRING.getBinaryString()).reverse();
        return Integer.parseInt(stringBuffer.toString(), 2);
    }

    private static SecurityCategory[] a(SET sET) throws CodingException {
        int n2 = sET.countComponents();
        SecurityCategory[] securityCategoryArray = new SecurityCategory[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            SecurityCategory securityCategory;
            ASN1Object aSN1Object = sET.getComponentAt(i2);
            CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object.getComponentAt(0);
            cON_SPEC.forceImplicitlyTagged(ASN.ObjectID);
            ObjectID objectID = (ObjectID)cON_SPEC.getValue();
            try {
                securityCategory = SecurityCategory.create(objectID);
            }
            catch (InstantiationException instantiationException) {
                securityCategory = new UnknownSecurityCategory(objectID);
            }
            securityCategory.decode(aSN1Object.getComponentAt(1));
            securityCategoryArray[i2] = securityCategory;
        }
        return securityCategoryArray;
    }

    public ASN1Object toASN1Object() throws CodingException {
        return this.toASN1Object(false);
    }

    public ASN1Object toASN1Object(boolean bl) throws CodingException {
        ASN1Object aSN1Object;
        if (this.b == null) {
            throw new NullPointerException("Cannot encode Clearance. Missing policy id!");
        }
        boolean bl2 = true;
        SEQUENCE sEQUENCE = new SEQUENCE();
        ASN1Object aSN1Object2 = this.b;
        if (bl) {
            aSN1Object2 = new CON_SPEC(0, this.b, bl2);
        }
        sEQUENCE.addComponent(aSN1Object2);
        if (this.c != 2) {
            StringBuffer stringBuffer = new StringBuffer(Integer.toBinaryString(this.c));
            stringBuffer.reverse();
            aSN1Object = new BIT_STRING(stringBuffer.toString());
            ASN1Object aSN1Object3 = aSN1Object;
            if (bl) {
                aSN1Object3 = new CON_SPEC(1, aSN1Object, bl2);
            }
            sEQUENCE.addComponent(aSN1Object3);
        }
        if (this.d != null && this.d.length > 0) {
            boolean bl3 = true;
            aSN1Object = new SET(bl3);
            for (int i2 = 0; i2 < this.d.length; ++i2) {
                SEQUENCE sEQUENCE2 = new SEQUENCE();
                ((ASN1Object)sEQUENCE2).addComponent(new CON_SPEC(0, this.d[i2].getType(), bl2));
                ((ASN1Object)sEQUENCE2).addComponent(this.d[i2].toASN1Object());
                ((ConstructedType)aSN1Object).addComponent(sEQUENCE2);
            }
            ASN1Object aSN1Object4 = aSN1Object;
            if (bl) {
                aSN1Object4 = new CON_SPEC(2, aSN1Object, bl2);
            }
            sEQUENCE.addComponent(aSN1Object4);
        }
        return sEQUENCE;
    }

    public ObjectID getAttributeType() {
        return oid;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        Object v2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.b != null) {
            stringBuffer.append("policy-id: " + this.b.getName());
        }
        stringBuffer.append("\nclass-list: " + this.getClassListAsBinaryString());
        if (a != null && (v2 = a.get(new Integer(this.c))) != null) {
            stringBuffer.append(" (" + v2 + ")");
        }
        if (this.d != null && this.d.length > 0) {
            int n2 = this.d.length;
            stringBuffer.append("\nThis Clearance contains " + n2 + " security categor" + (n2 == 1 ? "y:" : "ies:"));
            for (int i2 = 0; i2 < n2; ++i2) {
                if (bl) {
                    stringBuffer.append("\nSecurityCategory No " + (i2 + 1) + " (type: " + this.d[i2].getType().getName() + "): {\n");
                    Util.printIndented(this.d[i2].toString(), true, "  ", stringBuffer);
                    stringBuffer.append("\n}");
                    continue;
                }
                if (i2 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.d[i2].getType().getName());
            }
        }
        return stringBuffer.toString();
    }

    static {
        a.put(new Integer(1), "unmarked");
        a.put(new Integer(2), "unclassified");
        a.put(new Integer(4), "restricted");
        a.put(new Integer(8), "confidential");
        a.put(new Integer(16), "secret");
        a.put(new Integer(32), "topSecret");
    }
}

