/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr.attributes;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AttributeValue;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.utils.Util;
import iaik.x509.attr.AttCertIssuer;
import iaik.x509.attr.AttributeCertificate;
import iaik.x509.attr.Holder;
import iaik.x509.attr.IssuerSerial;
import iaik.x509.attr.V1Form;
import iaik.x509.attr.V2Form;
import java.util.Enumeration;

public class Role
extends AttributeValue {
    public static final ObjectID oid = ObjectID.role;
    private GeneralNames a;
    private GeneralName b;

    public Role() {
    }

    public Role(GeneralName generalName) {
        if (generalName == null) {
            throw new NullPointerException("roleName must not be null!");
        }
        this.b = generalName;
    }

    public Role(ASN1Object aSN1Object) throws CodingException {
        this();
        this.decode(aSN1Object);
    }

    public GeneralName getRoleName() {
        return this.b;
    }

    public GeneralNames getRoleAuthority() {
        return this.a;
    }

    public void setRoleAuthority(GeneralNames generalNames) {
        this.a = generalNames;
    }

    public GeneralNames setRoleAuthority(AttributeCertificate attributeCertificate) {
        AttCertIssuer attCertIssuer = attributeCertificate.getIssuer();
        if (attCertIssuer != null) {
            if (attCertIssuer.getVForm() == 1) {
                this.a = ((V1Form)attCertIssuer).getGeneralNames();
            } else {
                IssuerSerial issuerSerial;
                this.a = ((V2Form)attCertIssuer).getIssuerName();
                if (this.a == null && (issuerSerial = ((V2Form)attCertIssuer).getBaseCertificateID()) != null) {
                    this.a = issuerSerial.getIssuer();
                }
            }
        }
        return this.a;
    }

    public boolean roleSpecifiedBy(AttributeCertificate attributeCertificate) {
        if (attributeCertificate == null) {
            throw new NullPointerException("roleSpecificationCertificate must not be null!");
        }
        boolean bl = false;
        Holder holder = attributeCertificate.getHolder();
        GeneralNames generalNames = holder.getEntityName();
        if (generalNames != null && generalNames.contains(this.b)) {
            if (this.a != null) {
                AttCertIssuer attCertIssuer = attributeCertificate.getIssuer();
                if (attCertIssuer != null) {
                    GeneralNames generalNames2 = null;
                    if (attCertIssuer.getVForm() == 1) {
                        generalNames2 = ((V1Form)attCertIssuer).getGeneralNames();
                        if (generalNames2 != null && Role.a(this.a, generalNames2)) {
                            bl = true;
                        }
                    } else {
                        IssuerSerial issuerSerial;
                        generalNames2 = ((V2Form)attCertIssuer).getIssuerName();
                        if (generalNames2 != null && Role.a(this.a, generalNames2)) {
                            bl = true;
                        }
                        if (!bl && (issuerSerial = ((V2Form)attCertIssuer).getBaseCertificateID()) != null && (generalNames2 = issuerSerial.getIssuer()) != null && Role.a(this.a, generalNames2)) {
                            bl = true;
                        }
                    }
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private static boolean a(GeneralNames generalNames, GeneralNames generalNames2) {
        boolean bl = false;
        Enumeration enumeration = generalNames.getNames();
        while (enumeration.hasMoreElements()) {
            if (!generalNames2.contains((GeneralName)enumeration.nextElement())) continue;
            bl = true;
        }
        return bl;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object == null) {
            throw new NullPointerException("Cannot parse null ASN1Object.");
        }
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("Invalid ASN.1 type " + aSN1Object.getAsnType() + ". Expected SEQUENCE.");
        }
        int n2 = aSN1Object.countComponents();
        if (n2 < 1) {
            throw new CodingException("Invalid number of components: " + n2 + ". roleName must be present.");
        }
        if (n2 > 2) {
            throw new CodingException("Invalid number of components: " + n2 + ". Role can only hold up to 2 components.");
        }
        block4: for (int i2 = 0; i2 < n2; ++i2) {
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(i2);
            if (!aSN1Object2.isA(ASN.CON_SPEC)) {
                throw new CodingException("Invalid ASN.1 type " + aSN1Object.getAsnType() + ". Expected CON SPEC.");
            }
            CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object2;
            int n3 = cON_SPEC.getAsnType().getTag();
            switch (n3) {
                case 0: {
                    cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
                    this.a = new GeneralNames((ASN1Object)cON_SPEC.getValue());
                    continue block4;
                }
                case 1: {
                    this.b = new GeneralName((ASN1Object)cON_SPEC.getValue());
                    continue block4;
                }
                default: {
                    throw new CodingException("Invalid tag " + n3 + ". Expected 0 or 1!");
                }
            }
        }
    }

    public ASN1Object toASN1Object() throws CodingException {
        if (this.b == null) {
            throw new NullPointerException("roleName must not be null!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.a != null) {
            sEQUENCE.addComponent(new CON_SPEC(0, this.a.toASN1Object(), true));
        }
        sEQUENCE.addComponent(new CON_SPEC(1, this.b.toASN1Object(), false));
        return sEQUENCE;
    }

    public ObjectID getAttributeType() {
        return oid;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append("roleAuthority: {\n");
            Util.printIndented(this.a.toString(), true, "    ", stringBuffer);
            stringBuffer.append("\n}\n");
        }
        if (this.b != null) {
            stringBuffer.append("roleName: {\n");
            Util.printIndented(this.b.toString(), true, "    ", stringBuffer);
            stringBuffer.append("\n}");
        } else {
            stringBuffer.append("");
        }
        return stringBuffer.toString();
    }
}

