/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr.attributes;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AttributeValue;
import iaik.asn1.structures.GeneralName;
import iaik.utils.Util;

public abstract class SvceAuthInfo
extends AttributeValue {
    private GeneralName b;
    private GeneralName c;
    OCTET_STRING a;

    protected SvceAuthInfo() {
    }

    protected SvceAuthInfo(GeneralName generalName, GeneralName generalName2) {
        if (generalName == null) {
            throw new NullPointerException("service must not be null!");
        }
        if (generalName2 == null) {
            throw new NullPointerException("ident must not be null!");
        }
        this.b = generalName;
        this.c = generalName2;
    }

    protected SvceAuthInfo(ASN1Object aSN1Object) throws CodingException {
        this.decode(aSN1Object);
    }

    public GeneralName getService() {
        return this.b;
    }

    public GeneralName getIdent() {
        return this.c;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object == null) {
            throw new NullPointerException("Cannot parse null ASN1Object!");
        }
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("Invalid ASN.1 type: " + aSN1Object.getAsnType().getName() + ". Expected SEQUENCE!");
        }
        int n2 = aSN1Object.countComponents();
        if (n2 < 2) {
            throw new CodingException("Invalid number of components: " + n2 + ". Must contain service and ident.");
        }
        if (n2 > 3) {
            throw new CodingException("Invalid number of components: " + n2 + ". Only up to 3 allowed.");
        }
        OCTET_STRING oCTET_STRING = null;
        ASN1Object aSN1Object2 = aSN1Object.getComponentAt(0);
        if (!aSN1Object2.isA(ASN.CON_SPEC)) {
            throw new CodingException("First component has invalid ASN.1 type: " + aSN1Object2.getAsnType().getName() + ". Expected CON_SPEC!");
        }
        GeneralName generalName = new GeneralName(aSN1Object2);
        aSN1Object2 = aSN1Object.getComponentAt(1);
        if (!aSN1Object2.isA(ASN.CON_SPEC)) {
            throw new CodingException("Second component has invalid ASN.1 type: " + aSN1Object2.getAsnType().getName() + ". Expected CON_SPEC!");
        }
        GeneralName generalName2 = new GeneralName(aSN1Object2);
        if (n2 == 3) {
            aSN1Object2 = aSN1Object.getComponentAt(2);
            if (!aSN1Object2.isA(ASN.OCTET_STRING)) {
                throw new CodingException("Third component has invalid ASN.1 type: " + aSN1Object2.getAsnType().getName() + ". Expected OCTET STRING!");
            }
            oCTET_STRING = (OCTET_STRING)aSN1Object2;
        }
        this.b = generalName;
        this.c = generalName2;
        this.a = oCTET_STRING;
    }

    public ASN1Object toASN1Object() throws CodingException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.b == null) {
            throw new CodingException("service field must not be null!");
        }
        sEQUENCE.addComponent(this.b.toASN1Object());
        if (this.c == null) {
            throw new CodingException("ident field must not be null!");
        }
        sEQUENCE.addComponent(this.c.toASN1Object());
        if (this.a != null) {
            sEQUENCE.addComponent(this.a);
        }
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.b != null) {
            stringBuffer.append("service: {\n");
            Util.printIndented(this.b.toString(), true, "    ", stringBuffer);
            stringBuffer.append("\n}");
        }
        if (this.c != null) {
            stringBuffer.append("\nident: {\n");
            Util.printIndented(this.c.toString(), true, "    ", stringBuffer);
            stringBuffer.append("\n}");
        }
        if (this.a != null) {
            stringBuffer.append("\nauthInfo: {\n");
            Util.printIndented(Util.toString((byte[])this.a.getValue()), true, "    ", stringBuffer);
            stringBuffer.append("\n}");
        }
        return stringBuffer.toString();
    }
}

