/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.Name;
import iaik.pkcs.pkcs7.IssuerAndSerialNumber;
import iaik.security.md.SHA;
import iaik.utils.CryptoUtils;
import iaik.utils.InternalErrorException;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import iaik.x509.ocsp.CertID;
import iaik.x509.ocsp.OCSPException;

public class ReqCert {
    public static final int certID = 0;
    public static final int issuerSerial = 1;
    public static final int pKCert = 2;
    public static final int name = 3;
    public static final int certHash = 4;
    private int a = -1;
    private Object b;

    public ReqCert(int n2, Object object) throws IllegalArgumentException {
        switch (n2) {
            case 0: {
                if (object instanceof CertID) break;
                throw new IllegalArgumentException("Cannot create ReqCert! Expecting OCSP certID object for type certID!");
            }
            case 1: {
                if (object instanceof IssuerAndSerialNumber) break;
                throw new IllegalArgumentException("Cannot create ReqCert! Expecting IssuerAndSerialNumber object for type issuerSerial!");
            }
            case 2: {
                if (object instanceof X509Certificate) break;
                throw new IllegalArgumentException("Cannot create ReqCert! Expecting X509Certificate object for type pKCert!");
            }
            case 3: {
                if (object instanceof GeneralName) break;
                throw new IllegalArgumentException("Cannot create ReqCert! Expecting GeneralName object for type name!");
            }
            case 4: {
                if (object instanceof X509Certificate) {
                    try {
                        this.b = ReqCert.a(((X509Certificate)object).getEncoded());
                        break;
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException("Cannot create cert hash for cert: " + exception.getMessage());
                    }
                }
                if (object instanceof byte[]) {
                    this.b = object;
                    break;
                }
                throw new IllegalArgumentException("Cannot create ReqCert! Expecting X509Certificate or byte array for type certHash!");
            }
            default: {
                throw new IllegalArgumentException("Cannot create ReqCert! Illegal type specification! Type has to be in the range of 0...4!");
            }
        }
        if (n2 != 4) {
            this.b = object;
        }
        this.a = n2;
    }

    public ReqCert(ASN1Object aSN1Object) throws CodingException {
        this.a(aSN1Object);
    }

    private void a(ASN1Object aSN1Object) throws CodingException {
        if (!aSN1Object.isA(ASN.CON_SPEC)) {
            this.b = new CertID(aSN1Object);
            this.a = 0;
        } else {
            CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object;
            this.a = cON_SPEC.getAsnType().getTag();
            ASN1Object aSN1Object2 = (ASN1Object)cON_SPEC.getValue();
            switch (this.a) {
                case 0: {
                    this.b = new IssuerAndSerialNumber(aSN1Object2);
                    break;
                }
                case 1: {
                    this.b = new X509Certificate();
                    ((X509Certificate)this.b).decode(aSN1Object2);
                    break;
                }
                case 2: {
                    this.b = new GeneralName(aSN1Object2);
                    break;
                }
                case 3: {
                    this.b = aSN1Object2.getValue();
                    break;
                }
                default: {
                    throw new CodingException("Cannot parse ReqCert! Illegal type specification: Type has to be in the range of 0...4!");
                }
            }
            ++this.a;
        }
    }

    public ASN1Object toASN1Object() throws CodingException {
        ASN1Object aSN1Object = null;
        switch (this.a) {
            case 0: {
                aSN1Object = ((CertID)this.b).toASN1Object();
                break;
            }
            case 1: {
                aSN1Object = new CON_SPEC(0, ((IssuerAndSerialNumber)this.b).toASN1Object());
                break;
            }
            case 2: {
                aSN1Object = new CON_SPEC(1, ((X509Certificate)this.b).toASN1Object());
                break;
            }
            case 3: {
                aSN1Object = new CON_SPEC(2, ((GeneralName)this.b).toASN1Object());
                break;
            }
            case 4: {
                aSN1Object = new CON_SPEC(3, new OCTET_STRING((byte[])this.b));
                break;
            }
            default: {
                throw new InternalErrorException("Unknown reqCert type: " + this.a + "!");
            }
        }
        return aSN1Object;
    }

    public Object getReqCert() {
        return this.b;
    }

    private static byte[] a(byte[] byArray) {
        SHA sHA = new SHA();
        return sHA.digest(byArray);
    }

    public int getType() {
        return this.a;
    }

    public String getTypeName() {
        String string = null;
        switch (this.a) {
            case 0: {
                string = "certID";
                break;
            }
            case 1: {
                string = "issuerSerial";
                break;
            }
            case 2: {
                string = "pKCert";
                break;
            }
            case 3: {
                string = "name";
                break;
            }
            case 4: {
                string = "certHash";
                break;
            }
            default: {
                string = "undefined";
            }
        }
        return string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ReqCert)) {
            return false;
        }
        ReqCert reqCert = (ReqCert)object;
        if (this.a != reqCert.a) {
            return false;
        }
        if (this.a == 4) {
            return CryptoUtils.equalsBlock((byte[])this.b, (byte[])reqCert.b);
        }
        return this.b.equals(reqCert.b);
    }

    public boolean isReqCertFor(X509Certificate x509Certificate, X509Certificate x509Certificate2, GeneralName generalName) throws OCSPException {
        boolean bl = false;
        try {
            switch (this.a) {
                case 0: {
                    if (x509Certificate != null && x509Certificate2 != null) {
                        bl = ((CertID)this.b).isCertIDFor((Name)x509Certificate2.getSubjectDN(), x509Certificate2.getPublicKey(), x509Certificate.getSerialNumber());
                    }
                    break;
                }
                case 1: {
                    if (x509Certificate != null) {
                        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(x509Certificate);
                        bl = issuerAndSerialNumber.equals(this.b);
                    }
                    break;
                }
                case 2: {
                    if (x509Certificate != null) {
                        bl = x509Certificate.equals(this.b);
                    }
                    break;
                }
                case 3: {
                    if (generalName != null) {
                        bl = generalName.equals(this.b);
                        break;
                    }
                    if (x509Certificate != null) {
                        GeneralName generalName2 = new GeneralName(4, x509Certificate.getSubjectDN());
                        bl = generalName2.equals(this.b);
                    }
                    break;
                }
                case 4: {
                    if (x509Certificate != null) {
                        byte[] byArray = ReqCert.a(x509Certificate.getEncoded());
                        bl = CryptoUtils.equalsBlock((byte[])this.b, byArray);
                    }
                    break;
                }
                default: {
                    bl = false;
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new OCSPException(exception.getMessage());
        }
        return bl;
    }

    public int hashCode() {
        int n2 = this.a;
        switch (this.a) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                n2 += this.b.hashCode();
                break;
            }
            case 4: {
                n2 += Util.calculateHashCode((byte[])this.b);
                break;
            }
            default: {
                n2 += "undefined".hashCode();
            }
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.a) {
            case 0: {
                stringBuffer.append("certID:{\n");
                break;
            }
            case 1: {
                stringBuffer.append("issuerSerial:{\n");
                break;
            }
            case 2: {
                stringBuffer.append("pKCert:{\n");
                break;
            }
            case 3: {
                stringBuffer.append("name:{\n");
                break;
            }
            case 4: {
                stringBuffer.append("certHash: ");
                break;
            }
            default: {
                stringBuffer.append("undefined");
            }
        }
        if (this.a >= 0) {
            if (this.a == 4) {
                stringBuffer.append(Util.toString((byte[])this.b));
            } else {
                Util.printIndented(this.b.toString(), true, "  ", stringBuffer);
                stringBuffer.append("\n}");
            }
        }
        return stringBuffer.toString();
    }
}

