/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp.extensions;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import java.util.Date;

public class ArchiveCutoff
extends V3Extension {
    public static final ObjectID oid = ObjectID.ocspExt_ArchiveCutoff;
    private ChoiceOfTime a;

    public ArchiveCutoff() {
    }

    public ArchiveCutoff(Date date) {
        this.setCutoffTime(date);
    }

    public void setCutoffTime(Date date) {
        if (date == null) {
            throw new NullPointerException("cutoffTime must not be null!");
        }
        this.a = new ChoiceOfTime(date, ASN.GeneralizedTime, false);
    }

    public Date getCutoffTime() {
        return this.a == null ? null : this.a.getDate();
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        try {
            this.a = new ChoiceOfTime(aSN1Object);
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException(codingException.getMessage());
        }
    }

    public ASN1Object toASN1Object() {
        return this.a.toASN1Object();
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public String toString() {
        String string = this.a != null ? this.a.toString() : "";
        return string;
    }
}

