/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp.extensions.commonpki;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;

public class CertHash
extends V3Extension {
    public static final ObjectID oid = ObjectID.ocspExt_CertHash;
    private AlgorithmID a;
    private byte[] b;

    private static final byte[] a(AlgorithmID algorithmID, byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = null;
        try {
            messageDigest = algorithmID.getMessageDigestInstance("IAIK");
        }
        catch (Exception exception) {
            messageDigest = algorithmID.getMessageDigestInstance();
        }
        return messageDigest.digest(byArray);
    }

    public CertHash() {
    }

    public CertHash(AlgorithmID algorithmID, byte[] byArray) {
        if (algorithmID == null) {
            throw new NullPointerException("hashAlgorithm must not be null!");
        }
        if (byArray == null) {
            throw new NullPointerException("certificateHash must not be null!");
        }
        this.a = algorithmID;
        this.b = byArray;
    }

    public CertHash(AlgorithmID algorithmID, Certificate certificate) throws NoSuchAlgorithmException, CertificateException {
        if (algorithmID == null) {
            throw new NullPointerException("hashAlgorithm must not be null!");
        }
        if (certificate == null) {
            throw new NullPointerException("certificate must not be null!");
        }
        this.a = algorithmID;
        this.b = CertHash.a(algorithmID, certificate.getEncoded());
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        if (aSN1Object == null) {
            throw new NullPointerException("Cannot parse null ASN.1 obj!");
        }
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new X509ExtensionException("ASN.1 CertHash must be SEQUENCE!");
        }
        try {
            if (aSN1Object.countComponents() != 2) {
                throw new X509ExtensionException("ASN.1 CertHash must have two components!");
            }
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(0);
            this.a = new AlgorithmID(aSN1Object2);
            aSN1Object2 = aSN1Object.getComponentAt(1);
            if (!aSN1Object2.isA(ASN.OCTET_STRING)) {
                throw new X509ExtensionException("certificateHash must be OCTET STRING!");
            }
            this.b = (byte[])aSN1Object2.getValue();
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException("Error parsing ASN.1 CertHash object: " + codingException.toString());
        }
    }

    public ASN1Object toASN1Object() {
        if (this.a == null) {
            throw new NullPointerException("hashAlgorithm must not be null!");
        }
        if (this.b == null) {
            throw new NullPointerException("certificateHash must not be null!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.a.toASN1Object());
        sEQUENCE.addComponent(new OCTET_STRING(this.b));
        return sEQUENCE;
    }

    public AlgorithmID getHashAlgorithm() {
        return this.a;
    }

    public byte[] getCertificateHash() {
        return this.b;
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof CertHash) {
            CertHash certHash = (CertHash)object;
            try {
                bl = this.a.equals(certHash.a) && CryptoUtils.equalsBlock(this.b, certHash.b);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return bl;
    }

    public boolean identifiesCert(Certificate certificate) throws NoSuchAlgorithmException, CertificateException {
        if (certificate == null) {
            throw new NullPointerException("certificate must not be null!");
        }
        byte[] byArray = CertHash.a(this.a, certificate.getEncoded());
        return CryptoUtils.equalsBlock(this.b, byArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append("hashAlgorithm: " + this.a);
        }
        if (this.b != null) {
            stringBuffer.append("\ncertificateHash: " + Util.toString(this.b));
        }
        return stringBuffer.toString();
    }
}

