/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp.net.application;

import iaik.utils.ASN1InputStream;
import iaik.x509.ocsp.OCSPRequest;
import iaik.x509.ocsp.OCSPResponse;
import iaik.x509.ocsp.UnknownResponseException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ContentHandler;
import java.net.URLConnection;

public class ocsp_response
extends ContentHandler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getContent(URLConnection uRLConnection) throws IOException {
        String string = uRLConnection.getContentType();
        ASN1InputStream aSN1InputStream = new ASN1InputStream(new BufferedInputStream(uRLConnection.getInputStream()));
        try {
            if (string.equalsIgnoreCase("application/ocsp-request")) {
                OCSPRequest oCSPRequest = new OCSPRequest(aSN1InputStream);
                return oCSPRequest;
            }
            if (string.equalsIgnoreCase("application/ocsp-response")) {
                OCSPResponse oCSPResponse = new OCSPResponse(aSN1InputStream);
                return oCSPResponse;
            }
            throw new IOException("Unsupported OCSP Type: " + string);
        }
        catch (IOException iOException) {
            throw new IOException("Error in OCSP encoding: " + iOException.getMessage());
        }
        catch (UnknownResponseException unknownResponseException) {
            throw new IOException("Unknown OCSP response type: " + unknownResponseException.getResponseType());
        }
        finally {
            try {
                ((InputStream)aSN1InputStream).close();
            }
            catch (IOException iOException) {}
        }
    }
}

